#!/bin/bash

echo "[INFO] Configuring veth0 interface on host..."
ip link show veth0 &>/dev/null && ip link delete veth0

ip link add veth0 link eth0 type macvlan mode bridge
ip addr add $$SERVICE-STARTING-IP/$$SERVICE-SUBNET dev veth0
ip link set veth0 up

echo "[INFO] Adding static routes via veth0..."

# Routes to container management IPs
ip route del $$AMF-IP dev veth0 2>/dev/null || true
ip route add $$AMF-IP dev veth0

ip route del $$AUSF-IP dev veth0 2>/dev/null || true
ip route add $$AUSF-IP dev veth0

ip route del $$BSF-IP dev veth0 2>/dev/null || true
ip route add $$BSF-IP dev veth0

ip route del $$HSS-IP dev veth0 2>/dev/null || true
ip route add $$HSS-IP dev veth0

ip route del $$MME-IP dev veth0 2>/dev/null || true
ip route add $$MME-IP dev veth0

ip route del $$NRF-IP dev veth0 2>/dev/null || true
ip route add $$NRF-IP dev veth0

ip route del $$NSSF-IP dev veth0 2>/dev/null || true
ip route add $$NSSF-IP dev veth0

ip route del $$PCF-IP dev veth0 2>/dev/null || true
ip route add $$PCF-IP dev veth0

ip route del $$PCRF-IP dev veth0 2>/dev/null || true
ip route add $$PCRF-IP dev veth0

ip route del $$SCP-IP dev veth0 2>/dev/null || true
ip route add $$SCP-IP dev veth0

ip route del $$SGWC-IP dev veth0 2>/dev/null || true
ip route add $$SGWC-IP dev veth0

ip route del $$SGWU-IP dev veth0 2>/dev/null || true
ip route add $$SGWU-IP dev veth0

ip route del $$SMF-IP dev veth0 2>/dev/null || true
ip route add $$SMF-IP dev veth0

ip route del $$UDM-IP dev veth0 2>/dev/null || true
ip route add $$UDM-IP dev veth0

ip route del $$UDR-IP dev veth0 2>/dev/null || true
ip route add $$UDR-IP dev veth0



# Routes to external interfaces
ip route del $$AMF-EXTERNAL-IP dev veth0 2>/dev/null || true
ip route add $$AMF-EXTERNAL-IP dev veth0

ip route del $$MME-EXTERNAL-IP dev veth0 2>/dev/null || true
ip route add $$MME-EXTERNAL-IP dev veth0

ip route del $$SGWU-EXTERNAL-IP dev veth0 2>/dev/null || true
ip route add $$SGWU-EXTERNAL-IP dev veth0

echo "[DONE] veth0 configuration and all routes added successfully."
