/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.config;

import com.coraltele.config.ConfigureNodeV1;
import com.coraltele.config.ConfigureNodeV2;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@EntityScan(value={"com.coraltele.entities"})
@EnableJpaRepositories(value={"com.coraltele.repositories"})
@ComponentScan(value={"com.coraltele"})
public class ConfigApplication
implements ApplicationRunner {
    @Autowired
    ConfigureNodeV1 configureNodeV1;
    @Autowired
    ConfigureNodeV2 configureNodeV2;
    private static Logger logger = LogManager.getLogger(ConfigApplication.class);

    public static void main(String[] args) {
        String rootFolder = args.length >= 3 ? args[2] : "";
        String hostName = "";
        if (args.length >= 5) {
            hostName = args[4];
            rootFolder = rootFolder + "/" + hostName;
        }
        ConfigApplication.executeCommand((String)("rm -rf " + rootFolder + "/mnt/conf/container"));
        ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/mnt/conf/container/coralnms/etc/coraltele/conf"));
        ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/mnt/conf/container/coralnms/etc/coraltelecom"));
        ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/mnt/conf/container/coralnms/etc/postgresql/12/coralnms"));
        ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/mnt/conf/container/clouduc/etc/coraltele/conf"));
        ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/mnt/conf/container/clouduc/etc/coraltelecom"));
        ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/mnt/conf/container/clouduc/etc/postgresql/12/main"));
        ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/mnt/conf/container/billing/etc/coraltele/conf"));
        ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/mnt/conf/container/billing/etc/coraltelecom"));
        ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/mnt/conf/container/billing/etc/postgresql/12/billing_service"));
        ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/mnt/conf/container/billing/opt/activemq/conf"));
        if (!rootFolder.isEmpty()) {
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/keepalived"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/network"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/network/if-up.d"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/postgresql/12/main"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/var/www/html"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/apache2/sites-enabled"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/coraltelecom"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/rtpengine"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/redis"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/kamailio"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/coraltele/sipserver/conf/sip_profiles"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/coraltele/sipserver/conf/dialplan"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/coraltele/trunkgateway/conf/autoload_configs"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/coraltele/trunkgateway/conf/sip_profiles"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/coraltele/conferencegateway/conf/autoload_configs"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/coraltele/conferencegateway/conf/sip_profiles"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/coraltele/featuregateway/conf/autoload_configs"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/etc/coraltele/featuregateway/conf/sip_profiles"));
            ConfigApplication.executeCommand((String)("mkdir -p " + rootFolder + "/opt/apache-activemq-5.15.8/conf/"));
        }
        SpringApplication app = new SpringApplication(new Class[]{ConfigApplication.class});
        app.setBannerMode(Banner.Mode.OFF);
        app.run(args);
    }

    public static StringBuilder executeCommand(String command) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        StringBuilder output = new StringBuilder();
        processBuilder.command("bash", "-c", command);
        try {
            String line;
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                output.append(line + "\n");
            }
            String message = String.format("%s : Executed", command);
            logger.info(message);
        }
        catch (Exception e) {
            logger.error("Error while executing command", (Throwable)e);
        }
        return output;
    }

    public void run(ApplicationArguments arguments) throws Exception {
        String[] args = arguments.getSourceArgs();
        String clusterConfiguration = args.length >= 1 ? args[0] : "/etc/default/coral";
        Ini ini = new Ini(new File(clusterConfiguration));
        IniPreferences configuration = new IniPreferences(ini);
        String fileVersion = configuration.node("CLUSTER").get("VER", "1");
        if (fileVersion.equals("2")) {
            this.configureNodeV2.main(args);
        } else {
            logger.error("Incompatible /etc/default/coral file");
        }
    }
}

