/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.DiscoverSubnet;
import com.coraltele.telemetry.db.telemetry.main.repository.DiscoverSubnetRepository;
import com.coraltele.telemetry.helper.CIDRIterator;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.ICMPHelper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiscoveryThread
implements Runnable {
    private static final Logger logger = LogManager.getLogger(DiscoveryThread.class);
    private Thread thread;
    public volatile boolean isRunning = true;
    DiscoverSubnetRepository discoverSubnetRepository;
    SCADAAssetRepository scadaAssetRepository;

    public DiscoveryThread(DiscoverSubnetRepository discoverSubnetRepository, SCADAAssetRepository scadaAssetRepository) {
        this.discoverSubnetRepository = discoverSubnetRepository;
        this.scadaAssetRepository = scadaAssetRepository;
        this.startService();
    }

    public void startService() {
        logger.info("Starting Discovery Thread");
        this.thread = new Thread((Runnable)this);
        this.thread.start();
    }

    @Override
    public void run() {
        while (this.isRunning) {
            try {
                List discover = this.discoverSubnetRepository.findAll();
                for (DiscoverSubnet discoverSubnet : discover) {
                    List ipAddresses = CIDRIterator.getAllIPAddresses((String)discoverSubnet.getIp(), (int)discoverSubnet.getSubnet());
                    Integer i = 0;
                    for (String ipAddress : ipAddresses) {
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                        if (ipAddress.equals(discoverSubnet.getIp()) || i >= ipAddresses.size()) continue;
                        logger.info("Locating IP {}", (Object)ipAddress);
                        try {
                            if (ICMPHelper.isIPAddressReachable((String)ipAddress)) {
                                InetAddress addr = InetAddress.getByName(ipAddress);
                                logger.info("ip {} discovered {}", (Object)ipAddress, (Object)addr.getHostName());
                                Optional asset = this.scadaAssetRepository.findByIpAddress(ipAddress);
                                if (asset.isPresent()) continue;
                                SCADAAsset discoveredAsset = new SCADAAsset();
                                discoveredAsset.setIpAddress(ipAddress);
                                discoveredAsset.setNodeName(ipAddress);
                                discoveredAsset.setCategory("un-identified");
                                discoveredAsset.setNodeId(Integer.valueOf(0));
                                discoveredAsset.setLocation(discoverSubnet.getLocation());
                                discoveredAsset.setStatus(true);
                                discoveredAsset.setUuid(UUID.randomUUID());
                                this.scadaAssetRepository.save((Object)discoveredAsset);
                                continue;
                            }
                            logger.info("ip {} not discovered", (Object)ipAddress);
                        }
                        catch (UnknownHostException e) {
                            logger.error("Unable to locate ip : Host Not Found {}", (Object)ipAddress, (Object)e);
                        }
                        catch (Exception e) {
                            logger.error("Unable to locate ip : Exception {}", (Object)ipAddress, (Object)e);
                        }
                    }
                }
                try {
                    Thread.sleep(Constants.DISCOVERY_DURATION * 60000);
                }
                catch (InterruptedException e) {
                    logger.error("While sleeping thread discovery", (Throwable)e);
                }
            }
            catch (Exception E) {
                logger.error("Error in discovery thread ", (Throwable)E);
            }
        }
    }
}

