/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.messaging.service;

import com.coraltele.telemetry.condition.EnableConnectionWithCentralNMS;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.service.messaging.service.SubscribedMessage;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableConnectionWithCentralNMS.class})
public class CentralNMSService {
    private static final Logger logger = LogManager.getLogger(CentralNMSService.class);
    private JedisConnectionFactory jedisConnectionFactory;
    private RedisTemplate<String, Object> messageTemplate;
    private ChannelTopic channelTopic = new ChannelTopic("enb-channel");

    public CentralNMSService() {
        this.jedisConnectionFactory = new JedisConnectionFactory();
        this.jedisConnectionFactory.setHostName(Constants.CENTRAL_NMS_REDIS_IP);
        this.jedisConnectionFactory.setPort(Constants.CENTRAL_NMS_REDIS_PORT.intValue());
        this.jedisConnectionFactory.afterPropertiesSet();
        this.messageTemplate = new RedisTemplate();
        this.messageTemplate.setConnectionFactory((RedisConnectionFactory)this.jedisConnectionFactory);
        this.messageTemplate.setValueSerializer((RedisSerializer)new GenericToStringSerializer(Object.class));
        this.messageTemplate.afterPropertiesSet();
        Constants.centralNMSService = this;
    }

    public void sendMessage(SubscribedMessage message) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String messageToSend = objectMapper.writeValueAsString((Object)message);
            logger.info("Sending message {} to central NMS server {}:{}", (Object)messageToSend, (Object)this.jedisConnectionFactory.getHostName(), (Object)this.jedisConnectionFactory.getPort());
            this.messageTemplate.convertAndSend(this.channelTopic.getTopic(), (Object)messageToSend);
        }
        catch (JsonProcessingException e) {
            logger.error("Unable to send message to central NMS", (Throwable)e);
        }
    }

    public void publish(SubscribedMessage message) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String messageToSend = objectMapper.writeValueAsString((Object)message);
            logger.info("Sending message {} to central NMS server {}:{}", (Object)messageToSend, (Object)this.jedisConnectionFactory.getHostName(), (Object)this.jedisConnectionFactory.getPort());
            this.messageTemplate.convertAndSend(this.channelTopic.getTopic(), (Object)messageToSend);
        }
        catch (JsonProcessingException e) {
            logger.error("Unable to send message to central NMS", (Throwable)e);
        }
    }
}

