/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import com.coraltele.telemetry.service.coralnms.sensor_data.model.ChartDataModel;
import com.coraltele.telemetry.service.coralnms.sensor_data.model.SeriesModel;
import com.coraltele.telemetry.service.timeseries.model.TimeSeriesDataModel;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.springframework.stereotype.Service;

@Service
public class SystemHealthHelper {
    private static final Logger logger = LogManager.getLogger(SystemHealthHelper.class);
    private double totalSwapSize = 0.0;
    private double availableSwapSpace = 0.0;
    public String ipValue = null;
    List<String> processListValue = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TimeSeriesDataModel> getRamInfoSingleSeries(String ipAddress) {
        Snmp snmp = null;
        ArrayList<TimeSeriesDataModel> seriesData = new ArrayList<TimeSeriesDataModel>();
        this.ipValue = ipAddress.trim();
        try {
            String port = "161";
            String community = "public";
            String oidValue = "1.3.6.1.4.1.2021.4";
            Address targetAddress = GenericAddress.parse((String)("udp:" + this.ipValue + "/" + port));
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            snmp = new Snmp((TransportMapping)transport);
            transport.listen();
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(community));
            target.setAddress(targetAddress);
            target.setRetries(2);
            target.setTimeout(1500L);
            target.setVersion(1);
            PDU pdu = new PDU();
            pdu.setType(-95);
            OID oid = new OID(oidValue);
            pdu.add(new VariableBinding(oid));
            boolean finished = false;
            while (!finished) {
                ResponseEvent responseEvent = snmp.send(pdu, (Target)target);
                PDU response = responseEvent.getResponse();
                long currentTime = Instant.now().getEpochSecond();
                if (response == null) {
                    finished = true;
                    break;
                }
                VariableBinding vb = response.get(0);
                if (response.getErrorIndex() != 0) {
                    finished = true;
                    continue;
                }
                if (vb.getOid() == null) {
                    finished = true;
                    continue;
                }
                if (vb.getOid().size() < oid.size() || oid.leftMostCompare(oid.size(), vb.getOid()) != 0) {
                    finished = true;
                    continue;
                }
                if (Null.isExceptionSyntax((int)vb.getVariable().getSyntax())) {
                    finished = true;
                    continue;
                }
                if (vb.getOid().compareTo((Variable)oid) <= 0) {
                    finished = true;
                    continue;
                }
                logger.info("OID Received {} : {}", (Object)vb.getOid(), (Object)vb.getVariable());
                pdu.setRequestID(new Integer32(0));
                pdu.set(0, vb);
                Variable variable = vb.getVariable();
                if (vb.getOid().toString().equals("1.3.6.1.4.1.2021.4.5.0")) {
                    seriesData.add(this.getByteCountFromKBToGB(variable, currentTime, "Total RAM"));
                    continue;
                }
                if (vb.getOid().toString().equals("1.3.6.1.4.1.2021.4.11.0")) {
                    seriesData.add(this.getByteCountFromKBToGB(variable, currentTime, "Free RAM"));
                    continue;
                }
                if (!vb.getOid().toString().equals("1.3.6.1.4.1.2021.4.6.0")) continue;
                seriesData.add(this.getByteCountFromKBToGB(variable, currentTime, "Used RAM"));
            }
        }
        catch (IOException e) {
            logger.info("Exception occurred: {} ", (Object)e.getMessage());
        }
        finally {
            try {
                if (snmp != null) {
                    snmp.close();
                }
            }
            catch (Exception e) {
                logger.error("Unable to gracefully close SNMP session for hard disk details.");
            }
        }
        return seriesData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TimeSeriesDataModel> getCpuLoad(String ipAddress) {
        Snmp snmp = null;
        ArrayList<TimeSeriesDataModel> seriesData = new ArrayList<TimeSeriesDataModel>();
        this.ipValue = ipAddress.trim();
        try {
            String port = "161";
            String community = "public";
            String oidValue = "1.3.6.1.4.1.2021.10.1.3";
            Address targetAddress = GenericAddress.parse((String)("udp:" + this.ipValue + "/" + port));
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            snmp = new Snmp((TransportMapping)transport);
            transport.listen();
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(community));
            target.setAddress(targetAddress);
            target.setRetries(2);
            target.setTimeout(1500L);
            target.setVersion(1);
            PDU pdu = new PDU();
            pdu.setType(-95);
            OID oid = new OID(oidValue);
            pdu.add(new VariableBinding(oid));
            boolean finished = false;
            while (!finished) {
                ResponseEvent responseEvent = snmp.send(pdu, (Target)target);
                PDU response = responseEvent.getResponse();
                long currentTime = Instant.now().getEpochSecond();
                if (response == null) {
                    finished = true;
                    break;
                }
                VariableBinding vb = response.get(0);
                if (response.getErrorStatus() != 0) {
                    finished = true;
                    continue;
                }
                if (vb.getOid() == null) {
                    finished = true;
                    continue;
                }
                if (vb.getOid().size() < oid.size() || oid.leftMostCompare(oid.size(), vb.getOid()) != 0) {
                    finished = true;
                    continue;
                }
                if (Null.isExceptionSyntax((int)vb.getVariable().getSyntax())) {
                    finished = true;
                    continue;
                }
                if (vb.getOid().compareTo((Variable)oid) <= 0) {
                    finished = true;
                    continue;
                }
                logger.info("OID Received {} : {}", (Object)vb.getOid(), (Object)vb.getVariable());
                pdu.setRequestID(new Integer32(0));
                pdu.set(0, vb);
                Variable variable = vb.getVariable();
                if (vb.getOid().toString().equals("1.3.6.1.4.1.2021.10.1.3.1")) {
                    seriesData.add(this.getCpuData(variable, currentTime, "Load 1"));
                    continue;
                }
                if (vb.getOid().toString().equals("1.3.6.1.4.1.2021.10.1.3.2")) {
                    seriesData.add(this.getCpuData(variable, currentTime, "Load 5"));
                    continue;
                }
                if (!vb.getOid().toString().equals("1.3.6.1.4.1.2021.10.1.3.3")) continue;
                seriesData.add(this.getCpuData(variable, currentTime, "Load 15"));
            }
        }
        catch (IOException e) {
            logger.info("Exception occurred: {} ", (Object)e.getMessage());
        }
        finally {
            try {
                if (snmp != null) {
                    snmp.close();
                }
            }
            catch (Exception e) {
                logger.error("Unable to Grace fully close SNMP Walk for {CPU Details}");
            }
        }
        return seriesData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChartDataModel getListProcess(String ipAddress) {
        Snmp snmp = null;
        ChartDataModel seriesData = new ChartDataModel();
        this.ipValue = ipAddress.trim();
        try {
            String port = "161";
            String community = "public";
            String oidValue = "1.3.6.1.2.1.25.4.2.1.2";
            Address targetAddress = GenericAddress.parse((String)("udp:" + this.ipValue + "/" + port));
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            snmp = new Snmp((TransportMapping)transport);
            transport.listen();
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(community));
            target.setAddress(targetAddress);
            target.setRetries(2);
            target.setTimeout(1500L);
            target.setVersion(1);
            PDU pdu = new PDU();
            pdu.setType(-95);
            OID oid = new OID(oidValue);
            pdu.add(new VariableBinding(oid));
            boolean finished = false;
            while (!finished) {
                ResponseEvent responseEvent = snmp.send(pdu, (Target)target);
                PDU response = responseEvent.getResponse();
                long currentTime = Instant.now().getEpochSecond();
                if (response == null) {
                    finished = true;
                    break;
                }
                VariableBinding vb = response.get(0);
                if (response.getErrorStatus() != 0) {
                    finished = true;
                    continue;
                }
                if (vb.getOid() == null) {
                    finished = true;
                    continue;
                }
                if (vb.getOid().size() < oid.size() || oid.leftMostCompare(oid.size(), vb.getOid()) != 0) {
                    finished = true;
                    continue;
                }
                if (Null.isExceptionSyntax((int)vb.getVariable().getSyntax())) {
                    finished = true;
                    continue;
                }
                if (vb.getOid().compareTo((Variable)oid) <= 0) {
                    finished = true;
                    continue;
                }
                logger.info("OID Received {} : {}", (Object)vb.getOid(), (Object)vb.getVariable());
                pdu.setRequestID(new Integer32(0));
                pdu.set(0, vb);
                seriesData = this.getListProcess(vb.getVariable().toString(), currentTime);
            }
        }
        catch (IOException e) {
            logger.info("Exception occurred: {} ", (Object)e.getMessage());
        }
        finally {
            try {
                if (snmp != null) {
                    snmp.close();
                }
            }
            catch (Exception e) {
                logger.error("Unable to Grace fully close SNMP Walk for {ListProcess Details}");
            }
        }
        return seriesData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TimeSeriesDataModel> getHardDiskData(String ipAddress) {
        Snmp snmp = null;
        ArrayList<TimeSeriesDataModel> seriesData = new ArrayList<TimeSeriesDataModel>();
        this.ipValue = ipAddress.trim();
        try {
            String port = "161";
            String community = "public";
            String oidValue = "1.3.6.1.4.1.2021.9.1";
            Address targetAddress = GenericAddress.parse((String)("udp:" + this.ipValue + "/" + port));
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            snmp = new Snmp((TransportMapping)transport);
            transport.listen();
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(community));
            target.setAddress(targetAddress);
            target.setRetries(2);
            target.setTimeout(1500L);
            target.setVersion(1);
            PDU pdu = new PDU();
            pdu.setType(-95);
            OID oid = new OID(oidValue);
            pdu.add(new VariableBinding(oid));
            boolean finished = false;
            while (!finished) {
                ResponseEvent responseEvent = snmp.send(pdu, (Target)target);
                PDU response = responseEvent.getResponse();
                long currentTime = Instant.now().getEpochSecond();
                if (response == null) {
                    finished = true;
                    break;
                }
                VariableBinding vb = response.get(0);
                if (response.getErrorIndex() != 0) {
                    finished = true;
                    continue;
                }
                if (vb.getOid() == null) {
                    finished = true;
                    continue;
                }
                if (vb.getOid().size() < oid.size() || oid.leftMostCompare(oid.size(), vb.getOid()) != 0) {
                    finished = true;
                    continue;
                }
                if (Null.isExceptionSyntax((int)vb.getVariable().getSyntax())) {
                    finished = true;
                    continue;
                }
                if (vb.getOid().compareTo((Variable)oid) <= 0) {
                    finished = true;
                    continue;
                }
                logger.info("OID Received {} : {}", (Object)vb.getOid(), (Object)vb.getVariable());
                pdu.setRequestID(new Integer32(0));
                pdu.set(0, vb);
                Variable variable = vb.getVariable();
                if (vb.getOid().toString().equals("1.3.6.1.4.1.2021.9.1.6.1")) {
                    seriesData.add(this.getByteCountFromKBToGB(variable, currentTime, "Total disk"));
                    continue;
                }
                if (vb.getOid().toString().equals("1.3.6.1.4.1.2021.9.1.7.1")) {
                    seriesData.add(this.getByteCountFromKBToGB(variable, currentTime, "Available Disk"));
                    continue;
                }
                if (!vb.getOid().toString().equals("1.3.6.1.4.1.2021.9.1.8.1")) continue;
                seriesData.add(this.getByteCountFromKBToGB(variable, currentTime, "Used Disk"));
            }
        }
        catch (IOException e) {
            logger.info("Exception occurred: {} ", (Object)e.getMessage());
        }
        finally {
            try {
                if (snmp != null) {
                    snmp.close();
                }
            }
            catch (Exception e) {
                logger.error("Unable to gracefully close SNMP session for hard disk details.");
            }
        }
        return seriesData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TimeSeriesDataModel> getSwapMemory(String ipAddress) {
        Snmp snmp = null;
        ArrayList<TimeSeriesDataModel> seriesData = new ArrayList<TimeSeriesDataModel>();
        this.ipValue = ipAddress.trim();
        try {
            String port = "161";
            String community = "public";
            String oidValue = "1.3.6.1.4.1.2021.4";
            Address targetAddress = GenericAddress.parse((String)("udp:" + this.ipValue + "/" + port));
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            snmp = new Snmp((TransportMapping)transport);
            transport.listen();
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(community));
            target.setAddress(targetAddress);
            target.setRetries(2);
            target.setTimeout(1500L);
            target.setVersion(1);
            PDU pdu = new PDU();
            pdu.setType(-95);
            OID oid = new OID(oidValue);
            pdu.add(new VariableBinding(oid));
            boolean finished = false;
            boolean calculated = true;
            while (!finished) {
                TimeSeriesDataModel returnValue = new TimeSeriesDataModel();
                ResponseEvent responseEvent = snmp.send(pdu, (Target)target);
                PDU response = responseEvent.getResponse();
                long currentTime = Instant.now().getEpochSecond();
                if (response == null) {
                    finished = true;
                    break;
                }
                VariableBinding vb = response.get(0);
                if (response.getErrorIndex() != 0) {
                    finished = true;
                    continue;
                }
                if (vb.getOid() == null) {
                    finished = true;
                    continue;
                }
                if (vb.getOid().size() < oid.size() || oid.leftMostCompare(oid.size(), vb.getOid()) != 0) {
                    finished = true;
                    continue;
                }
                if (Null.isExceptionSyntax((int)vb.getVariable().getSyntax())) {
                    finished = true;
                    continue;
                }
                if (vb.getOid().compareTo((Variable)oid) <= 0) {
                    finished = true;
                    continue;
                }
                logger.info("OID Received {} : {}", (Object)vb.getOid(), (Object)vb.getVariable());
                pdu.setRequestID(new Integer32(0));
                pdu.set(0, vb);
                Variable variable = vb.getVariable();
                if (vb.getOid().toString().equals("1.3.6.1.4.1.2021.4.3.0")) {
                    seriesData.add(this.getByteCountFromKBToGB(variable, currentTime, "Total Swap Size"));
                    this.totalSwapSize = ((Integer32)variable).toLong();
                    continue;
                }
                if (vb.getOid().toString().equals("1.3.6.1.4.1.2021.4.4.0")) {
                    seriesData.add(this.getByteCountFromKBToGB(variable, currentTime, "Available Swap Space"));
                    this.availableSwapSpace = ((Integer32)variable).toLong();
                    continue;
                }
                if (!(this.totalSwapSize > 0.0) || !(this.availableSwapSpace > 0.0) || !calculated) continue;
                double usedSwapSpace = (this.totalSwapSize - this.availableSwapSpace) / Math.pow(1024.0, 2.0);
                returnValue.setAttributeName("Used Swap Space");
                returnValue.setAttributeValue(String.format("%.2f", usedSwapSpace));
                returnValue.setEventEpoch(Long.valueOf(currentTime));
                returnValue.setReceivedEpoch(Long.valueOf(currentTime));
                seriesData.add(returnValue);
                calculated = false;
            }
        }
        catch (IOException e) {
            logger.info("Exception occurred: {} ", (Object)e.getMessage());
        }
        finally {
            try {
                if (snmp != null) {
                    snmp.close();
                }
            }
            catch (Exception e) {
                logger.error("Unable to gracefully close SNMP session for Swap Memory details.");
            }
        }
        return seriesData;
    }

    public TimeSeriesDataModel getByteCountFromKBToGB(Variable variable, long currentTime, String attributeName) {
        TimeSeriesDataModel returnValue = new TimeSeriesDataModel();
        long value = ((Integer32)variable).toLong();
        returnValue.setAttributeName(attributeName);
        returnValue.setEventEpoch(Long.valueOf(currentTime));
        returnValue.setReceivedEpoch(Long.valueOf(currentTime));
        double storageUsedGB = (double)value / Math.pow(1024.0, 2.0);
        String formattedValue = String.format("%.2f", storageUsedGB);
        returnValue.setAttributeValue(formattedValue);
        return returnValue;
    }

    public TimeSeriesDataModel getCpuData(Variable variable, long currentTime, String attributeName) {
        TimeSeriesDataModel returnValue = new TimeSeriesDataModel();
        returnValue.setAttributeName(attributeName);
        returnValue.setEventEpoch(Long.valueOf(currentTime));
        returnValue.setReceivedEpoch(Long.valueOf(currentTime));
        returnValue.setAttributeValue(variable.toString());
        return returnValue;
    }

    public ChartDataModel getListProcess(String variable, long currentTime) {
        ChartDataModel returnValue = new ChartDataModel();
        returnValue.getLabel().add(String.valueOf(currentTime));
        this.processListValue.add(variable);
        SeriesModel cpu = new SeriesModel();
        cpu.setSeriesName("List Of Process");
        cpu.setSeriesType(null);
        cpu.setValues(this.processListValue);
        returnValue.getSeries().add(cpu);
        return returnValue;
    }
}

