/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.bootstrap;

import com.coraltele.telemetry.bootstrap.AccessNotAllowed;
import com.coraltele.telemetry.db.users.main.entity.Role;
import com.coraltele.telemetry.db.users.main.entity.User;
import com.coraltele.telemetry.db.users.main.repository.RoleRepository;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.db.users.main.repository.UserRoleRepository;
import com.coraltele.telemetry.helper.JsonUtils;
import com.coraltele.telemetry.helper.JwtUtil;
import com.coraltele.telemetry.model.UserInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import io.jsonwebtoken.Claims;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class JwtUserDetailConfiguration
implements UserDetailsService {
    @Autowired(required=true)
    private UserRepository userRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private UserRoleRepository userRoleRepository;
    @Autowired
    private JwtUtil jwtUtil;
    private List<Map<String, Object>> apiSecurityMappings = JsonUtils.readListFromJson((String)"default-data/api-security-mapping.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);

    public UserInfo loadUserByUsername(String username) throws UsernameNotFoundException {
        Optional user = this.userRepository.findByUsername(username);
        if (!user.isPresent()) {
            throw new UsernameNotFoundException("User not found with username: " + username);
        }
        return new UserInfo(((User)user.get()).getUsername(), ((User)user.get()).getPassword(), new ArrayList(), ((User)user.get()).getUuidSecurity());
    }

    public boolean hasRole(String username, String roleCode) {
        boolean returnValue = false;
        Optional user = this.userRepository.findByUsername(username);
        Optional role = this.roleRepository.findByShortCode(roleCode);
        if (user.isPresent() && role.isPresent()) {
            returnValue = this.userRoleRepository.findByUserAndRole((User)user.get(), (Role)role.get()).isPresent();
        }
        return returnValue;
    }

    public UserInfo loadUserFromJWT(String jwtToken, String requestURL) throws UsernameNotFoundException, AccessNotAllowed {
        String userName = this.jwtUtil.getUsernameFromToken(jwtToken);
        Optional user = this.userRepository.findByUsername(userName);
        if (!user.isPresent()) {
            throw new UsernameNotFoundException("User not found with username: " + userName);
        }
        if (!this.jwtUtil.validateToken(jwtToken, ((User)user.get()).getUuidSecurity())) {
            throw new UsernameNotFoundException("Invalid JWT Token");
        }
        if (!userName.equals("admin")) {
            Claims claims = (Claims)this.jwtUtil.getClaimFromToken(jwtToken, allClaims -> allClaims);
            Object rolesObj = claims.get((Object)"roles");
            if (rolesObj == null) {
                throw new AccessNotAllowed("No roles found in JWT token for user: " + userName);
            }
            List<Object> userRoles = new ArrayList();
            if (rolesObj instanceof List) {
                userRoles = ((List)rolesObj).stream().map(Object::toString).collect(Collectors.toList());
            }
            if (this.apiSecurityMappings == null || this.apiSecurityMappings.isEmpty()) {
                throw new AccessNotAllowed("Unable to load API security mappings");
            }
            if (!this.hasAccess(userRoles, requestURL)) {
                throw new AccessNotAllowed("User " + userName + " does not have required role(s) to access endpoint: " + requestURL);
            }
        }
        return new UserInfo(((User)user.get()).getUsername(), ((User)user.get()).getPassword(), new ArrayList(), ((User)user.get()).getUuidSecurity());
    }

    private boolean hasAccess(List<String> userRoles, String requestURL) {
        boolean hasPermission = false;
        boolean endpointFound = false;
        block0: for (Map mapping : this.apiSecurityMappings) {
            String endpoint = (String)mapping.get("endpoint");
            if (!requestURL.contains(endpoint)) continue;
            endpointFound = true;
            List allowedRoles = (List)mapping.get("role");
            if (allowedRoles == null) break;
            for (String userRole : userRoles) {
                if (!allowedRoles.contains(userRole)) continue;
                hasPermission = true;
                break block0;
            }
        }
        return endpointFound && hasPermission;
    }
}

