/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.app;

import com.coraltele.telemetry.helper.Messaging;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.coralnms.sensor.model.SensorModel;
import com.coraltele.telemetry.service.coralnms.sensor.service.SensorService;
import com.coraltele.telemetry.service.coralnms.sensor_data.model.SensorAttributeModel;
import com.coraltele.telemetry.service.coralnms.sensor_data.model.TelemetryModel;
import com.coraltele.telemetry.service.coralnms.sensor_data.service.SensorDataService;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/app/v2/message/request"})
@RestController
public class SensorAPPController {
    private static final Logger logger = LogManager.getLogger(SensorAPPController.class);
    @Autowired
    private SensorService service;
    @Autowired
    SensorDataService sensorDataService;

    @PutMapping(value={"/{id}"})
    public String update(@RequestBody SensorModel data, @PathVariable(value="id") Long id) {
        return this.service.update(data, id);
    }

    @PostMapping(value={"/sendTelemetry"})
    public ResponseEntity<RequestResponse> sendEvent(@RequestBody TelemetryModel message) {
        logger.info("Sending message : 1");
        try {
            this.sensorDataService.saveTelemetryData(message);
            for (SensorAttributeModel attribute : message.getAttributes()) {
                attribute.setStatus(Integer.valueOf(0));
                attribute.setMessage("OK");
            }
            ObjectMapper obj = new ObjectMapper();
            String data = obj.writeValueAsString((Object)message);
            logger.info("Sending message : {}", (Object)data);
            Messaging.getMessagingTemplate().convertAndSend((Object)String.format("/app/v2/messaging/topic/%s", "telemetry"), (Object)data);
        }
        catch (Exception ex) {
            logger.error("Sending message", (Throwable)ex);
        }
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(0);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

