/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.db.telemetry.main.entity.RegistrationAlert;
import com.coraltele.telemetry.db.telemetry.main.repository.RegistrationAlertRepository;
import java.time.Instant;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateExtensionStatusThread
implements Runnable {
    private static final Logger logger = LogManager.getLogger(UpdateExtensionStatusThread.class);
    private RegistrationAlertRepository registrationAlertRepository;
    private static boolean isRunning = true;

    public UpdateExtensionStatusThread(RegistrationAlertRepository registrationAlertRepository) {
        this.registrationAlertRepository = registrationAlertRepository;
    }

    @Override
    public void run() {
        try {
            while (isRunning) {
                List allExtension = (List)this.registrationAlertRepository.findAll();
                if (allExtension.isEmpty()) {
                    logger.info("Extension List is Empty.");
                } else {
                    for (RegistrationAlert extension : allExtension) {
                        if (extension.getRegistrationExpiresEpoch() == null || extension.getRegistrationExpiresEpoch() > Instant.now().getEpochSecond()) continue;
                        extension.setExtensionStatus(Boolean.valueOf(false));
                        this.registrationAlertRepository.save((Object)extension);
                        logger.info("Extension registration : {} expired", (Object)extension.getExtension());
                    }
                }
                Thread.sleep(10000L);
            }
        }
        catch (Exception e) {
            logger.error("Error in update extension status Thread will restart in a few seconds: {}", (Object)e.getMessage(), (Object)e);
            Thread.currentThread().interrupt();
        }
    }
}

