/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.model.discovery.ServiceStatus;
import com.coraltele.telemetry.service.coralnms.scada_assets.service.SCADAAssetService;
import com.coraltele.telemetry.thread.PingCheckThread;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ICMPHealthCheckThread
implements Runnable {
    private static final Logger logger = LogManager.getLogger(ICMPHealthCheckThread.class);
    public volatile boolean isRunning = true;
    private SCADAAssetRepository scadaAssetRepository;
    private SCADAAssetService scadaAssetService;
    private ExecutorService threadPool = Executors.newFixedThreadPool(Constants.ICMP_CHECK_THREADS);

    public ICMPHealthCheckThread(SCADAAssetRepository scadaAssetRepository, SCADAAssetService scadaAssetService) {
        this.scadaAssetRepository = scadaAssetRepository;
        this.scadaAssetService = scadaAssetService;
    }

    @Override
    public void run() {
        logger.info("Starting Ping Check Thread");
        while (this.isRunning) {
            try {
                this.runExecutor();
                Thread.sleep(5000L);
            }
            catch (Throwable e) {
                this.isRunning = false;
                logger.error("While sleeping/processing thread ICMPHealthCheck", e);
            }
        }
    }

    public void runExecutor() {
        List assets = this.scadaAssetRepository.findAll();
        ArrayList<ServiceStatus> assetBlockForPingCheck = new ArrayList<ServiceStatus>();
        for (SCADAAsset scadaAsset : assets) {
            ServiceStatus checkFor = new ServiceStatus(scadaAsset.getId(), scadaAsset.getNodeName(), scadaAsset.getIpAddress(), scadaAsset.getCategory(), "ICMP", Boolean.valueOf(false), "", Integer.valueOf(3), "", Integer.valueOf(0), "", Boolean.valueOf(false), "");
            assetBlockForPingCheck.add(checkFor);
            logger.info("Adding {} {} {} to block. Block size after adding this asset is {}", (Object)checkFor.getAssetId(), (Object)checkFor.getIpAddress(), (Object)checkFor.getService(), (Object)assetBlockForPingCheck.size());
            if (assetBlockForPingCheck.size() != Constants.IP_COUNT_EACH_THREAD.intValue()) continue;
            ServiceStatus[] ips = assetBlockForPingCheck.toArray(new ServiceStatus[assetBlockForPingCheck.size()]);
            this.startNewThread(ips);
            assetBlockForPingCheck.clear();
        }
        if (!assetBlockForPingCheck.isEmpty()) {
            ServiceStatus[] ips = assetBlockForPingCheck.toArray(new ServiceStatus[assetBlockForPingCheck.size()]);
            this.startNewThread(ips);
            assetBlockForPingCheck.clear();
        }
    }

    private void startNewThread(ServiceStatus[] ips) {
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() >= Constants.ICMP_CHECK_THREADS) {
            try {
                logger.info("Ping Check threads active {} out of {}}", (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount(), (Object)Constants.ICMP_CHECK_THREADS);
                Thread.sleep(100L);
            }
            catch (Exception e) {
                logger.error("Error while waiting for available thread", (Throwable)e);
            }
        }
        logger.info("Starting new thread because {}  are active out of {}}", (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount(), (Object)Constants.ICMP_CHECK_THREADS);
        this.threadPool.execute((Runnable)new PingCheckThread(ips, this.scadaAssetService));
    }
}

