/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.service;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.WidgetList;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.WidgetListRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.SystemHealthRule;
import com.coraltele.telemetry.db.telemetry.main.repository.SystemHealthRuleRepository;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.helper.SystemHealthHelper;
import com.coraltele.telemetry.service.coralnms.sensor_data.model.ChartDataModel;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemHealthService {
    private static final Logger logger = LogManager.getLogger(SystemHealthService.class);
    @Autowired
    WidgetListRepository widgetListRepository;
    @Autowired
    private SystemHealthHelper systemHealthHelper;
    @Autowired
    private SystemHealthRuleRepository systemHealthRuleRepository;

    public RequestResponse getRamInfo(String widgetId) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional widgetConfiguration = this.widgetListRepository.findByCode(widgetId);
            if (widgetConfiguration.isPresent()) {
                String ipAddress = ((WidgetList)widgetConfiguration.get()).getIpAddress();
                List ListValue = this.systemHealthHelper.getRamInfoSingleSeries(ipAddress);
                Optional systemRule = this.systemHealthRuleRepository.findByCode(((WidgetList)widgetConfiguration.get()).getCode());
                if (widgetConfiguration.isPresent() && systemRule.isPresent()) {
                    String thresholdLowerStr = ((WidgetList)widgetConfiguration.get()).getThresholdLower().trim();
                    String thresholdUpperStr = ((WidgetList)widgetConfiguration.get()).getThresholdUpper().trim();
                    String minValueStr = ((SystemHealthRule)systemRule.get()).getMinValue().trim();
                    String maxValueStr = ((SystemHealthRule)systemRule.get()).getMaxValue().trim();
                    Integer thresholdLower = Integer.parseInt(thresholdLowerStr);
                    Integer thresholdUpper = Integer.parseInt(thresholdUpperStr);
                    Integer minValue = Integer.parseInt(minValueStr);
                    Integer maxValue = Integer.parseInt(maxValueStr);
                    if (thresholdLower < minValue || thresholdUpper > maxValue) {
                        ((SystemHealthRule)systemRule.get()).setSeverity(Integer.valueOf(1));
                        logger.info("the Threshold value is max or min Alert is generated");
                    } else {
                        ((SystemHealthRule)systemRule.get()).setSeverity(Integer.valueOf(0));
                        logger.info("Alert is closed");
                    }
                } else {
                    logger.error("widgetConfiguration or systemRule is null");
                    returnValue.setStatus(-3);
                    returnValue.setMessage("Error: Widget configuration or system rule is null");
                    return returnValue;
                }
                returnValue.setMessage("OK");
                returnValue.setStatus(0);
                returnValue.setMessageDetail("RAM Data Response.");
                returnValue.setData((Object)ListValue);
            } else {
                returnValue.setStatus(-2);
                returnValue.setMessage("Unable to fetch data for widget id : " + widgetId + " Widget not found");
            }
        }
        catch (NumberFormatException e) {
            logger.error("NumberFormatException: " + e.getMessage());
            returnValue.setStatus(-4);
            returnValue.setMessage("Error: NumberFormatException - Unable to parse integer value");
        }
        catch (Exception e) {
            logger.error("Error occurred when fetching RAM info: " + e.getMessage());
            returnValue.setStatus(-5);
            returnValue.setMessage("Error: " + e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getHardDisk(String widgetId) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional widgetConfiguration = this.widgetListRepository.findByCode(widgetId);
            if (widgetConfiguration.isPresent()) {
                String ipAddress = ((WidgetList)widgetConfiguration.get()).getIpAddress();
                List ListValue = this.systemHealthHelper.getHardDiskData(ipAddress);
                Optional systemRule = this.systemHealthRuleRepository.findByCode(((WidgetList)widgetConfiguration.get()).getCode());
                if (widgetConfiguration.isPresent() && systemRule.isPresent()) {
                    String thresholdLowerStr = ((WidgetList)widgetConfiguration.get()).getThresholdLower().trim();
                    String thresholdUpperStr = ((WidgetList)widgetConfiguration.get()).getThresholdUpper().trim();
                    String minValueStr = ((SystemHealthRule)systemRule.get()).getMinValue().trim();
                    String maxValueStr = ((SystemHealthRule)systemRule.get()).getMaxValue().trim();
                    Integer thresholdLower = Integer.parseInt(thresholdLowerStr);
                    Integer thresholdUpper = Integer.parseInt(thresholdUpperStr);
                    Integer minValue = Integer.parseInt(minValueStr);
                    Integer maxValue = Integer.parseInt(maxValueStr);
                    if (thresholdLower < minValue && thresholdUpper < maxValue) {
                        ((SystemHealthRule)systemRule.get()).setSeverity(Integer.valueOf(1));
                        logger.info("the Threshold value is max or min Alert is generated");
                    } else {
                        ((SystemHealthRule)systemRule.get()).setSeverity(Integer.valueOf(0));
                        logger.info("Alert is closed");
                    }
                } else {
                    logger.error("widgetConfiguration or systemRule is null");
                    returnValue.setStatus(-3);
                    returnValue.setMessage("Error: Widget configuration or system rule is null");
                    return returnValue;
                }
                returnValue.setMessage("OK");
                returnValue.setStatus(0);
                returnValue.setMessageDetail("Hard Disk Data Response.");
                returnValue.setData((Object)ListValue);
            } else {
                returnValue.setStatus(-2);
                returnValue.setMessage("Unable to fetch data for widget id : " + widgetId + " Widget not found");
            }
        }
        catch (NumberFormatException e) {
            logger.error("NumberFormatException: " + e.getMessage());
            returnValue.setStatus(-4);
            returnValue.setMessage("Error: NumberFormatException - Unable to parse integer value");
        }
        catch (Exception e) {
            logger.error("Error are found when HardDisk is get in ip: {} " + e.getMessage());
            returnValue.setStatus(-5);
            returnValue.setMessage("Error: " + e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getProcessList(String widgetId) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional widgetConfiguration = this.widgetListRepository.findByCode(widgetId);
            if (widgetConfiguration.isPresent()) {
                String ipAddress = ((WidgetList)widgetConfiguration.get()).getIpAddress();
                ChartDataModel ListValue = this.systemHealthHelper.getListProcess(ipAddress);
                Optional systemRule = this.systemHealthRuleRepository.findByCode(((WidgetList)widgetConfiguration.get()).getCode());
                if (widgetConfiguration.isPresent() && systemRule.isPresent()) {
                    String thresholdLowerStr = ((WidgetList)widgetConfiguration.get()).getThresholdLower().trim();
                    String thresholdUpperStr = ((WidgetList)widgetConfiguration.get()).getThresholdUpper().trim();
                    String minValueStr = ((SystemHealthRule)systemRule.get()).getMinValue().trim();
                    String maxValueStr = ((SystemHealthRule)systemRule.get()).getMaxValue().trim();
                    Integer thresholdLower = Integer.parseInt(thresholdLowerStr);
                    Integer thresholdUpper = Integer.parseInt(thresholdUpperStr);
                    Integer minValue = Integer.parseInt(minValueStr);
                    Integer maxValue = Integer.parseInt(maxValueStr);
                    if (thresholdLower < minValue && thresholdUpper < maxValue) {
                        ((SystemHealthRule)systemRule.get()).setSeverity(Integer.valueOf(1));
                        logger.info("the Threshold value is max or min Alert is generated");
                    } else {
                        ((SystemHealthRule)systemRule.get()).setSeverity(Integer.valueOf(0));
                        logger.info("Alert is closed");
                    }
                } else {
                    logger.error("widgetConfiguration or systemRule is null");
                    returnValue.setStatus(-3);
                    returnValue.setMessage("Error: Widget configuration or system rule is null");
                    return returnValue;
                }
                returnValue.setMessage("OK");
                returnValue.setStatus(0);
                returnValue.setMessageDetail("ProcessList Data Response.");
                returnValue.setData((Object)ListValue);
            } else {
                returnValue.setStatus(-2);
                returnValue.setMessage("Unable to fetch data for widget id : " + widgetId + " Widget not found");
            }
        }
        catch (NumberFormatException e) {
            logger.error("NumberFormatException: " + e.getMessage());
            returnValue.setStatus(-4);
            returnValue.setMessage("Error: NumberFormatException - Unable to parse integer value");
        }
        catch (Exception e) {
            logger.error("Error occurred when fetching ProcessList info: " + e.getMessage());
            returnValue.setStatus(-5);
            returnValue.setMessage("Error: " + e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getSwapMemory(String widgetId) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional widgetConfiguration = this.widgetListRepository.findByCode(widgetId);
            if (widgetConfiguration.isPresent()) {
                String ipAddress = ((WidgetList)widgetConfiguration.get()).getIpAddress();
                List ListValue = this.systemHealthHelper.getSwapMemory(ipAddress);
                Optional systemRule = this.systemHealthRuleRepository.findByCode(((WidgetList)widgetConfiguration.get()).getCode());
                if (widgetConfiguration.isPresent() && systemRule.isPresent()) {
                    String thresholdLowerStr = ((WidgetList)widgetConfiguration.get()).getThresholdLower().trim();
                    String thresholdUpperStr = ((WidgetList)widgetConfiguration.get()).getThresholdUpper().trim();
                    String minValueStr = ((SystemHealthRule)systemRule.get()).getMinValue().trim();
                    String maxValueStr = ((SystemHealthRule)systemRule.get()).getMaxValue().trim();
                    Integer thresholdLower = Integer.parseInt(thresholdLowerStr);
                    Integer thresholdUpper = Integer.parseInt(thresholdUpperStr);
                    Integer minValue = Integer.parseInt(minValueStr);
                    Integer maxValue = Integer.parseInt(maxValueStr);
                    if (thresholdLower < minValue && thresholdUpper < maxValue) {
                        ((SystemHealthRule)systemRule.get()).setSeverity(Integer.valueOf(1));
                        logger.info("the Threshold value is max or min Alert is generated");
                    } else {
                        ((SystemHealthRule)systemRule.get()).setSeverity(Integer.valueOf(0));
                        logger.info("Alert is closed");
                    }
                } else {
                    logger.error("widgetConfiguration or systemRule is null");
                    returnValue.setStatus(-3);
                    returnValue.setMessage("Error: Widget configuration or system rule is null");
                    return returnValue;
                }
                returnValue.setMessage("OK");
                returnValue.setStatus(0);
                returnValue.setMessageDetail("Swap Memory Data Response.");
                returnValue.setData((Object)ListValue);
            } else {
                returnValue.setStatus(-2);
                returnValue.setMessage("Unable to fetch data for widget id : " + widgetId + " Widget not found");
            }
        }
        catch (NumberFormatException e) {
            logger.error("NumberFormatException: " + e.getMessage());
            returnValue.setStatus(-4);
            returnValue.setMessage("Error: NumberFormatException - Unable to parse integer value");
        }
        catch (Exception e) {
            logger.error("Error occurred when fetching Swap Memory info: " + e.getMessage());
            returnValue.setStatus(-5);
            returnValue.setMessage("Error: " + e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getCpuLoad(String widgetId) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional widgetConfiguration = this.widgetListRepository.findByCode(widgetId);
            if (widgetConfiguration.isPresent()) {
                String ipAddress = ((WidgetList)widgetConfiguration.get()).getIpAddress();
                List ListValue = this.systemHealthHelper.getCpuLoad(ipAddress);
                Optional systemRule = this.systemHealthRuleRepository.findByCode(((WidgetList)widgetConfiguration.get()).getCode());
                if (systemRule.isPresent()) {
                    String thresholdLowerStr = ((WidgetList)widgetConfiguration.get()).getThresholdLower().trim();
                    String thresholdUpperStr = ((WidgetList)widgetConfiguration.get()).getThresholdUpper().trim();
                    String minValueStr = ((SystemHealthRule)systemRule.get()).getMinValue().trim();
                    String maxValueStr = ((SystemHealthRule)systemRule.get()).getMaxValue().trim();
                    Integer thresholdLower = Integer.parseInt(thresholdLowerStr);
                    Integer thresholdUpper = Integer.parseInt(thresholdUpperStr);
                    Integer minValue = Integer.parseInt(minValueStr);
                    Integer maxValue = Integer.parseInt(maxValueStr);
                    if (thresholdLower < minValue && thresholdUpper < maxValue) {
                        ((SystemHealthRule)systemRule.get()).setSeverity(Integer.valueOf(1));
                        logger.info("the Threshold value is max or min Alert is generated");
                    } else {
                        ((SystemHealthRule)systemRule.get()).setSeverity(Integer.valueOf(0));
                        logger.info("Alert is closed");
                    }
                } else {
                    logger.error("systemRule is null");
                    returnValue.setStatus(-3);
                    returnValue.setMessage("Error: system rule is null");
                    return returnValue;
                }
                returnValue.setMessage("OK");
                returnValue.setStatus(0);
                returnValue.setMessageDetail("CPU Load Data Response.");
                returnValue.setData((Object)ListValue);
            } else {
                logger.error("widgetConfiguration is null");
                returnValue.setStatus(-2);
                returnValue.setMessage("Unable to fetch data for widget id : " + widgetId + " Widget not found");
            }
        }
        catch (NumberFormatException e) {
            logger.error("NumberFormatException: " + e.getMessage());
            returnValue.setStatus(-4);
            returnValue.setMessage("Error: NumberFormatException - Unable to parse integer value");
        }
        catch (Exception e) {
            logger.error("Error occurred when fetching CPU Load info: " + e.getMessage());
            returnValue.setStatus(-5);
            returnValue.setMessage("Error: " + e.getMessage());
        }
        return returnValue;
    }
}

