/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.condition.EnableSendSms;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.CategoryRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertHistoryRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.SeverityRepository;
import com.coraltele.telemetry.helper.SendSms;
import com.coraltele.telemetry.thread.SendSmsThread;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableSendSms.class})
public class SendSmsProcess {
    private static final Logger logger = LogManager.getLogger(SendSmsProcess.class);
    @Autowired
    private SendSms sendSmsService;
    @Autowired
    private AlertHistoryRepository alertHistoryRepository;
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private SeverityRepository severityRepository;
    private static final Integer MAX_THREADS = 1;
    ExecutorService threadPool = Executors.newFixedThreadPool(1);

    @Scheduled(fixedRate=5000L)
    public void startHealthCheck() throws InterruptedException {
        logger.info("Maximum Threads : {}, Active Thread {} ", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        Integer threadsStarted = 0;
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            Integer n = threadsStarted;
            Integer n2 = threadsStarted = Integer.valueOf(threadsStarted + 1);
            logger.info("Starting send Sms Thread");
            this.threadPool.execute((Runnable)new SendSmsThread(this.severityRepository, this.alertHistoryRepository, this.sendSmsService, this.categoryRepository));
        }
        logger.info("{} Threads started", (Object)threadsStarted);
    }
}

