/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.helper.MetricsData;
import com.coraltele.telemetry.service.timeseries.model.TimeSeriesLabelModel;
import com.coraltele.telemetry.thread.MetricsCollectionThread;
import com.google.common.util.concurrent.AtomicDouble;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MetricsCollectionProcess {
    private static final Logger logger = LogManager.getLogger(MetricsCollectionProcess.class);
    private MetricsCollectionThread metricsCollectionThread;
    Map<String, AtomicDouble> gauges = new ConcurrentHashMap();
    MeterRegistry registry;

    public MetricsCollectionProcess(MeterRegistry registry) {
        Gauge.builder((String)"rrcSetupRequest", (Object)this, MetricsCollectionProcess::rrcSetupRequest).description("rrcSetupRequest").register(registry);
        Gauge.builder((String)"rrcSetupComplete", (Object)this, MetricsCollectionProcess::rrcSetupComplete).description("rrcSetupComplete").register(registry);
        Gauge.builder((String)"NgSetupRequest", (Object)this, MetricsCollectionProcess::ngSetupRequest).description("NgSetupRequest").register(registry);
        Gauge.builder((String)"InitialUeMessage", (Object)this, MetricsCollectionProcess::initialUeMessage).description("InitialUeMessage").register(registry);
        Gauge.builder((String)"InitialContextSetupRequest", (Object)this, MetricsCollectionProcess::initialContextSetupRequest).description("InitialContextSetupRequest").register(registry);
        Gauge.builder((String)"InitialContextSetupResponse", (Object)this, MetricsCollectionProcess::initialContextSetupResponse).description("InitialContextSetupResponse").register(registry);
        Gauge.builder((String)"PduSessionResourceSetupRequest", (Object)this, MetricsCollectionProcess::pduSessionResourceSetupRequest).description("PduSessionResourceSetupRequest").register(registry);
        Gauge.builder((String)"PduSessionResourceSetupResponse", (Object)this, MetricsCollectionProcess::pduSessionResourceSetupResponse).description("PduSessionResourceSetupResponse").register(registry);
        Gauge.builder((String)"PduSessionResourceReleaseCommand", (Object)this, MetricsCollectionProcess::pduSessionResourceReleaseCommand).description("PduSessionResourceReleaseCommand").register(registry);
        Gauge.builder((String)"PduSessionResourceReleaseResponse", (Object)this, MetricsCollectionProcess::pduSessionResourceReleaseResponse).description("PduSessionResourceReleaseResponse").register(registry);
        Gauge.builder((String)"UeContextReleaseCommand", (Object)this, MetricsCollectionProcess::ueContextReleaseCommand).description("UeContextReleaseCommand").register(registry);
        Gauge.builder((String)"UeContextReleaseComplete", (Object)this, MetricsCollectionProcess::ueContextReleaseComplete).description("UeContextReleaseComplete").register(registry);
        Gauge.builder((String)"activeCalls", (Object)this, MetricsCollectionProcess::activeCalls).description("activeCalls").register(registry);
        Gauge.builder((String)"download_data_rate", (Object)this, MetricsCollectionProcess::downloadDataRate).description("download_data_rate").register(registry);
        Gauge.builder((String)"upload_data_rate", (Object)this, MetricsCollectionProcess::uploadDataRate).description("upload_data_rate").register(registry);
        this.registry = registry;
    }

    @PostConstruct
    public void startService() {
        logger.info("Starting Discovery process");
        this.metricsCollectionThread = new MetricsCollectionThread();
        if (this.metricsCollectionThread.isRunning) {
            logger.info("Discovery Thread Started");
        }
    }

    public Long rrcSetupRequest() {
        Long returnValue = MetricsData.readFromHashMap((String)"rrcSetupRequest");
        return returnValue == null ? 0L : returnValue;
    }

    public Long rrcSetupComplete() {
        Long returnValue = MetricsData.readFromHashMap((String)"rrcSetupComplete");
        return returnValue == null ? 0L : returnValue;
    }

    public Long ngSetupRequest() {
        Long returnValue = MetricsData.readFromHashMap((String)"NgSetupRequest");
        return returnValue == null ? 0L : returnValue;
    }

    public Long initialUeMessage() {
        Long returnValue = MetricsData.readFromHashMap((String)"InitialUeMessage");
        return returnValue == null ? 0L : returnValue;
    }

    public Long initialContextSetupRequest() {
        Long returnValue = MetricsData.readFromHashMap((String)"InitialContextSetupRequest");
        return returnValue == null ? 0L : returnValue;
    }

    public Long initialContextSetupResponse() {
        Long returnValue = MetricsData.readFromHashMap((String)"InitialContextSetupResponse");
        return returnValue == null ? 0L : returnValue;
    }

    public Long pduSessionResourceSetupRequest() {
        Long returnValue = MetricsData.readFromHashMap((String)"PduSessionResourceSetupRequest");
        return returnValue == null ? 0L : returnValue;
    }

    public Long pduSessionResourceSetupResponse() {
        Long returnValue = MetricsData.readFromHashMap((String)"PduSessionResourceSetupResponse");
        return returnValue == null ? 0L : returnValue;
    }

    public Long pduSessionResourceReleaseCommand() {
        Long returnValue = MetricsData.readFromHashMap((String)"PduSessionResourceReleaseCommand");
        return returnValue == null ? 0L : returnValue;
    }

    public Long pduSessionResourceReleaseResponse() {
        Long returnValue = MetricsData.readFromHashMap((String)"PduSessionResourceReleaseResponse");
        return returnValue == null ? 0L : returnValue;
    }

    public Long ueContextReleaseCommand() {
        Long returnValue = MetricsData.readFromHashMap((String)"UeContextReleaseCommand");
        return returnValue == null ? 0L : returnValue;
    }

    public Long ueContextReleaseComplete() {
        Long returnValue = MetricsData.readFromHashMap((String)"UeContextReleaseComplete");
        return returnValue == null ? 0L : returnValue;
    }

    public Long activeCalls() {
        Long returnValue = MetricsData.readFromHashMap((String)"activeCalls");
        return returnValue == null ? 0L : returnValue;
    }

    public Long downloadDataRate() {
        Long returnValue = MetricsData.readFromHashMap((String)"download_data_rate");
        return returnValue == null ? 0L : returnValue;
    }

    public Long uploadDataRate() {
        Long returnValue = MetricsData.readFromHashMap((String)"upload_data_rate");
        return returnValue == null ? 0L : returnValue;
    }

    public void submitData(String widgetCode, String widgetName, TimeSeriesLabelModel[] data) {
        for (TimeSeriesLabelModel timeSeriesLabelModel : data) {
            AtomicDouble gaugeValue = this.gauges.computeIfAbsent(widgetCode + "." + timeSeriesLabelModel.getLabel(), key -> {
                AtomicDouble atomicDouble = new AtomicDouble();
                Gauge.builder((String)widgetCode, (Object)atomicDouble, AtomicDouble::get).description(widgetName + " - " + widgetCode).tags((Iterable)Tags.of((String)"metricData", (String)timeSeriesLabelModel.getLabel())).register(this.registry);
                return atomicDouble;
            });
            gaugeValue.set(timeSeriesLabelModel.getValue());
        }
    }

    public void submitImsiDataRate(String imsi, double ulDataRate, double dlDataRate) {
        AtomicDouble ulGauge = this.gauges.computeIfAbsent("imsi_ul." + imsi, key -> {
            AtomicDouble atomicDouble = new AtomicDouble();
            Gauge.builder((String)"imsi_ul_data_rate", (Object)atomicDouble, AtomicDouble::get).description("Upload data rate per IMSI").tags((Iterable)Tags.of((String)"imsi", (String)imsi)).register(this.registry);
            return atomicDouble;
        });
        ulGauge.set(ulDataRate);
        AtomicDouble dlGauge = this.gauges.computeIfAbsent("imsi_dl." + imsi, key -> {
            AtomicDouble atomicDouble = new AtomicDouble();
            Gauge.builder((String)"imsi_dl_data_rate", (Object)atomicDouble, AtomicDouble::get).description("Download data rate per IMSI").tags((Iterable)Tags.of((String)"imsi", (String)imsi)).register(this.registry);
            return atomicDouble;
        });
        dlGauge.set(dlDataRate);
    }
}

