/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.data.service;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.WidgetList;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.IMSIRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.WidgetListRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.PDUSessionInfo;
import com.coraltele.telemetry.db.telemetry.main.entity.Registration;
import com.coraltele.telemetry.db.telemetry.main.entity.TelephonyDeployment;
import com.coraltele.telemetry.db.telemetry.main.repository.CounterRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.PDUSessionInfoRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.RegistrationRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.TelephonyDeploymentRepository;
import com.coraltele.telemetry.db.telephony.main.entity.ActiveCall;
import com.coraltele.telemetry.db.telephony.main.repository.ActiveCallRepository;
import com.coraltele.telemetry.db.telephony.pbx.repository.NodeConfigurationRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.HttpUtils;
import com.coraltele.telemetry.helper.MetricsData;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.BaseStationData;
import com.coraltele.telemetry.model.ChannelActiveCallsModel;
import com.coraltele.telemetry.model.MecStatusDetailsModel;
import com.coraltele.telemetry.model.NFStatusDetailsModel;
import com.coraltele.telemetry.model.SystemInfoModel;
import com.coraltele.telemetry.model.interface_model.IRLU;
import com.coraltele.telemetry.model.interface_model.ITelephonyTreeData;
import com.coraltele.telemetry.service.coralnms.alert_detail.service.AlertDetailService;
import com.coraltele.telemetry.service.coralnms.data.model.CallChannels;
import com.coraltele.telemetry.service.coralnms.data.model.CallData;
import com.coraltele.telemetry.service.coralnms.data.model.CallServerResponse;
import com.coraltele.telemetry.service.coralnms.data.model.IMSIData;
import com.coraltele.telemetry.service.coralnms.data.model.RegistrationModel;
import com.coraltele.telemetry.service.coralnms.data.model.RegistrationResponse;
import com.coraltele.telemetry.service.coralnms.nf_container.service.NFContainerService;
import com.coraltele.telemetry.service.coralnms.scada_assets.model.AssetTree;
import com.coraltele.telemetry.service.coralnms.sensor_data.model.ChartDataModel;
import com.coraltele.telemetry.service.coralnms.sensor_data.model.SensorDataModel;
import com.coraltele.telemetry.service.coralnms.sensor_data.model.SeriesModel;
import com.coraltele.telemetry.service.timeseries.model.TimeSeriesDataModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Instant;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class TelemetryDataService {
    private static final Logger logger = LogManager.getLogger(TelemetryDataService.class);
    private final RestTemplate restTemplate;
    private final HttpEntity<String> entity;
    @Autowired
    IMSIRepository imsiRepository;
    @Autowired
    CounterRepository counterRepository;
    @Autowired
    WidgetListRepository widgetListRepository;
    @Autowired
    AlertDetailService alertDetailService;
    @Autowired
    TelephonyDeploymentRepository telephonyDeploymentRepository;
    @Autowired
    RegistrationRepository registrationRepository;
    @Autowired
    SCADAAssetRepository scadaAssetRepository;
    @Autowired
    NFContainerService nfContainerService;
    @Autowired
    PDUSessionInfoRepository pduSessionInfoRepository;
    @Autowired
    NodeConfigurationRepository nodeConfigurationRepository;
    @Autowired
    ActiveCallRepository activeCallRepository;

    public TelemetryDataService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Cluster " + Constants.CLUSTER_KEY);
        this.entity = new HttpEntity((MultiValueMap)headers);
    }

    @PostConstruct
    public void onConstruct() {
        List allNodes = this.telephonyDeploymentRepository.getNodeList();
        Constants.NODE_IP_LIST.put("127.0.0.1", "127.0.0.1");
        Constants.NODE_IP_LIST.put("0:0:0:0:0:0:0:1", "0:0:0:0:0:0:0:1");
        allNodes.forEach(element -> {
            String ipAddress = element.getIPAddress();
            logger.info("Adding node ip to valid list : {}", (Object)ipAddress);
            Constants.NODE_IP_LIST.put(ipAddress, ipAddress);
        });
        this.nodeConfigurationRepository.findAll().forEach(nodeConfig -> {
            logger.info("Adding node ip to valid list : {}", (Object)nodeConfig.getNodeIp());
            Constants.NODE_IP_LIST.putIfAbsent(nodeConfig.getNodeIp(), nodeConfig.getNodeIp());
        });
    }

    public List<CallData> getCalls() {
        String[] callServerList;
        ArrayList<CallData> returnValue = new ArrayList<CallData>();
        for (String callServer : callServerList = (Constants.CALL_SERVER_IP + "," + Constants.ADDITIONAL_CALL_SERVERS).split(",")) {
            logger.info("Fetching data from : {}", (Object)callServer);
            try {
                RestTemplate restTemplate = new RestTemplate();
                ResponseEntity response = restTemplate.getForEntity(Constants.CALL_SERVER_IP + "/channels", CallChannels[].class, new Object[0]);
                CallChannels[] data = (CallChannels[])response.getBody();
                long currentTimestamp = System.currentTimeMillis() / 1000L;
                Arrays.stream(data).filter(row -> row.getDirection().equals("initiator") && !row.getState().equals("stale") && row.getRingEpoch() != null).forEach(channel -> returnValue.add(new CallData(channel.getLocalName(), channel.getRemoteName(), Long.valueOf(channel.getRingEpoch() == null ? 0L : channel.getRingEpoch() / 1000L), Long.valueOf(channel.getAnswerEpoch() == null ? 0L : channel.getAnswerEpoch() / 1000L), LocalTime.ofSecondOfDay((long)Math.floor((channel.getAnswerEpoch() == null || channel.getAnswerEpoch() == 0L ? currentTimestamp : channel.getAnswerEpoch() / 1000L) - channel.getRingEpoch() / 1000L)).toString(), LocalTime.ofSecondOfDay((long)Math.floor(currentTimestamp - channel.getRingEpoch() / 1000L)).toString(), "", "")));
            }
            catch (Exception e) {
                logger.error("Unable to fetch data from : {}", (Object)callServer, (Object)e);
            }
        }
        MetricsData.writeToHashMap((String)"activeCalls", (Long)Long.valueOf(returnValue.size()));
        return returnValue;
    }

    public List<ChannelActiveCallsModel> getActiveCallsFromDatabase() {
        ArrayList<ChannelActiveCallsModel> returnValue = new ArrayList<ChannelActiveCallsModel>();
        try {
            List activeCalls = this.activeCallRepository.findAll();
            long currentTimestamp = System.currentTimeMillis() / 1000L;
            for (ActiveCall activeCall : activeCalls) {
                Long startEpoch = activeCall.getStartEpoch();
                Long answerEpoch = activeCall.getAnswerEpoch();
                String ringDuration = LocalTime.ofSecondOfDay((long)Math.floor((answerEpoch == null || answerEpoch == 0L ? currentTimestamp : answerEpoch) - startEpoch)).toString();
                String callDuration = LocalTime.ofSecondOfDay((long)Math.floor(currentTimestamp - startEpoch)).toString();
                ChannelActiveCallsModel callData = new ChannelActiveCallsModel(StringUtils.hasLength((String)activeCall.getCidNum()) ? activeCall.getCidNum() : "", StringUtils.hasLength((String)activeCall.getCidName()) ? activeCall.getCidName() : activeCall.getCidNum(), StringUtils.hasLength((String)activeCall.getDest()) ? activeCall.getDest() : "", StringUtils.hasLength((String)activeCall.getDestName()) ? activeCall.getDestName() : activeCall.getDest(), startEpoch, answerEpoch, ringDuration, callDuration, activeCall.getCallDirection(), "", this.trimIpAddress(activeCall.getCallerIp()), this.trimIpAddress(activeCall.getDestinationIp()), "");
                returnValue.add(callData);
            }
            logger.info("Retrieved {} active calls from database", (Object)returnValue.size());
            MetricsData.writeToHashMap((String)"activeCalls", (Long)Long.valueOf(returnValue.size()));
        }
        catch (Exception e) {
            logger.error("Error fetching active calls from database :{} {}", (Object)e.getMessage(), (Object)e);
        }
        return returnValue;
    }

    public String trimIpAddress(String ip) {
        if (ip == null || !ip.contains(":")) {
            return ip;
        }
        return ip.split(":")[0];
    }

    public List<Registration> getIMSRegistrations(String widgetCode) {
        List activeNodes;
        List<Object> returnValue = new ArrayList<Registration>();
        Optional widgetData = this.widgetListRepository.findByCode(widgetCode);
        if (widgetData.isPresent() && !(activeNodes = this.telephonyDeploymentRepository.getActiveIP(((WidgetList)widgetData.get()).getMetricsInstanceName())).isEmpty()) {
            returnValue = this.registrationRepository.findByIpAddressOrderByStatusAscExtensionAsc(((ITelephonyTreeData)activeNodes.get(0)).getNodeIP());
        }
        return returnValue;
    }

    public List<CallData> getIMSRLUCalls(String widgetCode) {
        Optional widgetData = this.widgetListRepository.findByCode(widgetCode);
        if (widgetData.isPresent()) {
            if (Constants.NODE_MODE.contains("PBX")) {
                return HttpUtils.getRemoteCalls((String)((WidgetList)widgetData.get()).getMetricsInstanceName());
            }
            ArrayList<CallData> returnValue = new ArrayList<CallData>();
            String callServerURL = String.format("http%s://%s/api/v2/realtime/channels", Constants.CLUSTER_SSL_ENABLED != false ? "s" : "", ((WidgetList)widgetData.get()).getMetricsInstanceName());
            logger.info("Fetching data from : {}", (Object)callServerURL);
            try {
                RestTemplate restTemplate = new RestTemplate();
                ResponseEntity response = restTemplate.getForEntity(callServerURL, CallChannels[].class, new Object[0]);
                CallChannels[] data = (CallChannels[])response.getBody();
                long currentTimestamp = System.currentTimeMillis() / 1000L;
                Arrays.stream(data).filter(row -> row.getDirection().equals("initiator") && !row.getState().equals("stale") && row.getRingEpoch() != null && row.getInboundGateway() == null && row.getOutboundGateway() == null).forEach(channel -> returnValue.add(new CallData(StringUtils.hasLength((String)channel.getLocalName()) ? channel.getLocalName() : channel.getLocalUser(), StringUtils.hasLength((String)channel.getRemoteName()) ? channel.getRemoteName() : channel.getRemoteUser(), Long.valueOf(channel.getRingEpoch() == null ? 0L : channel.getRingEpoch() / 1000L), Long.valueOf(channel.getAnswerEpoch() == null ? 0L : channel.getAnswerEpoch() / 1000L), LocalTime.ofSecondOfDay((long)Math.floor((channel.getAnswerEpoch() == null || channel.getAnswerEpoch() == 0L ? currentTimestamp : channel.getAnswerEpoch() / 1000L) - channel.getRingEpoch() / 1000L)).toString(), LocalTime.ofSecondOfDay((long)Math.floor(currentTimestamp - channel.getRingEpoch() / 1000L)).toString(), "", "")));
            }
            catch (Exception e) {
                logger.error("Unable to fetch data from : {}", (Object)callServerURL, (Object)e);
            }
            return returnValue;
        }
        return new ArrayList<CallData>();
    }

    public List<CallData> getIMSRLUExternalCalls(String widgetCode) {
        Optional widgetData = this.widgetListRepository.findByCode(widgetCode);
        if (widgetData.isPresent()) {
            if (Constants.NODE_MODE.contains("PBX")) {
                List remoteCalls = HttpUtils.getRemoteCalls((String)((WidgetList)widgetData.get()).getMetricsInstanceName());
                return remoteCalls.stream().filter(call -> "IN".equals(call.getDirection()) || "OUT".equals(call.getDirection())).collect(Collectors.toList());
            }
            String callServerURL = String.format("http%s://%s/api/v2/realtime/channels", Constants.CLUSTER_SSL_ENABLED != false ? "s" : "", ((WidgetList)widgetData.get()).getMetricsInstanceName());
            logger.info("Fetching data from : {}", (Object)callServerURL);
            ArrayList<CallData> returnValue = new ArrayList<CallData>();
            try {
                RestTemplate restTemplate = new RestTemplate();
                ResponseEntity response = restTemplate.getForEntity(callServerURL, CallChannels[].class, new Object[0]);
                CallChannels[] data = (CallChannels[])response.getBody();
                long currentTimestamp = System.currentTimeMillis() / 1000L;
                Arrays.stream(data).filter(row -> row.getDirection().equals("initiator") && !row.getState().equals("stale") && row.getRingEpoch() != null && (StringUtils.hasLength((String)row.getInboundGateway()) || StringUtils.hasLength((String)row.getOutboundGateway()))).forEach(channel -> returnValue.add(new CallData(StringUtils.hasLength((String)channel.getLocalName()) ? channel.getLocalName() : channel.getLocalUser(), StringUtils.hasLength((String)channel.getRemoteName()) ? channel.getRemoteName() : channel.getRemoteUser(), Long.valueOf(channel.getRingEpoch() == null ? 0L : channel.getRingEpoch() / 1000L), Long.valueOf(channel.getAnswerEpoch() == null ? 0L : channel.getAnswerEpoch() / 1000L), LocalTime.ofSecondOfDay((long)Math.floor((channel.getAnswerEpoch() == null || channel.getAnswerEpoch() == 0L ? currentTimestamp : channel.getAnswerEpoch() / 1000L) - channel.getRingEpoch() / 1000L)).toString(), LocalTime.ofSecondOfDay((long)Math.floor(currentTimestamp - channel.getRingEpoch() / 1000L)).toString(), StringUtils.hasLength((String)channel.getInboundGateway()) ? "In" : "Out", StringUtils.hasLength((String)channel.getInboundGateway()) ? channel.getInboundGateway() : channel.getOutboundGateway())));
            }
            catch (Exception e) {
                logger.error("Unable to fetch data from : {}", (Object)callServerURL, (Object)e);
            }
            return returnValue;
        }
        return new ArrayList<CallData>();
    }

    public List<IMSIData> getIMSIData() {
        ArrayList<IMSIData> returnValue = new ArrayList<IMSIData>();
        this.imsiRepository.findByOrderByExtensionNameAscExtensionNumberAsc().stream().filter(row -> row.getIpAddress() != null && !row.getIpAddress().isEmpty()).forEach(imsi -> returnValue.add(new IMSIData(imsi.getExtensionNumber(), imsi.getExtensionName(), imsi.getDataRateEpoch(), String.format("%.2f Mbps", imsi.getUlDataRate()), String.format("%.2f Mbps", imsi.getDlDataRate()), imsi.getIpAddress(), Long.valueOf((long)((double)imsi.getUlData().longValue() / 1048576.0)), Long.valueOf((long)((double)imsi.getDlData().longValue() / 1048576.0)), imsi.getLastConnectionOn())));
        return returnValue;
    }

    public List<TimeSeriesDataModel> getULDataRateOld() {
        ArrayList<TimeSeriesDataModel> returnValue = new ArrayList<TimeSeriesDataModel>();
        TimeSeriesDataModel data = new TimeSeriesDataModel();
        data.setAttributeName("ulDataRate");
        data.setAttributeValue(String.format("%.2f", Constants.TotalBandwidth.getData()[0]));
        data.setEventEpoch(Long.valueOf(System.currentTimeMillis() / 1000L));
        data.setReceivedEpoch(data.getEventEpoch());
        returnValue.add(data);
        return returnValue;
    }

    public List<SensorDataModel> getULDataRate() {
        ArrayList<SensorDataModel> returnValue = new ArrayList<SensorDataModel>();
        Long epoch = Instant.now().getEpochSecond();
        SensorDataModel upperThreshold = new SensorDataModel("Upper Threshold", "", "upperThreshold", epoch, epoch);
        SensorDataModel lowerThreshold = new SensorDataModel("Lower Threshold", "", "lowerThreshold", epoch, epoch);
        SensorDataModel minValue = new SensorDataModel("Minimum Value", "0.0", "minValue", epoch, epoch);
        SensorDataModel maxValue = new SensorDataModel("Minimum Value", "0.0", "maxValue", epoch, epoch);
        SensorDataModel currentValue = new SensorDataModel("Current Value", "0.0", "currentValue", epoch, epoch);
        Double max = 100.0;
        Double value = Constants.TotalBandwidth.getData()[0];
        lowerThreshold.setAttributeValue(String.format("%.1f", max * 10.0 / 100.0));
        upperThreshold.setAttributeValue(String.format("%.1f", max * 95.0 / 100.0));
        currentValue.setAttributeValue(String.format("%.1f", value));
        maxValue.setAttributeValue(String.format("%.1f", max));
        returnValue.add(currentValue);
        returnValue.add(minValue);
        returnValue.add(lowerThreshold);
        returnValue.add(upperThreshold);
        returnValue.add(maxValue);
        return returnValue;
    }

    public List<TimeSeriesDataModel> getDLDataRateOld() {
        ArrayList<TimeSeriesDataModel> returnValue = new ArrayList<TimeSeriesDataModel>();
        TimeSeriesDataModel data = new TimeSeriesDataModel();
        data.setAttributeName("dlDataRate");
        data.setAttributeValue(String.format("%.2f", Constants.TotalBandwidth.getData()[1]));
        data.setEventEpoch(Long.valueOf(System.currentTimeMillis() / 1000L));
        data.setReceivedEpoch(data.getEventEpoch());
        returnValue.add(data);
        return returnValue;
    }

    public List<SensorDataModel> getDLDataRate() {
        ArrayList<SensorDataModel> returnValue = new ArrayList<SensorDataModel>();
        Long epoch = Instant.now().getEpochSecond();
        SensorDataModel upperThreshold = new SensorDataModel("Upper Threshold", "", "upperThreshold", epoch, epoch);
        SensorDataModel lowerThreshold = new SensorDataModel("Lower Threshold", "", "lowerThreshold", epoch, epoch);
        SensorDataModel minValue = new SensorDataModel("Minimum Value", "0.0", "minValue", epoch, epoch);
        SensorDataModel maxValue = new SensorDataModel("Minimum Value", "0.0", "maxValue", epoch, epoch);
        SensorDataModel currentValue = new SensorDataModel("Current Value", "0.0", "currentValue", epoch, epoch);
        Double max = 100.0;
        Double value = Constants.TotalBandwidth.getData()[1];
        lowerThreshold.setAttributeValue(String.format("%.1f", max * 10.0 / 100.0));
        upperThreshold.setAttributeValue(String.format("%.1f", max * 95.0 / 100.0));
        currentValue.setAttributeValue(String.format("%.1f", value));
        maxValue.setAttributeValue(String.format("%.1f", max));
        returnValue.add(currentValue);
        returnValue.add(minValue);
        returnValue.add(lowerThreshold);
        returnValue.add(upperThreshold);
        returnValue.add(maxValue);
        return returnValue;
    }

    public List<TimeSeriesDataModel> getCounter(String widgetCode) {
        ArrayList<TimeSeriesDataModel> returnValue = new ArrayList<TimeSeriesDataModel>();
        Optional widgetData = this.widgetListRepository.findByCode(widgetCode);
        if (widgetData.isPresent()) {
            this.counterRepository.getCounterData(((WidgetList)widgetData.get()).getBaseCode(), Integer.valueOf(30)).stream().forEach(row -> returnValue.add(new TimeSeriesDataModel(row.getAttributeName(), row.getAttributeValue(), row.getEventEpoch(), row.getEventEpoch())));
        }
        return returnValue;
    }

    public List<SensorDataModel> getSystemInfoLoadAverage(String widgetCode) {
        SensorDataModel[] data;
        ArrayList<SensorDataModel> returnValue = new ArrayList<SensorDataModel>();
        Optional widgetData = this.widgetListRepository.findByCode(widgetCode);
        if (widgetData.isPresent()) {
            data = this.getCallServerData(((WidgetList)widgetData.get()).getMetricsInstanceName(), "/services/api/v2/telemetry/systemInfo/loadAverage");
        } else {
            data = new SensorDataModel[]{new SensorDataModel()};
            data[0].setAttributeName("Data");
            data[0].setAttributeValue("0");
            data[0].setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            data[0].setReceivedEpoch(data[0].getEventEpoch());
        }
        Arrays.stream(data).forEach(returnValue::add);
        return returnValue;
    }

    public List<SensorDataModel> getSystemInfoVirtualMemory(String widgetCode) {
        SensorDataModel[] data;
        ArrayList<SensorDataModel> returnValue = new ArrayList<SensorDataModel>();
        Optional widgetData = this.widgetListRepository.findByCode(widgetCode);
        if (widgetData.isPresent()) {
            data = this.getCallServerData(((WidgetList)widgetData.get()).getMetricsInstanceName(), "/services/api/v2/telemetry/systemInfo/virtualMemory");
        } else {
            data = new SensorDataModel[]{new SensorDataModel()};
            data[0].setAttributeName("Data");
            data[0].setAttributeValue("0");
            data[0].setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            data[0].setReceivedEpoch(data[0].getEventEpoch());
        }
        Arrays.stream(data).forEach(returnValue::add);
        return returnValue;
    }

    public ChartDataModel getMultiSeriesData() {
        ChartDataModel returnValue = new ChartDataModel();
        returnValue.getLabel().add("1:00");
        returnValue.getLabel().add("2:00");
        returnValue.getLabel().add("3:00");
        returnValue.getLabel().add("4:00");
        returnValue.getLabel().add("5:00");
        returnValue.getLabel().add("6:00");
        returnValue.getLabel().add("7:00");
        returnValue.getLabel().add("8:00");
        returnValue.getLabel().add("9:00");
        returnValue.getLabel().add("10:00");
        SeriesModel cpu = new SeriesModel();
        cpu.setSeriesName("CPU Load %");
        cpu.setSeriesType("line-chart");
        cpu.getValues().add("91");
        cpu.getValues().add("16");
        cpu.getValues().add("52");
        cpu.getValues().add("10");
        cpu.getValues().add("1");
        cpu.getValues().add("98");
        cpu.getValues().add("53");
        cpu.getValues().add("90");
        cpu.getValues().add("74");
        cpu.getValues().add("85");
        SeriesModel memory = new SeriesModel();
        memory.setSeriesName("Memory consumption %");
        memory.setSeriesType("line-chart");
        memory.getValues().add("75");
        memory.getValues().add("27");
        memory.getValues().add("38");
        memory.getValues().add("80");
        memory.getValues().add("86");
        memory.getValues().add("89");
        memory.getValues().add("51");
        memory.getValues().add("94");
        memory.getValues().add("88");
        memory.getValues().add("34");
        SeriesModel processCount = new SeriesModel();
        processCount.setSeriesName("Process Count");
        processCount.setSeriesType("bar");
        processCount.getValues().add("57");
        processCount.getValues().add("6");
        processCount.getValues().add("75");
        processCount.getValues().add("3");
        processCount.getValues().add("13");
        processCount.getValues().add("58");
        processCount.getValues().add("84");
        processCount.getValues().add("55");
        processCount.getValues().add("56");
        processCount.getValues().add("43");
        returnValue.getSeries().add(cpu);
        returnValue.getSeries().add(memory);
        returnValue.getSeries().add(processCount);
        return returnValue;
    }

    public List<SensorDataModel> getSystemInfoRealMemory(String widgetCode) {
        SensorDataModel[] data;
        ArrayList<SensorDataModel> returnValue = new ArrayList<SensorDataModel>();
        Optional widgetData = this.widgetListRepository.findByCode(widgetCode);
        if (widgetData.isPresent()) {
            data = this.getCallServerData(((WidgetList)widgetData.get()).getMetricsInstanceName(), "/services/api/v2/telemetry/systemInfo/realMemory");
        } else {
            data = new SensorDataModel[]{new SensorDataModel()};
            data[0].setAttributeName("Data");
            data[0].setAttributeValue("0");
            data[0].setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            data[0].setReceivedEpoch(data[0].getEventEpoch());
        }
        Long epoch = Instant.now().getEpochSecond();
        SensorDataModel upperThreshold = new SensorDataModel("Upper Threshold", "", "upperThreshold", epoch, epoch);
        SensorDataModel lowerThreshold = new SensorDataModel("Lower Threshold", "", "lowerThreshold", epoch, epoch);
        SensorDataModel minValue = new SensorDataModel("Minimum Value", "0.0", "minValue", epoch, epoch);
        SensorDataModel maxValue = new SensorDataModel("Minimum Value", "0.0", "maxValue", epoch, epoch);
        SensorDataModel currentValue = new SensorDataModel("Current Value", "0.0", "currentValue", epoch, epoch);
        Arrays.stream(data).forEach(metric -> {
            if (metric.getAttributeName().startsWith("Total Real")) {
                maxValue.setAttributeName(metric.getAttributeName());
                maxValue.setAttributeValue(metric.getAttributeValue());
                Double value = Double.valueOf(metric.getAttributeValue());
                lowerThreshold.setAttributeValue(String.format("%.1f", value * 10.0 / 100.0));
                upperThreshold.setAttributeValue(String.format("%.1f", value * 95.0 / 100.0));
            } else if (metric.getAttributeName().startsWith("Used Real")) {
                currentValue.setAttributeName(metric.getAttributeName());
                currentValue.setAttributeValue(metric.getAttributeValue());
            }
        });
        returnValue.add(currentValue);
        returnValue.add(minValue);
        returnValue.add(lowerThreshold);
        returnValue.add(upperThreshold);
        return returnValue;
    }

    public List<SensorDataModel> getSystemInfoDiskStorage(String widgetCode) {
        SensorDataModel[] data;
        ArrayList<SensorDataModel> returnValue = new ArrayList<SensorDataModel>();
        Optional widgetData = this.widgetListRepository.findByCode(widgetCode);
        if (widgetData.isPresent()) {
            data = this.getCallServerData(((WidgetList)widgetData.get()).getMetricsInstanceName(), "/services/api/v2/telemetry/systemInfo/diskStorage");
        } else {
            data = new SensorDataModel[]{new SensorDataModel()};
            data[0].setAttributeName("Data");
            data[0].setAttributeValue("0");
            data[0].setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            data[0].setReceivedEpoch(data[0].getEventEpoch());
        }
        Arrays.stream(data).forEach(returnValue::add);
        return returnValue;
    }

    public List<SensorDataModel> getSystemInfoAdditionalInfo(String widgetCode) {
        SensorDataModel[] data;
        ArrayList<SensorDataModel> returnValue = new ArrayList<SensorDataModel>();
        Optional widgetData = this.widgetListRepository.findByCode(widgetCode);
        if (widgetData.isPresent()) {
            data = this.getCallServerData(((WidgetList)widgetData.get()).getMetricsInstanceName(), "/services/api/v2/telemetry/systemInfo/additionalInfo");
        } else {
            data = new SensorDataModel[]{new SensorDataModel()};
            data[0].setAttributeName("Data");
            data[0].setAttributeValue("0");
            data[0].setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            data[0].setReceivedEpoch(data[0].getEventEpoch());
        }
        Arrays.stream(data).forEach(returnValue::add);
        return returnValue;
    }

    public RequestResponse getCommandAlerts() {
        return this.alertDetailService.getAll();
    }

    public List<TelephonyDeployment> getAllNodes() {
        return this.telephonyDeploymentRepository.findAll();
    }

    public RequestResponse getTelephonyTree() {
        RequestResponse returnValue = new RequestResponse();
        List allNodes = this.telephonyDeploymentRepository.getTreeData();
        ArrayList<AssetTree> treeData = new ArrayList<AssetTree>();
        AssetTree telephony = new AssetTree();
        telephony.setLevel(Integer.valueOf(1));
        telephony.setId("telephony");
        telephony.setNodeId(Integer.valueOf(0));
        telephony.setIpAddress("");
        telephony.setName("IMS");
        telephony.setCategory("Location");
        telephony.setStatus(Boolean.valueOf(true));
        telephony.setLocation("telephony");
        telephony.setHideSummary(Boolean.valueOf(true));
        List rluList = this.telephonyDeploymentRepository.getRLU();
        for (IRLU rluData : rluList) {
            AssetTree rlu = new AssetTree();
            rlu.setLevel(Integer.valueOf(2));
            rlu.setId(rluData.getRLUCode());
            rlu.setNodeId(Integer.valueOf(0));
            rlu.setIpAddress("");
            rlu.setName(rluData.getRLUCode() + "(" + rluData.getHostName() + ")");
            rlu.setCategory("Location");
            rlu.setStatus(Boolean.valueOf(true));
            rlu.setLocation(rluData.getRLUCode());
            rlu.setSummarize(Boolean.valueOf(false));
            List rluNodes = allNodes.stream().filter(row -> row.getRluCode().equals(rluData.getRLUCode())).collect(Collectors.toList());
            for (ITelephonyTreeData rluNode : rluNodes) {
                AssetTree node = new AssetTree();
                node.setLevel(Integer.valueOf(3));
                node.setId(rlu.getId() + "-" + rluNode.getServerCode());
                node.setNodeId(Integer.valueOf(0));
                node.setIpAddress("");
                node.setName(rluNode.getNodeIP());
                node.setCategory("Location");
                node.setStatus(rluNode.getStatus());
                node.setLocation(rluData.getRLUCode());
                node.setSeverity(rluNode.getSeverity());
                node.setSeverityUpdatedOn(rluNode.getSeverityUpdatedOn());
                node.setSummarize(Boolean.valueOf(rluNode.getHostName().equals(rluNode.getNodeName())));
                node.setShowHighlighted(Boolean.valueOf(rluNode.getHostName().equals(rluNode.getNodeName())));
                List registrations = this.registrationRepository.findByServerCodeOrderByStatus(rluNode.getServerCode());
                for (Registration registration : registrations) {
                    AssetTree registrationNode = new AssetTree();
                    registrationNode.setLevel(Integer.valueOf(4));
                    registrationNode.setId(registration.getExtensionId());
                    registrationNode.setNodeId(Integer.valueOf(0));
                    registrationNode.setIpAddress("");
                    registrationNode.setName(registration.getExtension() + (StringUtils.hasLength((String)registration.getExtensionName()) ? " - " + registration.getExtensionName() : ""));
                    registrationNode.setCategory("Registration");
                    registrationNode.setLocation(rluData.getRLUCode());
                    registrationNode.setStatus(registration.getStatus());
                    registrationNode.setSeverity(Integer.valueOf(registrationNode.getStatus() != false ? 0 : 3));
                    registrationNode.setSeverityUpdatedOn(rluNode.getSeverityUpdatedOn());
                    node.getChildren().add(registrationNode);
                }
                rlu.getChildren().add(node);
            }
            telephony.getChildren().add(rlu);
        }
        treeData.add(telephony);
        returnValue.setData(treeData);
        return returnValue;
    }

    public void updateNodeInformation(TelephonyDeployment node) {
        String hostName = this.getRLUHostName(node.getVirtualIP());
        node.setHostName(hostName);
        String serverIP = node.getNodeIP();
        RegistrationModel[] nodeRegistrations = this.getCallServerRegistrations(serverIP);
        if (nodeRegistrations != null) {
            String iterationId = UUID.randomUUID().toString();
            Boolean isFirst = true;
            for (RegistrationModel nodeRegistration : nodeRegistrations) {
                Registration dataToSave;
                String extensionId = node.getServerCode() + "-" + nodeRegistration.getExtension();
                Optional registration = this.registrationRepository.findById((Object)extensionId);
                if (registration.isPresent()) {
                    dataToSave = (Registration)registration.get();
                } else {
                    dataToSave = new Registration();
                    dataToSave.setExtensionId(extensionId);
                }
                dataToSave.setServerCode(node.getServerCode());
                dataToSave.setEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                dataToSave.setIpAddress(serverIP);
                dataToSave.setExtension(nodeRegistration.getExtension());
                dataToSave.setExtensionType(nodeRegistration.getExtensionType());
                dataToSave.setExtensionSubType(nodeRegistration.getExtensionSubType());
                dataToSave.setExtensionName(nodeRegistration.getName());
                dataToSave.setContact(nodeRegistration.getContact());
                dataToSave.setRluCode(nodeRegistration.getRluCode());
                dataToSave.setUserAgent(nodeRegistration.getUserAgent());
                dataToSave.setRegisteredOn(nodeRegistration.getRegisteredOn());
                dataToSave.setAssignedUser(nodeRegistration.getAssignedUser());
                dataToSave.setExpiredOn(nodeRegistration.getExpiredOn());
                if (nodeRegistration.getStatus() == null) {
                    dataToSave.setStatus(Boolean.valueOf(false));
                } else {
                    dataToSave.setStatus(nodeRegistration.getStatus());
                }
                dataToSave.setSeverity(Integer.valueOf(nodeRegistration.getStatus() != false ? 0 : 3));
                dataToSave.setIterationId(iterationId);
                this.registrationRepository.save((Object)dataToSave);
                if (!isFirst.booleanValue()) continue;
                node.setCurrentEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                node.setFetchTime(nodeRegistration.getCurrentEpoch());
                this.telephonyDeploymentRepository.save((Object)node);
                isFirst = false;
            }
            this.registrationRepository.findByServerCodeOrderByStatus(node.getServerCode()).forEach(row -> {
                if (!row.getIterationId().equals(iterationId)) {
                    this.registrationRepository.delete(row);
                }
            });
        } else {
            node.setCurrentEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            this.telephonyDeploymentRepository.save((Object)node);
            logger.error("No data found for node : {}", (Object)serverIP);
        }
    }

    private SensorDataModel[] getCallServerData(String ipAddress, String apiUrl) {
        SensorDataModel[] returnValue;
        try {
            String restURL = (Constants.CLUSTER_SSL_ENABLED != false ? "https://" : "http://") + ipAddress + apiUrl;
            ResponseEntity response = this.restTemplate.postForEntity(restURL, (Object)this.entity, CallServerResponse.class, new Object[0]);
            CallServerResponse data = (CallServerResponse)response.getBody();
            SensorDataModel[] sensorDataModelArray = returnValue = data == null || data.getData() == null ? null : data.getData();
            if (returnValue == null || returnValue.length == 0) {
                returnValue = new SensorDataModel[]{new SensorDataModel()};
                returnValue[0].setAttributeName("Data");
                returnValue[0].setAttributeValue("0");
                returnValue[0].setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                returnValue[0].setReceivedEpoch(returnValue[0].getEventEpoch());
            }
        }
        catch (Exception E) {
            logger.error("Error while fetching information from {} url {}", (Object)ipAddress, (Object)apiUrl, (Object)E);
            returnValue = new SensorDataModel[]{new SensorDataModel()};
            returnValue[0].setAttributeName("Data");
            returnValue[0].setAttributeValue("0");
            returnValue[0].setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            returnValue[0].setReceivedEpoch(returnValue[0].getEventEpoch());
        }
        return returnValue;
    }

    private RegistrationModel[] getCallServerRegistrations(String ipAddress) {
        logger.info("Get Registration from {}", (Object)ipAddress);
        String apiUrl = "/services/api/v2/extensions/registeredList";
        RegistrationModel[] returnValue = null;
        try {
            String restURL = (Constants.CLUSTER_SSL_ENABLED != false ? "https://" : "http://") + ipAddress + apiUrl;
            ResponseEntity response = this.restTemplate.postForEntity(restURL, (Object)this.entity, RegistrationResponse.class, new Object[0]);
            RegistrationResponse data = (RegistrationResponse)response.getBody();
            returnValue = data == null || data.getData() == null ? null : data.getData();
        }
        catch (Exception E) {
            logger.error("Error while fetching information from {} url {}", (Object)ipAddress, (Object)apiUrl, (Object)E);
        }
        return returnValue;
    }

    private String getRLUHostName(String ipAddress) {
        logger.info("Get Hostname from {}", (Object)ipAddress);
        String apiUrl = "/hostname";
        String returnValue = "-";
        try {
            String restURL = (Constants.CLUSTER_SSL_ENABLED != false ? "https://" : "http://") + ipAddress + apiUrl;
            ResponseEntity response = this.restTemplate.postForEntity(restURL, (Object)this.entity, String.class, new Object[0]);
            returnValue = (String)response.getBody();
        }
        catch (Exception E) {
            logger.error("Error while fetching information from {} url {}", (Object)ipAddress, (Object)apiUrl, (Object)E);
        }
        return returnValue;
    }

    public List<BaseStationData> getBaseStationData() {
        ArrayList<BaseStationData> returnValue = new ArrayList<BaseStationData>();
        long CACHE_TIMEOUT_SECONDS = 900L;
        long currentEpoch = Instant.now().getEpochSecond();
        this.scadaAssetRepository.getBaseStationData().forEach(data -> {
            try {
                String uptime;
                if (data.getLastKnownUptime() != null && data.getLastKnownUptimeFetchEpoch() != null && currentEpoch - data.getLastKnownUptimeFetchEpoch() < 900L) {
                    uptime = data.getLastKnownUptime();
                    logger.debug("Using cached uptime for {} (ID: {}): {}", (Object)data.getIpAddress(), (Object)data.getId(), (Object)uptime);
                } else {
                    uptime = this.fetchAndCacheUptime(data.getId(), data.getIpAddress());
                }
                returnValue.add(new BaseStationData(data.getIpAddress(), data.getNodeName(), data.getCellId(), data.getCategory(), data.getStatus() != false ? "UP" : "DOWN", data.getStatus() != false ? data.getAlertClosedOn() : data.getAlertGeneratedOn(), data.getNgapStatus() != false ? "UP" : "DOWN", data.getNgapStatusEpoch(), uptime));
            }
            catch (Exception e) {
                logger.error("Error fetching uptime for base station {} (ID: {}): {}", (Object)data.getIpAddress(), (Object)data.getId(), (Object)e.getMessage(), (Object)e);
            }
        });
        return returnValue;
    }

    private String fetchAndCacheUptime(Long id, String ipAddress) {
        String uptime = this.getUptimeViaSSH(ipAddress);
        try {
            long fetchEpoch = Instant.now().getEpochSecond();
            this.scadaAssetRepository.updateUptimeById(id, uptime, Long.valueOf(fetchEpoch));
            logger.debug("Updated uptime cache for {} (ID: {}): {} at epoch {}", (Object)ipAddress, (Object)id, (Object)uptime, (Object)fetchEpoch);
        }
        catch (Exception e) {
            logger.error("Error updating uptime cache for {} (ID: {}): {}", (Object)ipAddress, (Object)id, (Object)e.getMessage(), (Object)e);
        }
        return uptime;
    }

    private String getUptimeViaSSH(String ipAddress) {
        if (ipAddress == null || ipAddress.isEmpty()) {
            return "N/A";
        }
        try {
            String command = "ssh root@" + ipAddress + " 'uptime'";
            logger.debug("Executing SSH command: {}", (Object)command);
            Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", command});
            StringBuilder output = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    output.append(line);
                }
            }
            boolean finished = process.waitFor(5L, TimeUnit.SECONDS);
            if (!finished) {
                process.destroy();
                logger.warn("SSH command timeout for IP: {}", (Object)ipAddress);
                return "Timeout";
            }
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                StringBuilder errorOutput = new StringBuilder();
                try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                    String line;
                    while ((line = errorReader.readLine()) != null) {
                        errorOutput.append(line);
                    }
                }
                logger.error("SSH command failed for {} with exit code {}: {}", (Object)ipAddress, (Object)exitCode, (Object)errorOutput.toString());
                return "Error";
            }
            String uptimeResult = output.toString().trim();
            logger.debug("Full uptime output for {}: {}", (Object)ipAddress, (Object)uptimeResult);
            String parsedUptime = this.parseUptimeFromOutput(uptimeResult);
            return parsedUptime;
        }
        catch (IOException e) {
            logger.error("IOException while executing SSH command for {}: {}", (Object)ipAddress, (Object)e.getMessage());
            return "Error";
        }
        catch (InterruptedException e) {
            logger.error("SSH command interrupted for {}: {}", (Object)ipAddress, (Object)e.getMessage());
            Thread.currentThread().interrupt();
            return "Interrupted";
        }
        catch (Exception e) {
            logger.error("Unexpected error while fetching uptime for {}: {}", (Object)ipAddress, (Object)e.getMessage(), (Object)e);
            return "N/A";
        }
    }

    private String parseUptimeFromOutput(String uptimeOutput) {
        if (uptimeOutput == null || uptimeOutput.isEmpty()) {
            return "N/A";
        }
        try {
            int upIndex = uptimeOutput.indexOf("up");
            if (upIndex == -1) {
                return "N/A";
            }
            int commaIndex = uptimeOutput.indexOf(",", upIndex);
            if (commaIndex == -1) {
                return "N/A";
            }
            String uptime = uptimeOutput.substring(upIndex + 2, commaIndex).trim();
            logger.debug("Parsed uptime: {}", (Object)uptime);
            return uptime;
        }
        catch (Exception e) {
            logger.error("Error parsing uptime from output: {}", (Object)uptimeOutput, (Object)e);
            return "N/A";
        }
    }

    private String getUptimeViaSNMP(String ipAddress) {
        return this.getUptimeViaSNMP(ipAddress, "public", 161);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUptimeViaSNMP(String ipAddress, String community, int port) {
        String string;
        if (ipAddress == null || ipAddress.isEmpty()) {
            return "N/A";
        }
        String hrSystemUptimeOID = "1.3.6.1.2.1.25.1.1.0";
        Snmp snmp = null;
        DefaultUdpTransportMapping transport = null;
        try {
            logger.debug("Executing SNMP GET for uptime from IP: {}", (Object)ipAddress);
            transport = new DefaultUdpTransportMapping();
            snmp = new Snmp((TransportMapping)transport);
            transport.listen();
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(community));
            target.setAddress((Address)new UdpAddress(ipAddress + "/" + port));
            target.setRetries(2);
            target.setTimeout(5000L);
            target.setVersion(1);
            PDU pdu = new PDU();
            pdu.add(new VariableBinding(new OID(hrSystemUptimeOID)));
            pdu.setType(-96);
            ResponseEvent response = snmp.send(pdu, (Target)target);
            if (response == null) {
                logger.warn("SNMP request timeout for IP: {}", (Object)ipAddress);
                String string2 = "Timeout";
                return string2;
            }
            PDU responsePDU = response.getResponse();
            if (responsePDU == null) {
                logger.warn("No SNMP response received from IP: {}", (Object)ipAddress);
                String e = "No Response";
                return e;
            }
            if (responsePDU.getErrorStatus() != 0) {
                logger.error("SNMP error for {} - Status: {}, Index: {}", (Object)ipAddress, (Object)responsePDU.getErrorStatus(), (Object)responsePDU.getErrorIndex());
                String e = "SNMP Error";
                return e;
            }
            VariableBinding vb = responsePDU.get(0);
            if (vb == null || vb.getVariable() == null) {
                logger.warn("No variable binding in SNMP response from IP: {}", (Object)ipAddress);
                String e = "N/A";
                return e;
            }
            long uptimeHundredths = vb.getVariable().toLong();
            String formattedUptime = this.formatSNMPUptime(uptimeHundredths);
            logger.debug("SNMP Uptime for {}: {} (raw: {} hundredths)", (Object)ipAddress, (Object)formattedUptime, (Object)uptimeHundredths);
            String string3 = formattedUptime;
            return string3;
        }
        catch (IOException e) {
            logger.error("IOException while executing SNMP query for {}: {}", (Object)ipAddress, (Object)e.getMessage());
            string = "Error";
            return string;
        }
        catch (Exception e) {
            logger.error("Unexpected error while fetching SNMP uptime for {}: {}", (Object)ipAddress, (Object)e.getMessage(), (Object)e);
            string = "N/A";
            return string;
        }
        finally {
            try {
                if (snmp != null) {
                    snmp.close();
                }
                if (transport != null) {
                    transport.close();
                }
            }
            catch (IOException e) {
                logger.error("Error closing SNMP resources: {}", (Object)e.getMessage());
            }
        }
    }

    private String formatSNMPUptime(long uptimeHundredths) {
        long totalSeconds = uptimeHundredths / 100L;
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        if (days > 0L) {
            return String.format("%d day%s, %d:%02d", days, days == 1L ? "" : "s", hours, minutes);
        }
        return String.format("%d:%02d", hours, minutes);
    }

    public SystemInfoModel getSystemInfoViaSNMP(String ipAddress) {
        return this.getSystemInfoViaSNMP(ipAddress, "public", 161);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemInfoModel getSystemInfoViaSNMP(String ipAddress, String community, int port) {
        SystemInfoModel systemInfoModel;
        if (ipAddress == null || ipAddress.isEmpty()) {
            return new SystemInfoModel("Invalid IP");
        }
        String hrSystemUptimeOID = "1.3.6.1.2.1.25.1.1.0";
        String loadAverage1minOID = "1.3.6.1.4.1.2021.10.1.3.1";
        String loadAverage5minOID = "1.3.6.1.4.1.2021.10.1.3.2";
        String loadAverage15minOID = "1.3.6.1.4.1.2021.10.1.3.3";
        String cpuUserOID = "1.3.6.1.4.1.2021.11.9.0";
        String cpuSystemOID = "1.3.6.1.4.1.2021.11.10.0";
        String cpuIdleOID = "1.3.6.1.4.1.2021.11.11.0";
        Snmp snmp = null;
        DefaultUdpTransportMapping transport = null;
        try {
            logger.debug("Executing SNMP GET for system info from IP: {}", (Object)ipAddress);
            transport = new DefaultUdpTransportMapping();
            snmp = new Snmp((TransportMapping)transport);
            transport.listen();
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(community));
            target.setAddress((Address)new UdpAddress(ipAddress + "/" + port));
            target.setRetries(2);
            target.setTimeout(5000L);
            target.setVersion(1);
            PDU pdu = new PDU();
            pdu.add(new VariableBinding(new OID(hrSystemUptimeOID)));
            pdu.add(new VariableBinding(new OID(loadAverage1minOID)));
            pdu.add(new VariableBinding(new OID(loadAverage5minOID)));
            pdu.add(new VariableBinding(new OID(loadAverage15minOID)));
            pdu.add(new VariableBinding(new OID(cpuUserOID)));
            pdu.add(new VariableBinding(new OID(cpuSystemOID)));
            pdu.add(new VariableBinding(new OID(cpuIdleOID)));
            pdu.setType(-96);
            ResponseEvent response = snmp.send(pdu, (Target)target);
            if (response == null) {
                logger.warn("SNMP request timeout for IP: {}", (Object)ipAddress);
                SystemInfoModel systemInfoModel2 = new SystemInfoModel("Timeout");
                return systemInfoModel2;
            }
            PDU responsePDU = response.getResponse();
            if (responsePDU == null) {
                logger.warn("No SNMP response received from IP: {}", (Object)ipAddress);
                SystemInfoModel e = new SystemInfoModel("No Response");
                return e;
            }
            if (responsePDU.getErrorStatus() != 0) {
                logger.error("SNMP error for {} - Status: {}, Index: {}", (Object)ipAddress, (Object)responsePDU.getErrorStatus(), (Object)responsePDU.getErrorIndex());
                SystemInfoModel e = new SystemInfoModel("SNMP Error");
                return e;
            }
            SystemInfoModel systemInfo = new SystemInfoModel();
            systemInfo.setStatus("Success");
            if (responsePDU.size() > 0) {
                VariableBinding uptimeVB = responsePDU.get(0);
                if (uptimeVB != null && uptimeVB.getVariable() != null) {
                    long uptimeHundredths = uptimeVB.getVariable().toLong();
                    systemInfo.setUptimeRaw(Long.valueOf(uptimeHundredths));
                    systemInfo.setUptime(this.formatSNMPUptime(uptimeHundredths));
                } else {
                    systemInfo.setUptime("N/A");
                }
                if (responsePDU.size() > 1) {
                    VariableBinding load1VB = responsePDU.get(1);
                    if (load1VB != null && load1VB.getVariable() != null && !load1VB.getVariable().toString().equals("noSuchObject") && !load1VB.getVariable().toString().equals("noSuchInstance")) {
                        systemInfo.setLoadAverage1min(load1VB.getVariable().toString());
                    } else {
                        systemInfo.setLoadAverage1min("N/A");
                    }
                }
                if (responsePDU.size() > 2) {
                    VariableBinding load5VB = responsePDU.get(2);
                    if (load5VB != null && load5VB.getVariable() != null && !load5VB.getVariable().toString().equals("noSuchObject") && !load5VB.getVariable().toString().equals("noSuchInstance")) {
                        systemInfo.setLoadAverage5min(load5VB.getVariable().toString());
                    } else {
                        systemInfo.setLoadAverage5min("N/A");
                    }
                }
                if (responsePDU.size() > 3) {
                    VariableBinding load15VB = responsePDU.get(3);
                    if (load15VB != null && load15VB.getVariable() != null && !load15VB.getVariable().toString().equals("noSuchObject") && !load15VB.getVariable().toString().equals("noSuchInstance")) {
                        systemInfo.setLoadAverage15min(load15VB.getVariable().toString());
                    } else {
                        systemInfo.setLoadAverage15min("N/A");
                    }
                }
                if (responsePDU.size() > 4) {
                    VariableBinding cpuUserVB = responsePDU.get(4);
                    if (cpuUserVB != null && cpuUserVB.getVariable() != null && !cpuUserVB.getVariable().toString().equals("noSuchObject") && !cpuUserVB.getVariable().toString().equals("noSuchInstance")) {
                        systemInfo.setCpuUser(cpuUserVB.getVariable().toString() + "%");
                    } else {
                        systemInfo.setCpuUser("N/A");
                    }
                }
                if (responsePDU.size() > 5) {
                    VariableBinding cpuSystemVB = responsePDU.get(5);
                    if (cpuSystemVB != null && cpuSystemVB.getVariable() != null && !cpuSystemVB.getVariable().toString().equals("noSuchObject") && !cpuSystemVB.getVariable().toString().equals("noSuchInstance")) {
                        systemInfo.setCpuSystem(cpuSystemVB.getVariable().toString() + "%");
                    } else {
                        systemInfo.setCpuSystem("N/A");
                    }
                }
                if (responsePDU.size() > 6) {
                    VariableBinding cpuIdleVB = responsePDU.get(6);
                    if (cpuIdleVB != null && cpuIdleVB.getVariable() != null && !cpuIdleVB.getVariable().toString().equals("noSuchObject") && !cpuIdleVB.getVariable().toString().equals("noSuchInstance")) {
                        String idleValue = cpuIdleVB.getVariable().toString();
                        systemInfo.setCpuIdle(idleValue + "%");
                        try {
                            double idle = Double.parseDouble(idleValue);
                            double utilization = 100.0 - idle;
                            systemInfo.setCpuUtilization(String.format("%.2f%%", utilization));
                        }
                        catch (NumberFormatException e) {
                            systemInfo.setCpuUtilization("N/A");
                        }
                    } else {
                        systemInfo.setCpuIdle("N/A");
                        systemInfo.setCpuUtilization("N/A");
                    }
                }
            }
            logger.debug("SNMP System Info for {}: Uptime={}, Load1={}, Load5={}, Load15={}, CPU={}", (Object)ipAddress, (Object)systemInfo.getUptime(), (Object)systemInfo.getLoadAverage1min(), (Object)systemInfo.getLoadAverage5min(), (Object)systemInfo.getLoadAverage15min(), (Object)systemInfo.getCpuUtilization());
            SystemInfoModel systemInfoModel3 = systemInfo;
            return systemInfoModel3;
        }
        catch (IOException e) {
            logger.error("IOException while executing SNMP query for {}: {}", (Object)ipAddress, (Object)e.getMessage());
            systemInfoModel = new SystemInfoModel("Error: " + e.getMessage());
            return systemInfoModel;
        }
        catch (Exception e) {
            logger.error("Unexpected error while fetching SNMP system info for {}: {}", (Object)ipAddress, (Object)e.getMessage(), (Object)e);
            systemInfoModel = new SystemInfoModel("Error: " + e.getMessage());
            return systemInfoModel;
        }
        finally {
            try {
                if (snmp != null) {
                    snmp.close();
                }
                if (transport != null) {
                    transport.close();
                }
            }
            catch (IOException e) {
                logger.error("Error closing SNMP resources: {}", (Object)e.getMessage());
            }
        }
    }

    public List<PDUSessionInfo> getPduSessionDetails() {
        List returnValue = this.pduSessionInfoRepository.findAllByOrderByExtensionNameAscExtensionNumberAsc();
        return returnValue;
    }

    public List<NFStatusDetailsModel> getNFStatusDetails() {
        ArrayList<NFStatusDetailsModel> returnValue = new ArrayList<NFStatusDetailsModel>();
        logger.info("Getting NF status details from local NF Container Service");
        if (StringUtils.hasText((String)Constants.REMOTE_NFS_SERVER)) {
            logger.info("Fetching NF status details from remote NF Container Service at {}", (Object)Constants.REMOTE_NFS_SERVER);
            return HttpUtils.getRemoteNFServices((String)Constants.REMOTE_NFS_SERVER);
        }
        try {
            List containers = (List)this.nfContainerService.getNFContainersStatus().getData();
            if (containers != null) {
                containers.forEach(container -> {
                    NFStatusDetailsModel nfStatus = new NFStatusDetailsModel();
                    nfStatus.setNFName(container.getContainerName());
                    nfStatus.setNf_status(container.getHealthStatus());
                    nfStatus.setUpTime(container.getUptime());
                    returnValue.add(nfStatus);
                });
            }
        }
        catch (Exception e) {
            logger.error("Error getting NF status details: {}", (Object)e.getMessage(), (Object)e);
        }
        return returnValue;
    }

    public List<MecStatusDetailsModel> getMecStatusDetails() {
        ArrayList<MecStatusDetailsModel> returnValue = new ArrayList<MecStatusDetailsModel>();
        this.scadaAssetRepository.getMECStatus().forEach(data -> {
            MecStatusDetailsModel mecStatus = new MecStatusDetailsModel();
            SystemInfoModel sysInfo = this.getSystemInfoViaSNMP(data.getIpAddress());
            mecStatus.setNodeName(data.getNodeName());
            mecStatus.setNodeIp(data.getIpAddress());
            mecStatus.setMecStatus(data.getStatus() != false ? "UP" : "DOWN");
            mecStatus.setUpTime(sysInfo.getUptime());
            mecStatus.setLoadAverageOneMinute(sysInfo.getLoadAverage1min());
            mecStatus.setLoadAverageFiveMinute(sysInfo.getLoadAverage5min());
            mecStatus.setLoadAverageFifteenMinute(sysInfo.getLoadAverage15min());
            mecStatus.setCpuUser(sysInfo.getCpuUser());
            mecStatus.setCpuSystem(sysInfo.getCpuSystem());
            mecStatus.setCpuIdle(sysInfo.getCpuIdle());
            mecStatus.setCpuUtilization(sysInfo.getCpuUtilization());
            returnValue.add(mecStatus);
        });
        return returnValue;
    }
}

