/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.model.BillingPeer;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class Bootstrap {
    private static final Logger logger = LogManager.getLogger(Bootstrap.class);

    private Bootstrap() {
    }

    public static void checkTelemetryDatabase() {
        DriverManagerDataSource dbTelemetry = new DriverManagerDataSource();
        dbTelemetry.setDriverClassName("org.postgresql.Driver");
        dbTelemetry.setUrl("jdbc:postgresql://127.0.0.1:5432/postgres");
        dbTelemetry.setUsername("postgres");
        dbTelemetry.setPassword("");
        try {
            Integer trunkgatewayCount;
            JdbcTemplate jdbcConnection = new JdbcTemplate((DataSource)dbTelemetry);
            Integer telemetryCount = (Integer)jdbcConnection.queryForObject("SELECT count(*) as cnt FROM pg_database WHERE datname = 'telemetry'", Integer.class);
            if (telemetryCount == null || telemetryCount == 0) {
                jdbcConnection.update("CREATE DATABASE telemetry");
            }
            if ((trunkgatewayCount = (Integer)jdbcConnection.queryForObject("SELECT count(*) as cnt FROM pg_database WHERE datname = 'trunkgateway'", Integer.class)) == null || trunkgatewayCount == 0) {
                jdbcConnection.update("CREATE DATABASE trunkgateway");
            }
        }
        catch (Exception e) {
            logger.error("Error while checking/creating telemetry and trunkgateway databases: ", (Throwable)e);
        }
    }

    public static void createCoralNMSSchema(ApplicationContext context, String subFolder) {
        DriverManagerDataSource dbTelemetry = new DriverManagerDataSource();
        dbTelemetry.setDriverClassName("org.postgresql.Driver");
        dbTelemetry.setUrl("jdbc:postgresql://127.0.0.1:5432/telemetry");
        dbTelemetry.setUsername("postgres");
        dbTelemetry.setPassword("");
        JdbcTemplate jdbcConnection = new JdbcTemplate((DataSource)dbTelemetry);
        Integer count = (Integer)jdbcConnection.queryForObject("SELECT count(*) FROM information_schema.schemata WHERE schema_name = 'coralnms'", Integer.class);
        try {
            jdbcConnection.update("create EXTENSION IF NOT EXISTS \"postgis\"");
        }
        catch (Exception e) {
            logger.error("PostGIS extension could not be created. Please check your PostGIS installation.", (Throwable)e);
        }
        try {
            jdbcConnection.update("create EXTENSION IF NOT EXISTS \"pgcrypto\"");
        }
        catch (Exception e) {
            logger.error("pgcrypto extension could not be created. Please check your PostgreSQL installation.", (Throwable)e);
        }
        if (count == null || count == 0) {
            jdbcConnection.update("CREATE SCHEMA coralnms");
        }
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resolver.getResources("classpath:schema/telemetry/" + subFolder + "/*.sql");
            Arrays.sort(resources, Comparator.comparing(Resource::getFilename));
            for (Resource resource : resources) {
                logger.info("Processing file: telemetry/{}/{}", (Object)subFolder, (Object)resource.getFilename());
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream()));){
                    String sqlScript = reader.lines().filter(line -> !line.trim().startsWith("--")).collect(Collectors.joining("\n"));
                    if (sqlScript.trim().isEmpty()) continue;
                    jdbcConnection.execute(sqlScript);
                    logger.info("Executed: {}", (Object)resource.getFilename());
                }
                catch (Exception e) {
                    logger.error("Error at file: telemetry /{}/{}", (Object)subFolder, (Object)resource.getFilename());
                    logger.error("Error while executing telemetry schema scripts: ", (Throwable)e);
                    if (context != null) {
                        SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> -1});
                    }
                    System.exit(-1);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while executing telemetry schema scripts: ", (Throwable)e);
        }
    }

    public static void createSwitchSchemas(ApplicationContext context, String subFolder) {
        DriverManagerDataSource dsSwitch = new DriverManagerDataSource();
        dsSwitch.setDriverClassName("org.postgresql.Driver");
        dsSwitch.setUrl("jdbc:postgresql://127.0.0.1:5432/switch");
        dsSwitch.setUsername("postgres");
        dsSwitch.setPassword("");
        JdbcTemplate jdbcConnection = new JdbcTemplate((DataSource)dsSwitch);
        if (subFolder.equalsIgnoreCase("tables")) {
            Integer columnExists;
            Integer uc;
            Integer pbx;
            Bootstrap.insertMCommandsFromJson((JdbcTemplate)jdbcConnection);
            Integer billing = (Integer)jdbcConnection.queryForObject("SELECT count(*) FROM information_schema.schemata WHERE schema_name = 'billing'", Integer.class);
            if (billing == null || billing == 0) {
                jdbcConnection.update("CREATE SCHEMA billing");
            }
            if ((Constants.ACTIVEMQ_IP_ADDRESS = (String)jdbcConnection.queryForObject("select coalesce(max(nodeip),'127.0.0.1') from pbx.m_nodeconfiguration where nodename = ?", String.class, new Object[]{Constants.hostName})) == null || Constants.ACTIVEMQ_IP_ADDRESS.isEmpty()) {
                Constants.ACTIVEMQ_IP_ADDRESS = "127.0.0.1";
            }
            if ((Constants.BILLING_CACHE_DAYS = (Integer)jdbcConnection.queryForObject("select coalesce(max(realtimedatadays_billing), 90) from archiving.m_archivingschedule", Integer.class)) == null || Constants.BILLING_CACHE_DAYS <= 0) {
                Constants.BILLING_CACHE_DAYS = 90;
            }
            Constants.BILLING_PEERS = Bootstrap.getBillingPeersByNodeName((JdbcTemplate)jdbcConnection);
            Integer complaint = (Integer)jdbcConnection.queryForObject("SELECT count(*) FROM information_schema.schemata WHERE schema_name = 'complaint'", Integer.class);
            if (complaint == null || complaint == 0) {
                jdbcConnection.update("CREATE SCHEMA complaint");
            }
            if ((pbx = (Integer)jdbcConnection.queryForObject("SELECT count(*) FROM information_schema.schemata WHERE schema_name = 'pbx'", Integer.class)) == null || pbx == 0) {
                jdbcConnection.update("CREATE SCHEMA pbx");
            }
            if ((uc = (Integer)jdbcConnection.queryForObject("SELECT count(*) FROM information_schema.schemata WHERE schema_name = 'uc'", Integer.class)) == null || uc == 0) {
                jdbcConnection.update("CREATE SCHEMA uc");
            }
            if ((columnExists = (Integer)jdbcConnection.queryForObject("SELECT count(*) FROM information_schema.columns WHERE table_schema = 'pbx' AND table_name = 'm_featurecode' AND column_name = 'code'", Integer.class)) != null && columnExists > 0) {
                jdbcConnection.execute("ALTER TABLE pbx.m_featurecode DROP COLUMN code");
            }
        }
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resolver.getResources("classpath:schema/switch/" + subFolder + "/*.sql");
            Arrays.sort(resources, Comparator.comparing(Resource::getFilename));
            for (Resource resource : resources) {
                logger.info("Processing file: switch/{}/{}", (Object)subFolder, (Object)resource.getFilename());
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream()));){
                    String sqlScript = reader.lines().filter(line -> !line.trim().startsWith("--")).collect(Collectors.joining("\n"));
                    if (sqlScript.trim().isEmpty()) continue;
                    jdbcConnection.execute(sqlScript);
                    logger.info("Executed: {}", (Object)resource.getFilename());
                }
                catch (Exception e) {
                    logger.error("Error at file: switch/{}/{}", (Object)subFolder, (Object)resource.getFilename());
                    logger.error("Error while executing switch schema scripts: ", (Throwable)e);
                    if (context != null) {
                        SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> -1});
                    }
                    System.exit(-1);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while executing switch schema scripts: ", (Throwable)e);
        }
    }

    public static List<BillingPeer> getBillingPeersByNodeName(JdbcTemplate jdbcConnection) {
        String sql = "select nodeip, nodename from pbx.m_nodeconfiguration where isbillingenabled = 1 and nodename <> ?";
        return jdbcConnection.query(sql, (rs, rowNum) -> {
            BillingPeer peer = new BillingPeer();
            peer.setNodeIP(rs.getString("nodeip"));
            peer.setNodeName(rs.getString("nodename"));
            return peer;
        }, new Object[]{Constants.hostName});
    }

    public static void createCoralAppsSchemas(ApplicationContext context, String subFolder) {
        DriverManagerDataSource dsCoralApps = new DriverManagerDataSource();
        dsCoralApps.setDriverClassName("org.postgresql.Driver");
        dsCoralApps.setUrl("jdbc:postgresql://127.0.0.1:5432/coralapps");
        dsCoralApps.setUsername("postgres");
        dsCoralApps.setPassword("");
        JdbcTemplate jdbcConnection = new JdbcTemplate((DataSource)dsCoralApps);
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resolver.getResources("classpath:schema/coralapps/" + subFolder + "/*.sql");
            Arrays.sort(resources, Comparator.comparing(Resource::getFilename));
            for (Resource resource : resources) {
                logger.info("Processing file: coralapps/{}/{}", (Object)subFolder, (Object)resource.getFilename());
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream()));){
                    String sqlScript = reader.lines().filter(line -> !line.trim().startsWith("--")).collect(Collectors.joining("\n"));
                    if (sqlScript.trim().isEmpty()) continue;
                    jdbcConnection.execute(sqlScript);
                    logger.info("Executed: {}", (Object)resource.getFilename());
                }
                catch (Exception e) {
                    logger.error("Error at file: coralapps/{}/{}", (Object)subFolder, (Object)resource.getFilename());
                    logger.error("Error while executing coralapps schema scripts: ", (Throwable)e);
                    if (context != null) {
                        SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> -1});
                    }
                    System.exit(-1);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while executing coralapps schema scripts: ", (Throwable)e);
        }
    }

    public static void validateAndInstallPostGIS() {
        String logFilePath = "/var/log/postgis/postgisinstall.log";
        File file = new File(logFilePath);
        if (!file.exists()) {
            logger.error("PostGIS log file does not exist: " + logFilePath);
            return;
        }
        try {
            String result = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8).trim();
            if ("false".equalsIgnoreCase(result)) {
                if (Bootstrap.isPostGISInstalled()) {
                    logger.info("PostGIS is already installed. No action needed.");
                } else {
                    logger.info("PostGIS not installed. Installing now...");
                    Bootstrap.installPostGIS();
                }
            } else if ("true".equalsIgnoreCase(result)) {
                logger.info("PostGIS is already installed. Skip installation.");
            } else {
                logger.error("PostGIS library files not found. Please upgrade the system with PostGIS support.");
            }
        }
        catch (IOException e) {
            logger.error("Error reading PostGIS log file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static boolean isPostGISInstalled() {
        try {
            DriverManagerDataSource ds = new DriverManagerDataSource();
            ds.setDriverClassName("org.postgresql.Driver");
            ds.setUrl("jdbc:postgresql://127.0.0.1:5432/telemetry");
            ds.setUsername("postgres");
            ds.setPassword("");
            JdbcTemplate jdbc = new JdbcTemplate((DataSource)ds);
            String version = (String)jdbc.queryForObject("SELECT PostGIS_full_version();", String.class);
            return version != null && !version.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void installPostGIS() {
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("bash", "-c", "dpkg -i /usr/share/coraltele/postgis/*.deb");
            pb.redirectErrorStream(true);
            Process process = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                logger.info("[PostGIS Install] " + line);
            }
            int code = process.waitFor();
            if (code == 0) {
                String checkLine;
                logger.info("PostGIS installed successfully.");
                logger.info("Running checkpostgis.sh script...");
                ProcessBuilder checkPB = new ProcessBuilder("bash", "-c", "/usr/share/coraltele/postgis/checkpostgis.sh");
                checkPB.redirectErrorStream(true);
                Process checkProcess = checkPB.start();
                BufferedReader checkReader = new BufferedReader(new InputStreamReader(checkProcess.getInputStream()));
                while ((checkLine = checkReader.readLine()) != null) {
                    logger.info("[checkpostgis.sh] " + checkLine);
                }
                int checkExit = checkProcess.waitFor();
                if (checkExit == 0) {
                    logger.info("checkpostgis.sh executed successfully.");
                } else {
                    logger.error("checkpostgis.sh failed with exit code: " + checkExit);
                }
            } else {
                logger.error("PostGIS installation failed with exit code: " + code);
            }
        }
        catch (Exception e) {
            logger.error("Error while installing PostGIS: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void deployFiles() {
        try {
            Resource[] resources;
            File destDir = new File("/etc/coraltele");
            String resourceBasePath = "local-files";
            logger.info("Deploying local files to {}", (Object)destDir.getAbsolutePath());
            if (!destDir.exists()) {
                destDir.mkdirs();
            }
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            for (Resource resource : resources = resolver.getResources("classpath*:" + resourceBasePath + "/**")) {
                File targetFile;
                File parentDir;
                String decodedPath;
                int baseIndex;
                if (!resource.exists() || !resource.isReadable() || resource.getFilename().endsWith("/") || (baseIndex = (decodedPath = URLDecoder.decode(resource.getURL().getPath(), "UTF-8")).indexOf(resourceBasePath)) < 0) continue;
                String relativePath = decodedPath.substring(baseIndex + resourceBasePath.length());
                if (relativePath.startsWith("/") || relativePath.startsWith("\\")) {
                    relativePath = relativePath.substring(1);
                }
                if (!(parentDir = (targetFile = new File(destDir, relativePath)).getParentFile()).exists()) {
                    parentDir.mkdirs();
                }
                logger.info("Deploying file: {} to {}", (Object)relativePath, (Object)targetFile.getAbsolutePath());
                try (InputStream in = resource.getInputStream();){
                    Files.copy(in, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            logger.info("All files deployed successfully.");
        }
        catch (IOException e) {
            logger.error("Error while deploying files: ", (Throwable)e);
        }
    }

    private static void insertMCommandsFromJson(JdbcTemplate jdbcConnection) {
        try {
            ClassPathResource resource = new ClassPathResource("default-data/m_commands.json");
            ObjectMapper objectMapper = new ObjectMapper();
            List commands = (List)objectMapper.readValue(resource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            jdbcConnection.execute("SELECT setval('pbx.m_commands_id_seq', COALESCE((SELECT MAX(id) FROM pbx.m_commands), 0) + 1, false)");
            String checkSql = "SELECT COUNT(*) FROM pbx.m_commands WHERE COALESCE(basecommand, '') = COALESCE(?, '') AND COALESCE(crudoption, '') = COALESCE(?, '') AND COALESCE(subcommand, '') = COALESCE(?, '') AND COALESCE(option1, '') = COALESCE(?, '') AND COALESCE(option2, '') = COALESCE(?, '') AND COALESCE(option3, '') = COALESCE(?, '') AND COALESCE(option4, '') = COALESCE(?, '') AND COALESCE(option5, '') = COALESCE(?, '')";
            String insertSql = "INSERT INTO pbx.m_commands (basecommand, crudoption, subcommand, option1, option2, option3, option4, option5) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            int insertedCount = 0;
            int skippedCount = 0;
            for (Map command : commands) {
                String option5;
                String option4;
                String option3;
                String option2;
                String option1;
                String subcommand;
                String crudoption;
                String basecommand = (String)command.get("basecommand");
                Integer count = (Integer)jdbcConnection.queryForObject(checkSql, Integer.class, new Object[]{basecommand, crudoption = (String)command.get("crudoption"), subcommand = (String)command.get("subcommand"), option1 = (String)command.get("option1"), option2 = (String)command.get("option2"), option3 = (String)command.get("option3"), option4 = (String)command.get("option4"), option5 = (String)command.get("option5")});
                if (count == null || count == 0) {
                    jdbcConnection.update(insertSql, new Object[]{basecommand, crudoption, subcommand, option1, option2, option3, option4, option5});
                    ++insertedCount;
                    continue;
                }
                ++skippedCount;
            }
            logger.info("m_commands: Inserted {} records, skipped {} existing records", (Object)insertedCount, (Object)skippedCount);
        }
        catch (Exception e) {
            logger.error("Error while inserting m_commands from JSON: ", (Throwable)e);
        }
    }
}

