/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.db.billing.repository;

import com.coraltele.telemetry.db.billing.entity.UserStatus;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface UserStatusRepository
extends CrudRepository<UserStatus, Integer> {
    @Query(value="SELECT * FROM t_userstatus WHERE COALESCE(isdatasynced, 0) = 0 ORDER BY id LIMIT 100", nativeQuery=true)
    public List<UserStatus> findByIsDataSynced();

    @Query(value="SELECT * FROM t_userstatus WHERE COALESCE(isdatasynced, 0) = 0 AND callcenter_version = 'O' ORDER BY id LIMIT 100", nativeQuery=true)
    public List<UserStatus> findByIsDataSyncedForO();

    @Query(value="SELECT * FROM t_userstatus WHERE COALESCE(isdatasynced, 0) = 0 AND (callcenter_version = 'N' OR callcenter_version IS NULL) ORDER BY id LIMIT 100", nativeQuery=true)
    public List<UserStatus> findByIsDataSyncedForNOrNull();

    @Query(value="SELECT * FROM t_userstatus WHERE username = ?1 AND curr_timeepoch >= ?2 AND curr_timeepoch < ?2 + 86400 ORDER BY curr_timeepoch DESC LIMIT 1", nativeQuery=true)
    public List<UserStatus> findByUsernameAndDate(String var1, Long var2);

    @Query(value="SELECT u FROM UserStatus u WHERE u.username = :username AND u.currTime BETWEEN :startOfDay AND :endOfDay")
    public Optional<List<UserStatus>> findByUsernameAndCurrTimeBetween(@Param(value="username") String var1, @Param(value="startOfDay") LocalDateTime var2, @Param(value="endOfDay") LocalDateTime var3);
}

