/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.condition.EnableFreeSwitchEslService;
import com.coraltele.telemetry.helper.FreeSwitchEventListener;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.freeswitch.esl.client.IEslEventListener;
import org.freeswitch.esl.client.inbound.Client;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableFreeSwitchEslService.class})
public class FreeSwitchEslService {
    private static final Logger logger = LogManager.getLogger(FreeSwitchEslService.class);
    private final Client client = new Client();
    @Autowired
    private FreeSwitchEventListener freeSwitchEventListener;

    @PostConstruct
    public void connectToFreeSwitch() {
        try {
            this.client.connect("127.0.0.1", 8021, "ClueCon", 10);
            this.client.setEventSubscriptions("plain", "ALL");
            this.client.addEventListener((IEslEventListener)this.freeSwitchEventListener);
            logger.info("FreeSWITCH ESL connection established and listener registered.");
        }
        catch (Exception e) {
            logger.error("Error While Listening ESL Events: {} {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void sendCommand(String command) {
        this.client.sendSyncApiCommand(command, "");
    }
}

