/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.user.service;

import com.coraltele.telemetry.bootstrap.JwtUserDetailConfiguration;
import com.coraltele.telemetry.db.users.main.entity.User;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.DateFormatUtility;
import com.coraltele.telemetry.helper.JwtUtil;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.helper.ReturnField;
import com.coraltele.telemetry.model.UserInfo;
import com.coraltele.telemetry.service.user.model.AuthenticationRequestModel;
import com.coraltele.telemetry.service.user.model.AuthenticationRequestResponseModel;
import com.coraltele.telemetry.service.user.model.ChangePasswordModel;
import com.coraltele.telemetry.service.user.service.UserRoleMenuService;
import com.coraltele.telemetry.service.user.service.UserService;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserAuthenticationService {
    private static final Logger logger = LogManager.getLogger(UserAuthenticationService.class);
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private PasswordEncoder bcryptEncoder;
    @Autowired
    private JwtUserDetailConfiguration jwtUserDetailConfiguration;
    @Autowired
    private JwtUtil jwtUtil;
    @Autowired
    private DateFormatUtility dateFormatUtility;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRoleMenuService userRoleMenuService;

    public RequestResponse login(AuthenticationRequestModel jwtRequest) throws Exception {
        RequestResponse returnValue = new RequestResponse();
        Optional userInfo = this.userService.getUserByName(jwtRequest.getUsername());
        if (userInfo.isPresent()) {
            int enabled = ((User)userInfo.get()).getEnabled();
            boolean accountExpired = ((User)userInfo.get()).isAccountExpired();
            boolean credentialExpired = ((User)userInfo.get()).isCredentialsExpired();
            boolean accountLocked = ((User)userInfo.get()).isAccountLocked();
            int failedAttempt = ((User)userInfo.get()).getFailedAttempts();
            LocalDate lastLogon = ((User)userInfo.get()).getLastLogon();
            if (lastLogon == null) {
                lastLogon = LocalDate.now();
            }
            LocalDate lastPasswordChange = ((User)userInfo.get()).getLastPasswordChange();
            long maxDaysForLastLogon = this.dateFormatUtility.getDaysDifference(lastLogon, LocalDate.now());
            long maxDaysForLastPasswordChange = 0L;
            String sipPassword = "1234";
            if (lastPasswordChange != null) {
                this.dateFormatUtility.getDaysDifference(lastPasswordChange, LocalDate.now());
            }
            if (failedAttempt < Constants.MAX_FAILED_ATTEMPTS) {
                try {
                    this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)jwtRequest.getUsername(), (Object)jwtRequest.getPassword()));
                    UserInfo userDetails = this.jwtUserDetailConfiguration.loadUserByUsername(jwtRequest.getUsername());
                    if (enabled != 1 && returnValue.getStatus() == 0) {
                        returnValue.setIssue(Constants.NodeStatus.ACCOUNT_NOT_ENABLED);
                        returnValue.setMessage("Login Failed");
                        returnValue.setMessageDetail("User needs to enable the account");
                    }
                    if (accountExpired && returnValue.getStatus() == 0) {
                        returnValue.setIssue(Constants.NodeStatus.ACCOUNT_EXPIRED);
                        returnValue.setMessage("Login Failed");
                        returnValue.setMessageDetail(" Your account has been expired ");
                    }
                    if (credentialExpired && returnValue.getStatus() == 0) {
                        returnValue.setIssue(Constants.NodeStatus.CREDENTIAL_EXPIRED);
                        returnValue.setMessage("Login Failed");
                        returnValue.setMessageDetail("User need to change their password ");
                    }
                    if (accountLocked && returnValue.getStatus() == 0) {
                        returnValue.setIssue(Constants.NodeStatus.ACCOUNT_BLOCKED);
                        returnValue.setMessage("Login Failed");
                        returnValue.setMessageDetail("Your account has been locked");
                    }
                    if (maxDaysForLastLogon >= (long)Constants.MAX_LOGGED_ON_DAYS.intValue() && returnValue.getStatus() == 0) {
                        returnValue.setIssue(Constants.NodeStatus.TOO_MANY_DAYS);
                        returnValue.setMessage("Login Failed");
                        returnValue.setMessageDetail("User need to change the password ");
                    }
                    if (maxDaysForLastPasswordChange >= (long)Constants.MAX_CHANGE_PASSWORD_DAYS.intValue() && returnValue.getStatus() == 0) {
                        returnValue.setIssue(Constants.NodeStatus.TOO_MANY_DAYS);
                        returnValue.setMessage("Login Failed");
                        returnValue.setMessageDetail("User need to change the password ");
                    }
                    if (failedAttempt >= Constants.MAX_FAILED_ATTEMPTS && returnValue.getStatus() == 0) {
                        returnValue.setIssue(Constants.NodeStatus.TOO_MANY_FAILED_ATTEMPTS);
                        returnValue.setMessage("Login Failed, Too many failed attempts");
                        returnValue.setMessageDetail("User not allowed to Logged In again");
                    }
                    List roles = this.userRoleMenuService.rolesOfParticularUser(jwtRequest.getUsername());
                    List groups = this.userRoleMenuService.menusForRolesOfParticularUser(jwtRequest.getUsername());
                    if (returnValue.getStatus() == 0) {
                        String token = this.jwtUtil.generateToken((UserDetails)userDetails);
                        ((User)userInfo.get()).setFailedAttempts(0);
                        this.userRepository.save(userInfo.get());
                        returnValue.setMessage(" Authenticated ");
                        returnValue.setMessageDetail("User has been successfully authenticated");
                        returnValue.setData((Object)new AuthenticationRequestResponseModel(token, jwtRequest.getUsername(), sipPassword, roles, groups));
                        logger.info(returnValue.getMessage());
                    }
                }
                catch (BadCredentialsException | UsernameNotFoundException e) {
                    ((User)userInfo.get()).setFailedAttempts(++failedAttempt);
                    this.userRepository.save(userInfo.get());
                    returnValue.setIssue(Constants.NodeStatus.BAD_CREDENTIAL);
                    returnValue.setMessage("Login Failed");
                    returnValue.setMessageDetail("Wrong username or password ");
                    returnValue.setData((Object)("total " + String.valueOf(Constants.MAX_FAILED_ATTEMPTS - failedAttempt) + " attempts remains"));
                    logger.info(returnValue.getMessage());
                }
            } else {
                returnValue.setIssue(Constants.NodeStatus.ACCOUNT_BLOCKED);
                returnValue.setMessage("Login Failed");
                returnValue.setMessageDetail("Your account has been locked, you have tried maximum attempts");
                logger.info(returnValue.getMessage());
            }
        } else {
            returnValue.setIssue(Constants.NodeStatus.BAD_CREDENTIAL);
            returnValue.setMessage("Login Failed ");
            returnValue.setMessageDetail("Wrong username or password ");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updatePassword(ChangePasswordModel data) {
        RequestResponse returnValue;
        block7: {
            returnValue = new RequestResponse();
            Optional user = this.userRepository.findByUsername(data.getUsername());
            if (user.isPresent() && this.bcryptEncoder.matches((CharSequence)data.getOldPassword(), ((User)user.get()).getPassword())) {
                try {
                    if (!this.bcryptEncoder.matches((CharSequence)data.getNewPassword(), ((User)user.get()).getPassword())) {
                        if (data.getNewPassword().equals(data.getConfirmPassword())) {
                            ((User)user.get()).setPassword(this.bcryptEncoder.encode((CharSequence)data.getNewPassword()));
                            ((User)user.get()).setLastPasswordChange(LocalDate.now());
                            this.userRepository.save(user.get());
                            ReturnField field = new ReturnField();
                            field.setId(((User)user.get()).getId());
                            field.setDescription(((User)user.get()).getUsername());
                            returnValue.setData((Object)field);
                            returnValue.setStatus(0);
                            returnValue.setMessage("Successfully Changed Your password");
                            logger.info(returnValue.getMessage());
                        } else {
                            returnValue.setStatus(-1);
                            returnValue.setMessage("Unable to change the password");
                            returnValue.setMessageDetail("newPassword & confirmPassword does not match");
                            logger.info(returnValue.getMessage());
                        }
                        break block7;
                    }
                    returnValue.setStatus(-1);
                    returnValue.setMessage("Unable to change your password");
                    returnValue.setMessageDetail("please enter the different newPassword");
                    logger.info(returnValue.getMessage());
                }
                catch (Exception ex) {
                    returnValue.setStatus(-1);
                    returnValue.setMessage("Unable to change password");
                    returnValue.setMessageDetail("Contact with your administrator");
                    logger.info(returnValue.getMessage());
                }
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to change password");
                returnValue.setMessageDetail("wrong username or oldPassword");
                logger.info(returnValue.getMessage());
            }
        }
        return returnValue;
    }
}

