/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.messageApi.service;

import com.coraltele.telemetry.db.telemetry.main.entity.Message;
import com.coraltele.telemetry.db.telemetry.main.repository.MessageRepository;
import com.coraltele.telemetry.db.users.main.entity.User;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.helper.Messaging;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.main.messageApi.model.MessageModel;
import com.coraltele.telemetry.service.main.messageApi.model.MessageSearchModel;
import com.coraltele.telemetry.service.user.service.UserAuthenticationService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ChatService {
    @Autowired
    private MessageRepository msgRepo;
    @Autowired
    private UserRepository userRepo;
    private static final Logger logger = LogManager.getLogger(ChatService.class);

    public RequestResponse add(MessageModel data) {
        logger.debug("create new message : {} ==> {}", (Object)data.getSentTo(), (Object)data.getMessage());
        RequestResponse returnValue = new RequestResponse();
        UUID uuid = UUID.randomUUID();
        data.setUuid(uuid.toString());
        data.setCreatedOn(LocalDateTime.now());
        Messaging.getMessagingTemplate().convertAndSend((Object)String.format("/app/v2/messaging/topic/%s", data.isForHandler() ? "handler" : data.getSentTo()), (Object)data);
        try {
            Message message = new Message();
            message.setCreatedOn(data.getCreatedOn());
            message.setCreatedBy(data.getCreatedBy());
            message.setSentTo(data.getSentTo());
            message.setMessage(data.getMessage());
            message.setMessageType(data.getMessageType());
            message.setUuid(data.getUuid());
            message.setDisplayColor(data.getDisplayColor());
            this.msgRepo.save((Object)message);
            logger.info("Message saved : {}", (Object)returnValue.getMessage());
        }
        catch (Exception ex) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to register this message");
            returnValue.setMessage("Contact to administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)ex);
        }
        return returnValue;
    }

    public RequestResponse getAll() {
        logger.debug("Get device list");
        RequestResponse returnValue = new RequestResponse();
        ArrayList<MessageModel> addValue = new ArrayList<MessageModel>();
        List list = this.msgRepo.findAll();
        for (Message message : list) {
            MessageModel data = new MessageModel();
            data.setId(message.getId());
            data.setCreatedBy(message.getCreatedBy());
            data.setSentTo(message.getSentTo());
            data.setMessage(message.getMessage());
            data.setMessageType(message.getMessageType());
            data.setUuid(message.getUuid());
            data.setCreatedOn(message.getCreatedOn());
            addValue.add(data);
        }
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("your requested data have given below");
        returnValue.setData(addValue);
        return returnValue;
    }

    public RequestResponse getById(int id) {
        logger.debug("Get device list");
        RequestResponse returnValue = new RequestResponse();
        Optional message = this.msgRepo.findById(id);
        if (message.isPresent()) {
            MessageModel data = new MessageModel();
            data.setId(((Message)message.get()).getId());
            data.setCreatedBy(((Message)message.get()).getCreatedBy());
            data.setSentTo(((Message)message.get()).getSentTo());
            data.setMessage(((Message)message.get()).getMessage());
            data.setMessageType(((Message)message.get()).getMessageType());
            data.setUuid(((Message)message.get()).getUuid());
            data.setCreatedOn(((Message)message.get()).getCreatedOn());
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("your requested data has given below");
            returnValue.setData((Object)data);
            logger.info(returnValue.getMessage());
        } else {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("Record doesn't Not found");
            logger.error(returnValue.getMessageDetail());
        }
        return returnValue;
    }

    public RequestResponse getByCallSign(String UserId) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<MessageModel> addValue = new ArrayList<MessageModel>();
        Optional user = this.userRepo.findByUsername(UserId);
        List callsign = this.msgRepo.findByCreatedBy(UserId);
        if (user.isPresent()) {
            if (!callsign.isEmpty()) {
                for (Message message : callsign) {
                    MessageModel data = new MessageModel();
                    data.setId(message.getId());
                    data.setCreatedBy(message.getCreatedBy());
                    data.setSentTo(message.getSentTo());
                    data.setMessage(message.getMessage());
                    data.setMessageType(message.getMessageType());
                    data.setUuid(message.getUuid());
                    data.setCreatedOn(message.getCreatedOn());
                    addValue.add(data);
                }
                returnValue.setStatus(0);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("your requested data has given below");
                returnValue.setData(addValue);
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail(String.format(" message not created by user %s ", UserId));
            }
        } else {
            returnValue.setStatus(-1);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("user does not exist you are looking for");
        }
        return returnValue;
    }

    public RequestResponse getMessageByTime(String sender, String receiver) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<MessageModel> addValue = new ArrayList<MessageModel>();
        List list = this.msgRepo.findByCreatedByOrSentTo(sender, receiver, Sort.by((String[])new String[]{"createdOn"}).ascending());
        for (Message message : list) {
            MessageModel data = new MessageModel();
            data.setId(message.getId());
            data.setCreatedBy(message.getCreatedBy());
            data.setSentTo(message.getSentTo());
            data.setMessage(message.getMessage());
            data.setMessageType(message.getMessageType());
            data.setUuid(message.getUuid());
            data.setCreatedOn(message.getCreatedOn());
            addValue.add(data);
        }
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("your requested data has given below");
        returnValue.setData(addValue);
        return returnValue;
    }

    public RequestResponse messagesOfUser(String username) {
        RequestResponse returnValue = new RequestResponse();
        Optional user = this.userRepo.findByUsername(username);
        ArrayList<MessageModel> returnData = new ArrayList<MessageModel>();
        if (user.isPresent()) {
            List list = this.msgRepo.findAll();
            for (Message message : list) {
                MessageModel data = new MessageModel();
                data.setId(message.getId());
                data.setCreatedBy(message.getCreatedBy());
                data.setSentTo(message.getSentTo());
                data.setMessage(message.getMessage());
                data.setMessageType(message.getMessageType());
                data.setUuid(message.getUuid());
                data.setCreatedOn(message.getCreatedOn());
                returnData.add(data);
            }
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setData(returnData);
        } else {
            returnValue.setStatus(-1);
            returnValue.setMessage("username not found");
            returnValue.setMessageDetail("Records Not found you are looking for");
        }
        return returnValue;
    }

    public RequestResponse delete(int id) {
        logger.debug("Delete message id {}", (Object)id);
        RequestResponse returnValue = new RequestResponse();
        Optional message = this.msgRepo.findById(id);
        if (message.isPresent()) {
            try {
                this.msgRepo.deleteById((Object)id);
                returnValue.setStatus(0);
                returnValue.setMessage("Message deleted");
                logger.info(returnValue.getMessage());
            }
            catch (Exception ex) {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to delete message");
                returnValue.setMessage("Contact with your administrator");
                logger.error(returnValue.getMessageDetail(), (Throwable)ex);
            }
        } else {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to delete record");
            returnValue.setMessageDetail("Record Not found");
            logger.error(returnValue.getMessageDetail());
        }
        return returnValue;
    }

    public List<MessageModel> MessageEntityToMessageModelConverter(List<Message> list) {
        ArrayList<MessageModel> addValue = new ArrayList<MessageModel>();
        for (Message message : list) {
            MessageModel data = new MessageModel();
            data.setId(message.getId());
            data.setCreatedBy(message.getCreatedBy());
            data.setSentTo(message.getSentTo());
            data.setMessage(message.getMessage());
            data.setMessageType(message.getMessageType());
            data.setUuid(message.getUuid());
            data.setCreatedOn(message.getCreatedOn());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse findByFilters(MessageSearchModel filterData) {
        RequestResponse returnValue = new RequestResponse();
        return returnValue;
    }

    public RequestResponse getUnReadMessages(UserAuthenticationService authentication) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<MessageModel> addValue = new ArrayList<MessageModel>();
        Optional user = this.userRepo.findByUsername("authentication.getName()");
        if (user.isPresent()) {
            List list = this.msgRepo.getUnreadMessages(((User)user.get()).getUsername().toLowerCase());
            for (Message message : list) {
                MessageModel data = new MessageModel();
                data.setId(message.getId());
                data.setCreatedBy(message.getCreatedBy());
                data.setSentTo(message.getSentTo());
                data.setMessage(message.getMessage());
                data.setMessageType(message.getMessageType());
                data.setUuid(message.getUuid());
                data.setCreatedOn(message.getCreatedOn());
                data.setDisplayColor(message.getDisplayColor());
                addValue.add(data);
            }
        }
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("your requested data has given below");
        returnValue.setData(addValue);
        return returnValue;
    }

    public RequestResponse markAsRead(UserAuthenticationService authentication) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<MessageModel> addValue = new ArrayList<MessageModel>();
        Optional user = this.userRepo.findByUsername("");
        if (user.isPresent()) {
            this.msgRepo.markMessageReadCreator(((User)user.get()).getUsername().toLowerCase());
            this.msgRepo.markMessageReadRecipient(((User)user.get()).getUsername().toLowerCase());
            List list = this.msgRepo.getUnreadMessages(((User)user.get()).getUsername().toLowerCase());
            for (Message message : list) {
                MessageModel data = new MessageModel();
                data.setId(message.getId());
                data.setCreatedBy(message.getCreatedBy());
                data.setSentTo(message.getSentTo());
                data.setMessage(message.getMessage());
                data.setMessageType(message.getMessageType());
                data.setUuid(message.getUuid());
                data.setCreatedOn(message.getCreatedOn());
                data.setDisplayColor(message.getDisplayColor());
                addValue.add(data);
            }
        }
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("your requested data has given below");
        returnValue.setData(addValue);
        return returnValue;
    }

    public RequestResponse getPageableList(int pageNumber, int pageSize) {
        logger.debug("Get Pageable list");
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        Page pages = this.msgRepo.findAll((Pageable)pageable);
        List list = pages.getContent();
        ArrayList<MessageModel> returnData = new ArrayList<MessageModel>();
        for (Message message : list) {
            MessageModel data = new MessageModel();
            data.setId(message.getId());
            data.setCreatedBy(message.getCreatedBy());
            data.setSentTo(message.getSentTo());
            data.setMessage(message.getMessage());
            data.setMessageType(message.getMessageType());
            data.setUuid(message.getUuid());
            data.setCreatedOn(message.getCreatedOn());
            returnData.add(data);
        }
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setData(returnData);
        return returnValue;
    }

    public RequestResponse deleteMultipleMessages(List<Integer> ids) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer id : ids) {
            Optional message = this.msgRepo.findById((Object)id);
            addValue.add(message.get());
        }
        this.msgRepo.deleteAll(addValue);
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("your requested data has been deleted");
        return returnValue;
    }

    public RequestResponse saveMessage(Message message) {
        RequestResponse returnValue = new RequestResponse();
        Message msg = new Message();
        msg.setCreatedBy(message.getCreatedBy());
        msg.setSentTo(message.getSentTo());
        msg.setMessage(message.getMessage());
        msg.setCreatedOn(LocalDateTime.now());
        this.msgRepo.save((Object)msg);
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("its a save data");
        return returnValue;
    }
}

