/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.ClassPathResource;

public class JsonUtils {
    private static final Logger logger = LogManager.getLogger(JsonUtils.class);

    public static <T> List<T> readListFromJson(String path, TypeReference<List<T>> typeReference) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            InputStream inputStream = new ClassPathResource(path).getInputStream();
            return (List)mapper.readValue(inputStream, typeReference);
        }
        catch (Exception e) {
            logger.error("Failed to read JSON from: {} {} {}", (Object)path, (Object)e.getMessage(), (Object)e);
            return Collections.emptyList();
        }
    }
}

