/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.component.service.DeviceManagerService;
import com.coraltele.telemetry.condition.EnableDeviceManagerGetToken;
import com.coraltele.telemetry.helper.Constants;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableDeviceManagerGetToken.class})
public class DeviceManagerGetToken {
    private static final Logger logger = LoggerFactory.getLogger(EnableDeviceManagerGetToken.class);
    @Autowired
    DeviceManagerService deviceManagerService;

    @PostConstruct
    public void deviceManagerGetToken() {
        logger.info("Device Manager get token Start process.");
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(() -> this.runACSLoginCall(), 0L, 5L, TimeUnit.HOURS);
    }

    private void runACSLoginCall() {
        if (!Constants.TR069_SERVER_IP.equals("")) {
            logger.info("Running device manager refresh token every 5 hours function name: ACSLoginCall()");
            this.deviceManagerService.ACSLoginCall();
        }
    }
}

