/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.Card;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.CardRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.MediaGateway;
import com.coraltele.telemetry.model.ICC4Card;
import com.coraltele.telemetry.model.ICC4Packet;
import com.coraltele.telemetry.model.discovery.ServiceStatus;
import com.coraltele.telemetry.service.coralnms.scada_assets.model.SCADAAssetModel;
import com.coraltele.telemetry.service.coralnms.scada_assets.service.SCADAAssetService;
import com.coraltele.telemetry.tasks.ICC4KeepAlive;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.xml.sax.SAXException;

public class ICC4Thread
implements DisposableBean,
Runnable {
    private static final Logger logger = LogManager.getLogger(ICC4Thread.class);
    private Thread thread;
    public volatile boolean isRunning = true;
    public String mediaGatewayIP;
    public Integer nodeId;
    private Integer port = 4747;
    private Integer keepAliveInterval = 170000;
    Timer timer;
    CardRepository cardRepository;
    SCADAAssetModel scadaAsset;
    SCADAAssetService scadaAssetService;

    public ICC4Thread(String mediaGatewayIP, Integer nodeId, SCADAAssetModel scadaAsset, String oid, String nodeName, CardRepository cardRepository, SCADAAssetService scadaAssetService) {
        logger.info("Starting Media gateway Thread for {} {}", (Object)mediaGatewayIP, (Object)nodeId);
        this.mediaGatewayIP = mediaGatewayIP;
        this.nodeId = nodeId;
        this.cardRepository = cardRepository;
        this.scadaAsset = scadaAsset;
        this.scadaAssetService = scadaAssetService;
        this.timer = new Timer();
        this.thread = new Thread((Runnable)this);
        this.thread.start();
    }

    @Override
    public void run() {
        while (this.isRunning) {
            logger.info("Obtaining Socket for {} {} {}", (Object)this.mediaGatewayIP, (Object)this.nodeId, (Object)this.port);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e1) {
                logger.error("While sleeping thread {} {}", (Object)this.mediaGatewayIP, (Object)this.nodeId, (Object)e1);
            }
            try {
                Socket socket = new Socket(this.mediaGatewayIP, (int)this.port);
                Throwable throwable = null;
                try {
                    logger.info("Socket connection successful {} {} {}", (Object)this.mediaGatewayIP, (Object)this.nodeId, (Object)this.port);
                    this.timer.cancel();
                    this.timer = new Timer();
                    logger.info("Existing timer cancelled {} {}", (Object)this.mediaGatewayIP, (Object)this.nodeId);
                    InputStream input = socket.getInputStream();
                    ICC4KeepAlive keepAlive = new ICC4KeepAlive(socket.getOutputStream(), this.mediaGatewayIP);
                    this.timer.schedule((TimerTask)keepAlive, 1000L, (long)this.keepAliveInterval.intValue());
                    logger.info("New timer started {} {}", (Object)this.mediaGatewayIP, (Object)this.nodeId);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                    Throwable throwable2 = null;
                    try {
                        String line;
                        ArrayList<String> lines = new ArrayList<String>();
                        while ((line = reader.readLine()) != null) {
                            lines.add(line);
                            logger.info("Line received {} {} {}", (Object)this.mediaGatewayIP, (Object)this.nodeId, (Object)line);
                            if (!line.equals("</Sacd>")) continue;
                            try {
                                logger.info("Processing packet {} {}", (Object)this.mediaGatewayIP, (Object)this.nodeId);
                                ICC4Packet packet = MediaGateway.parseXML(lines, (String)this.mediaGatewayIP);
                                ObjectMapper objectMapper = new ObjectMapper();
                                String data = objectMapper.writeValueAsString((Object)packet);
                                logger.info("Processing packet {} {} {}", (Object)this.mediaGatewayIP, (Object)this.nodeId, (Object)data);
                                for (ICC4Card scadaPacket : packet.getCards()) {
                                    Card card;
                                    logger.info("Processing event for {} ", (Object)scadaPacket);
                                    Constants.NodeStatus cardStatus = Constants.NodeStatus.OK;
                                    cardStatus = scadaPacket.getState().equals("7") || scadaPacket.getState().equals("6") ? Constants.NodeStatus.OK : Constants.NodeStatus.ERROR;
                                    List cards = this.cardRepository.findByNodeIdAndSlot(this.nodeId, Integer.valueOf(Integer.parseInt(scadaPacket.getSlot())));
                                    if (!cards.isEmpty()) {
                                        card = (Card)cards.get(0);
                                        card.setStatus(scadaPacket.getStateName());
                                        card.setCardName(scadaPacket.getCardName());
                                        card.setStatus(scadaPacket.getStateName().substring(0, 1));
                                        card.setImageId(scadaPacket.getStateName().substring(0, 1));
                                        card.setCardStatus(scadaPacket.getStateName());
                                        card.setCardStatusUpdateOn(LocalDateTime.now());
                                        this.cardRepository.save((Object)card);
                                    } else {
                                        card = new Card();
                                        card.setCreatedOn(LocalDateTime.now());
                                        card.setNodeId(this.nodeId);
                                        card.setNodeIPAddress(this.mediaGatewayIP);
                                        card.setRack(Integer.valueOf(0));
                                        card.setRsuId(Integer.valueOf(0));
                                        card.setSlot(Integer.valueOf(Integer.parseInt(scadaPacket.getSlot())));
                                        card.setCardName(scadaPacket.getCardName());
                                        card.setStatus(scadaPacket.getStateName().substring(0, 1));
                                        card.setImageId(scadaPacket.getStateName().substring(0, 1));
                                        card.setCardStatus(scadaPacket.getStateName());
                                        card.setCardStatusUpdateOn(LocalDateTime.now());
                                        this.cardRepository.save((Object)card);
                                    }
                                    ServiceStatus serviceStatus = new ServiceStatus(this.scadaAsset.getId(), this.scadaAsset.getNodeName(), this.scadaAsset.getIpAddress(), this.scadaAsset.getCategory(), String.format("SLOT%02d", Integer.parseInt(scadaPacket.getSlot())), Boolean.valueOf(cardStatus == Constants.NodeStatus.OK), scadaPacket.getStateName(), Integer.valueOf(cardStatus == Constants.NodeStatus.OK ? 0 : 3), scadaPacket.getCardName(), Integer.valueOf(Integer.parseInt(scadaPacket.getSlot())), "", Boolean.valueOf(false), "");
                                    this.scadaAssetService.updateServiceStatus(serviceStatus);
                                }
                                lines.clear();
                            }
                            catch (ParserConfigurationException | SAXException e) {
                                logger.error("Error while processing XML packets {}", (Object)e.getMessage(), (Object)e);
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (socket == null) continue;
                    if (throwable != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    socket.close();
                }
            }
            catch (UnknownHostException ex) {
                logger.error("Error while receiving packet (1) {} {}", (Object)this.mediaGatewayIP, (Object)this.nodeId, (Object)ex);
            }
            catch (IOException ex) {
                logger.error("I/O Error while receiving packet (2) {} {}", (Object)this.mediaGatewayIP, (Object)this.nodeId, (Object)ex);
            }
        }
    }

    public void destroy() throws Exception {
        this.isRunning = false;
    }
}

