/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.db.billing.entity.UserStatus;
import com.coraltele.telemetry.db.billing.repository.UserStatusRepository;
import com.coraltele.telemetry.db.coralapps.entity.CoralAgentsState;
import com.coraltele.telemetry.db.coralapps.repository.CoralAgentsStateRepository;
import com.coraltele.telemetry.helper.DateFormatUtility;
import com.coraltele.telemetry.helper.GetAgentFullName;
import com.coraltele.telemetry.model.CDRSetAgentNameModel;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class CallCenterVersionControlThread
implements Runnable {
    private static final Logger logger = LogManager.getLogger(CallCenterVersionControlThread.class);
    private Boolean isRunning = true;
    private UserStatusRepository userStatusRepository;
    private CoralAgentsStateRepository coralAgentsStateRepository;
    private GetAgentFullName getAgentFullName;
    private DateFormatUtility dateFormatUtility;

    public CallCenterVersionControlThread(UserStatusRepository userStatusRepository, CoralAgentsStateRepository coralAgentsStateRepository, GetAgentFullName getAgentFullName, DateFormatUtility dateFormatUtility) {
        this.userStatusRepository = userStatusRepository;
        this.coralAgentsStateRepository = coralAgentsStateRepository;
        this.getAgentFullName = getAgentFullName;
        this.dateFormatUtility = dateFormatUtility;
    }

    private void setDataInUserStatus(CoralAgentsState coralAgentsState, String statusValue, Boolean usePrevDate) {
        try {
            UserStatus userStatus = new UserStatus();
            CDRSetAgentNameModel getAgentDetails = this.getAgentFullName.getAgentName(coralAgentsState.getName());
            userStatus.setUserFullName(getAgentDetails.getAgentName());
            if (StringUtils.hasText((String)getAgentDetails.getAgent())) {
                userStatus.setUsername(getAgentDetails.getAgent());
            } else {
                userStatus.setUsername(coralAgentsState.getName());
            }
            userStatus.setCallCenterVersion("O");
            if (Boolean.TRUE.equals(usePrevDate)) {
                userStatus.setCurrTime(coralAgentsState.getPreviousDateTime());
                userStatus.setPreviousTime(coralAgentsState.getPreviousDateTime());
                if (userStatus.getPreviousTime() != null) {
                    userStatus.setPreviousTimeEpoch(Long.valueOf(this.dateFormatUtility.toEpoch(userStatus.getPreviousTime())));
                    userStatus.setCurrentTimeEpoch(Long.valueOf(this.dateFormatUtility.toEpoch(userStatus.getCurrTime())));
                }
            } else {
                userStatus.setCurrTime(coralAgentsState.getCurrentDateTime());
                userStatus.setPreviousTime(coralAgentsState.getPreviousDateTime());
                Optional listOfUserStatus = this.userStatusRepository.findByUsernameAndCurrTimeBetween(userStatus.getUsername(), coralAgentsState.getCurrentDateTime().toLocalDate().atStartOfDay(), coralAgentsState.getCurrentDateTime().toLocalDate().atTime(LocalTime.MAX));
                if (listOfUserStatus.isPresent() && !((List)listOfUserStatus.get()).isEmpty()) {
                    LocalDateTime useTimeAsPreviousTime = ((UserStatus)((List)listOfUserStatus.get()).get(((List)listOfUserStatus.get()).size() - 1)).getCurrTime();
                    userStatus.setPreviousTime(useTimeAsPreviousTime);
                }
                if (userStatus.getCurrTime() != null) {
                    userStatus.setCurrentTimeEpoch(Long.valueOf(this.dateFormatUtility.toEpoch(userStatus.getCurrTime())));
                }
                if (userStatus.getPreviousTime() != null) {
                    userStatus.setPreviousTimeEpoch(Long.valueOf(this.dateFormatUtility.toEpoch(userStatus.getPreviousTime())));
                }
            }
            userStatus.setExtensionNumber(coralAgentsState.getName());
            if (coralAgentsState.getPreviousDateTime() != null) {
                userStatus.setPreviousTimeEpoch(Long.valueOf(this.dateFormatUtility.toEpoch(coralAgentsState.getPreviousDateTime())));
            } else {
                userStatus.setPreviousTimeEpoch(null);
            }
            userStatus.setShift(null);
            userStatus.setStatus(statusValue);
            userStatus.setShowinreport("Y");
            userStatus.setIsDataSynced(Integer.valueOf(0));
            if (StringUtils.hasText((String)coralAgentsState.getUuid())) {
                UUID uuid = UUID.fromString(coralAgentsState.getUuid());
                userStatus.setUuid(uuid);
            }
            this.userStatusRepository.save((Object)userStatus);
        }
        catch (Exception e) {
            logger.error("Error While Saving Data into UserStatus Table {} {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void run() {
        logger.info("Starting Thread for Call Center Version Control");
        try {
            while (Boolean.TRUE.equals(this.isRunning)) {
                List coralAgentStatusList = this.coralAgentsStateRepository.findByIsDataSynced();
                if (!coralAgentStatusList.isEmpty()) {
                    for (CoralAgentsState coralAgentsState : coralAgentStatusList) {
                        logger.info("Setting In User Status Data for {}", (Object)coralAgentsState.getUuid());
                        logger.debug("Process data Id : {}", (Object)coralAgentsState.getId());
                        if (coralAgentsState.getPreviousDateTime() == null) {
                            coralAgentsState.setPreviousDateTime(coralAgentsState.getCurrentDateTime());
                        }
                        if (!StringUtils.hasText((String)coralAgentsState.getPreviousState())) {
                            coralAgentsState.setPreviousState(coralAgentsState.getCurrentState());
                        }
                        if (coralAgentsState.getCurrentStatus().equalsIgnoreCase("Available") || coralAgentsState.getCurrentStatus().equalsIgnoreCase("Available (On Demand)") || coralAgentsState.getCurrentStatus().equalsIgnoreCase("On Break") || coralAgentsState.getCurrentStatus().equalsIgnoreCase("Logged Out") || coralAgentsState.getCurrentStatus().equalsIgnoreCase("Logged In") || coralAgentsState.getPreviousStatus().equalsIgnoreCase("Available for Manual") || coralAgentsState.getPreviousStatus().equalsIgnoreCase("Off-Hook")) {
                            Long prevStatusEpoch;
                            Long currentStatusEpoch = this.dateFormatUtility.getMidNightEpochFromDateTime(coralAgentsState.getCurrentDateTime());
                            if (currentStatusEpoch.equals(prevStatusEpoch = this.dateFormatUtility.getMidNightEpochFromDateTime(coralAgentsState.getPreviousDateTime()))) {
                                if (coralAgentsState.getCurrentStatus().equalsIgnoreCase("Available")) {
                                    if (coralAgentsState.getPreviousStatus().equalsIgnoreCase("Logged Out") && !coralAgentsState.getPreviousStatus().equalsIgnoreCase("Logged In")) {
                                        this.setDataInUserStatus(coralAgentsState, "Login", Boolean.valueOf(false));
                                        this.setDataInUserStatus(coralAgentsState, "Start Call", Boolean.valueOf(false));
                                    }
                                    if (coralAgentsState.getPreviousStatus().equalsIgnoreCase("Logged In")) {
                                        this.setDataInUserStatus(coralAgentsState, "Start Call", Boolean.valueOf(false));
                                    }
                                    if (coralAgentsState.getPreviousStatus().equalsIgnoreCase("On Break")) {
                                        this.setDataInUserStatus(coralAgentsState, "Start Call", Boolean.valueOf(false));
                                    }
                                } else if (coralAgentsState.getCurrentStatus().equalsIgnoreCase("Available (On Demand)")) {
                                    if (coralAgentsState.getPreviousStatus().equalsIgnoreCase("Logged Out")) {
                                        this.setDataInUserStatus(coralAgentsState, "Login", Boolean.valueOf(false));
                                        this.setDataInUserStatus(coralAgentsState, "Start Call", Boolean.valueOf(false));
                                    }
                                    if (coralAgentsState.getPreviousState().equalsIgnoreCase("Idle") && coralAgentsState.getCurrentState().equalsIgnoreCase("Waiting")) {
                                        this.setDataInUserStatus(coralAgentsState, "ACW", Boolean.valueOf(false));
                                    }
                                    if (coralAgentsState.getPreviousStatus().equalsIgnoreCase("On Break")) {
                                        this.setDataInUserStatus(coralAgentsState, "Start Call", Boolean.valueOf(false));
                                    }
                                } else if (coralAgentsState.getCurrentStatus().equalsIgnoreCase("On Break")) {
                                    this.setDataInUserStatus(coralAgentsState, "Break", Boolean.valueOf(false));
                                } else if (coralAgentsState.getCurrentStatus().equalsIgnoreCase("Logged In")) {
                                    this.setDataInUserStatus(coralAgentsState, "Login", Boolean.valueOf(false));
                                } else if (coralAgentsState.getPreviousStatus().equalsIgnoreCase("Available for Manual")) {
                                    this.setDataInUserStatus(coralAgentsState, "Manual Dial", Boolean.valueOf(false));
                                } else if (coralAgentsState.getPreviousStatus().equalsIgnoreCase("Off-Hook")) {
                                    this.setDataInUserStatus(coralAgentsState, "Off-Hook", Boolean.valueOf(false));
                                } else {
                                    this.setDataInUserStatus(coralAgentsState, "Logout", Boolean.valueOf(false));
                                }
                            } else if (coralAgentsState.getPreviousStatus().equalsIgnoreCase("Logged Out") && !coralAgentsState.getCurrentStatus().equalsIgnoreCase("Logged In")) {
                                this.setDataInUserStatus(coralAgentsState, "Login", Boolean.valueOf(false));
                                this.setDataInUserStatus(coralAgentsState, "Start Call", Boolean.valueOf(false));
                            } else if (coralAgentsState.getPreviousStatus().equalsIgnoreCase("Logged Out") && coralAgentsState.getCurrentStatus().equalsIgnoreCase("Logged In")) {
                                this.setDataInUserStatus(coralAgentsState, "Login", Boolean.valueOf(false));
                            } else if (!coralAgentsState.getPreviousStatus().equalsIgnoreCase("Logged Out") && coralAgentsState.getCurrentStatus().equalsIgnoreCase("Logged In")) {
                                this.setDataInUserStatus(coralAgentsState, "Logout", Boolean.valueOf(true));
                                this.setDataInUserStatus(coralAgentsState, "Login", Boolean.valueOf(false));
                            } else {
                                this.setDataInUserStatus(coralAgentsState, "Logout", Boolean.valueOf(true));
                                this.setDataInUserStatus(coralAgentsState, "Login", Boolean.valueOf(false));
                                this.setDataInUserStatus(coralAgentsState, "Start Call", Boolean.valueOf(false));
                            }
                            coralAgentsState.setIsDataSynced(Integer.valueOf(1));
                            this.coralAgentsStateRepository.save((Object)coralAgentsState);
                            continue;
                        }
                        coralAgentsState.setIsDataSynced(Integer.valueOf(2));
                        this.coralAgentsStateRepository.save((Object)coralAgentsState);
                    }
                } else {
                    logger.info("Coral Agents List is Empty.");
                }
                Thread.sleep(coralAgentStatusList.size() < 100 ? 10000 : 1000);
            }
        }
        catch (Exception e) {
            logger.error("Error in Call Center Version Control Thread. Closing thread, thread will be re started in few seconds {}", (Object)e.getMessage(), (Object)e);
            Thread.currentThread().interrupt();
        }
    }
}

