/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.service;

import com.coraltele.telemetry.component.service.AlertEngineService;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.IMSIRepository;
import com.coraltele.telemetry.db.telephony.entity.LocationInSwitch;
import com.coraltele.telemetry.db.telephony.main.entity.ExtensionState;
import com.coraltele.telemetry.db.telephony.main.repository.ExtensionStateRepository;
import com.coraltele.telemetry.db.telephony.main.repository.IMSv2RegistrationRepository;
import com.coraltele.telemetry.db.telephony.main.repository.McxParticipantRepository;
import com.coraltele.telemetry.db.telephony.main.repository.SipRegistrationsRepository;
import com.coraltele.telemetry.db.telephony.main.repository.SubscriberProxyRegistrationRepository;
import com.coraltele.telemetry.db.telephony.pbx.entity.Extension;
import com.coraltele.telemetry.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.telemetry.db.telephony.repository.LocationInSwitchRepository;
import com.coraltele.telemetry.helper.Constants;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PresenceAggregatorService {
    private static final Logger logger = LoggerFactory.getLogger(PresenceAggregatorService.class);
    @Autowired
    private ExtensionsRepository extensionsRepository;
    @Autowired
    private SipRegistrationsRepository sipRegistrationsRepository;
    @Autowired
    private IMSv2RegistrationRepository imsV2Repository;
    @Autowired
    private SubscriberProxyRegistrationRepository proxyRegistrationRepository;
    @Autowired
    private McxParticipantRepository mcxParticipantRepo;
    @Autowired
    private IMSIRepository imsiRepository;
    @Autowired
    private AlertEngineService alertEngineService;
    @Autowired
    private ExtensionStateRepository extensionStateRepository;
    @Autowired
    private LocationInSwitchRepository locationInSwitchRepository;
    private static final String[] listToSentAlert = Constants.EXTENSION_TYPE_LIST_TO_SENT_ALERT.split(",");
    private static final Long timeDifferenceToSentAlert = Constants.EXTENSION_DELAY_TIME_FOR_ALERT * 60L;

    public void checkPresence() {
        logger.info("Starting presence check cycle.");
        this.extensionsRepository.findAll().forEach(ext -> {
            block8: {
                if (ext.getExtensionType().equals("phone") || ext.getExtensionType().equals("agent") || ext.getExtensionType().equals("fax")) {
                    boolean isPresent = this.checkExtensionPresence(ext);
                    logger.info("Alert check for extension and check : {} {} ", (Object)ext.getExtension(), (Object)isPresent);
                    try {
                        if (isPresent) {
                            this.alertEngineService.closeAlert(ext.getExtension(), "PRESENCE");
                            Optional lastCall = this.extensionStateRepository.findByExtension(ext.getExtension());
                            List registrationDetails = this.locationInSwitchRepository.findByUsername(ext.getExtension());
                            if (registrationDetails.isEmpty()) {
                                this.alertEngineService.raiseAlert(ext.getExtension(), "CONNECTION", 3, "Not registered in switch");
                                break block8;
                            }
                            for (LocationInSwitch locationInSwitch : registrationDetails) {
                                if (!this.isAnalog(locationInSwitch.getUserAgent())) continue;
                                if (!lastCall.isPresent() || Instant.now().getEpochSecond() - ((ExtensionState)lastCall.get()).getEventUpdatedEpoch() > timeDifferenceToSentAlert) {
                                    this.alertEngineService.raiseAlert(ext.getExtension(), "CONNECTION", 3, "Disconnected");
                                } else {
                                    this.alertEngineService.closeAlert(ext.getExtension(), "CONNECTION");
                                }
                                break block8;
                            }
                            break block8;
                        }
                        this.alertEngineService.raiseAlert(ext.getExtension(), "PRESENCE", 3, "Not registered");
                    }
                    catch (Exception e) {
                        logger.error("Error processing extension {}: {}", new Object[]{ext.getExtension(), e.getMessage(), e});
                    }
                }
            }
        });
        logger.info("Finished presence check cycle.");
    }

    private boolean isAnalog(String userAgent) {
        for (String extType : listToSentAlert) {
            if (!userAgent.contains(extType)) continue;
            return true;
        }
        return false;
    }

    private boolean checkExtensionPresence(Extension ext) {
        if (Constants.PRESENCE_SOURCES_ENABLED_FS && this.sipRegistrationsRepository != null && this.checkRepo(this.sipRegistrationsRepository.existsBySipUser(ext.getExtension()))) {
            return true;
        }
        if (Constants.PRESENCE_SOURCES_ENABLED_IMSv2 && this.imsV2Repository != null && this.checkRepo(this.imsV2Repository.existsBySipUser(ext.getExtension()))) {
            return true;
        }
        if (Constants.PRESENCE_SOURCES_ENABLED_PROXY && this.proxyRegistrationRepository != null && this.checkRepo(this.proxyRegistrationRepository.existsByUsername(ext.getExtension()))) {
            return true;
        }
        if (Constants.PRESENCE_SOURCES_ENABLED_MCX && this.mcxParticipantRepo != null && this.checkMcxPresence(ext)) {
            return true;
        }
        return Constants.PRESENCE_SOURCES_ENABLED_IMSI && this.imsiRepository != null && ext.getIMSI() != null && this.checkRepo(this.imsiRepository.existsByImsiNumberAndConnectedTrue(ext.getIMSI()));
    }

    private boolean checkMcxPresence(Extension ext) {
        long cutoffEpoch = Instant.now().getEpochSecond() - (long)Constants.PRESENCE_MCX_HEARTBEAT;
        return this.mcxParticipantRepo.existsByParticipantNoAndKeepAliveEpochGreaterThan(ext.getExtension(), cutoffEpoch);
    }

    private boolean checkRepo(boolean exists) {
        return exists;
    }
}

