/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.audit;

import com.coraltele.telemetry.audit.AuditLogService;
import com.coraltele.telemetry.audit.Auditable;
import com.coraltele.telemetry.audit.AuditableField;
import com.coraltele.telemetry.db.telemetry.main.entity.AuditLog;
import com.coraltele.telemetry.db.telemetry.main.repository.AuditLogRepository;
import com.coraltele.telemetry.helper.SpringHelper;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PreUpdate;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuditLogEntityListener {
    private String convertToJson(Object object) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private AuditLogService getAuditLogService() {
        return (AuditLogService)SpringHelper.getBean(AuditLogService.class);
    }

    private String getEntityName(Object entity) {
        Auditable auditable = entity.getClass().getAnnotation(Auditable.class);
        if (auditable != null && !auditable.name().isEmpty()) {
            return auditable.name();
        }
        return entity.getClass().getSimpleName();
    }

    private String getFieldName(Field field) {
        AuditableField auditableField = field.getAnnotation(AuditableField.class);
        if (auditableField != null && !auditableField.name().isEmpty()) {
            return auditableField.name();
        }
        return field.getName();
    }

    private Map<String, Object[]> getChangesMap(Object entity, Object[] currentState, Object[] previousState, String[] propertyNames) {
        HashMap<String, Object[]> changesMap = new HashMap<String, Object[]>();
        for (int i = 0; i < propertyNames.length; ++i) {
            if (currentState[i] == null || currentState[i].equals(previousState[i])) continue;
            try {
                Field field = entity.getClass().getDeclaredField(propertyNames[i]);
                String customFieldName = this.getFieldName(field);
                changesMap.put(field.getName(), new Object[]{customFieldName, previousState[i], currentState[i]});
                continue;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return changesMap;
    }

    @PostPersist
    public void onPostCreate(Object entity) {
        String changesJson = this.convertToJson(entity);
        AuditLog auditLog = new AuditLog();
        auditLog.setEntityName(this.getEntityName(entity));
        auditLog.setEntityClass(entity.getClass().getName());
        auditLog.setChanges(changesJson);
        auditLog.setOperationType(AuditLog.OperationType.INSERT);
        this.getAuditLogService().logAudit(auditLog);
        this.getAuditLogService().logSync(entity);
    }

    @PreUpdate
    public void onPreUpdate(Object entity) {
        AuditLogRepository auditLogRepository = (AuditLogRepository)SpringHelper.getBean(AuditLogRepository.class);
        EntityManager em = auditLogRepository.getEntityManagerForClass(entity.getClass());
        SessionImplementor session = (SessionImplementor)em.unwrap(SessionImplementor.class);
        MetamodelImplementor metaModel = session.getSessionFactory().getMetamodel();
        EntityPersister persister = metaModel.entityPersister(entity.getClass().getName());
        Serializable id = persister.getIdentifier(entity, (SharedSessionContractImplementor)session);
        Object[] currentState = persister.getPropertyValues(entity);
        Object[] previousState = persister.getDatabaseSnapshot(id, (SharedSessionContractImplementor)session);
        String[] propertyNames = persister.getPropertyNames();
        String changesJson = this.convertToJson((Object)this.getChangesMap(entity, currentState, previousState, propertyNames));
        AuditLog auditLog = new AuditLog();
        auditLog.setEntityName(this.getEntityName(entity));
        auditLog.setEntityClass(entity.getClass().getName());
        auditLog.setEntityId(AuditLogEntityListener.serializeToString((Serializable)id));
        auditLog.setChanges(changesJson);
        auditLog.setOperationType(AuditLog.OperationType.UPDATE);
        this.getAuditLogService().logAudit(auditLog);
    }

    @PostUpdate
    public void onPostUpdate(Object entity) {
        String changesJson = this.convertToJson(entity);
        AuditLog auditLog = new AuditLog();
        auditLog.setEntityName(this.getEntityName(entity));
        auditLog.setEntityClass(entity.getClass().getName());
        auditLog.setChanges(changesJson);
        auditLog.setOperationType(AuditLog.OperationType.UPDATE);
        this.getAuditLogService().logAudit(auditLog);
        this.getAuditLogService().logSync(entity);
    }

    @PostRemove
    public void onPostDelete(Object entity) {
        String changesJson = this.convertToJson(entity);
        AuditLog auditLog = new AuditLog();
        auditLog.setEntityName(this.getEntityName(entity));
        auditLog.setEntityClass(entity.getClass().getName());
        auditLog.setChanges(changesJson);
        auditLog.setOperationType(AuditLog.OperationType.DELETE);
        this.getAuditLogService().logAudit(auditLog);
    }

    public static String serializeToString(Serializable object) {
        if (object instanceof Integer) {
            return Integer.toString((Integer)object);
        }
        if (object instanceof Long) {
            return Long.toString((Long)object);
        }
        if (object instanceof String) {
            return (String)((Object)object);
        }
        return "Invalid-Data-Type";
    }
}

