/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.data.service;

import com.coraltele.telemetry.db.telemetry.main.entity.Registration;
import com.coraltele.telemetry.db.telemetry.main.repository.RegistrationRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.service.billing.callMos.service.MessageProducerService;
import com.coraltele.telemetry.service.coralnms.data.model.CallChannels;
import com.coraltele.telemetry.service.coralnms.data.model.CallData;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class ActiveExtService {
    private static final Logger logger = LogManager.getLogger(ActiveExtService.class);
    @Autowired
    RegistrationRepository registrationRepository;
    @Autowired
    MessageProducerService messageProducerService;

    public List<Registration> getIMSRegistrations() {
        List<Object> returnValue = new ArrayList<Registration>();
        try {
            String clientIp = this.messageProducerService.getServerIp();
            logger.info("Client ip for get details:{}", (Object)clientIp);
            returnValue = this.registrationRepository.findByIpAddressOrderByStatusAscExtensionAsc(clientIp);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Unable to get Extension list:{}", (Object)e.getMessage());
        }
        return returnValue;
    }

    public List<CallData> getIMSRLUCalls() {
        ArrayList<CallData> returnValue = new ArrayList<CallData>();
        String clientIp = this.messageProducerService.getServerIp();
        logger.info("IP of Current Server:{}", (Object)clientIp);
        String callServerURL = String.format("http%s://%s/api/v2/realtime/channels", Constants.CLUSTER_SSL_ENABLED != false ? "s" : "", clientIp);
        logger.info("Fetching data from : {}", (Object)callServerURL);
        try {
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity response = restTemplate.getForEntity(callServerURL, CallChannels[].class, new Object[0]);
            CallChannels[] data = (CallChannels[])response.getBody();
            long currentTimestamp = System.currentTimeMillis() / 1000L;
            Arrays.stream(data).filter(row -> row.getDirection().equals("initiator") && !row.getState().equals("stale") && row.getRingEpoch() != null && row.getInboundGateway() == null && row.getOutboundGateway() == null).forEach(channel -> returnValue.add(new CallData(StringUtils.hasLength((String)channel.getLocalName()) ? channel.getLocalName() : channel.getLocalUser(), StringUtils.hasLength((String)channel.getRemoteName()) ? channel.getRemoteName() : channel.getRemoteUser(), Long.valueOf(channel.getRingEpoch() == null ? 0L : channel.getRingEpoch() / 1000L), Long.valueOf(channel.getAnswerEpoch() == null ? 0L : channel.getAnswerEpoch() / 1000L), LocalTime.ofSecondOfDay((long)Math.floor((channel.getAnswerEpoch() == null || channel.getAnswerEpoch() == 0L ? currentTimestamp : channel.getAnswerEpoch() / 1000L) - channel.getRingEpoch() / 1000L)).toString(), LocalTime.ofSecondOfDay((long)Math.floor(currentTimestamp - channel.getRingEpoch() / 1000L)).toString(), "", "")));
        }
        catch (Exception e) {
            logger.error("Unable to fetch data from : {}", (Object)callServerURL, (Object)e);
        }
        return returnValue;
    }

    public List<CallData> getIMSRLUExternalCalls() {
        ArrayList<CallData> returnValue = new ArrayList<CallData>();
        String clientIp = this.messageProducerService.getServerIp();
        logger.info("IP of Current Server:{}", (Object)clientIp);
        String callServerURL = String.format("http%s://%s/api/v2/realtime/channels", Constants.CLUSTER_SSL_ENABLED != false ? "s" : "", clientIp);
        logger.info("Fetching data from : {}", (Object)callServerURL);
        try {
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity response = restTemplate.getForEntity(callServerURL, CallChannels[].class, new Object[0]);
            CallChannels[] data = (CallChannels[])response.getBody();
            long currentTimestamp = System.currentTimeMillis() / 1000L;
            Arrays.stream(data).filter(row -> row.getDirection().equals("initiator") && !row.getState().equals("stale") && row.getRingEpoch() != null && (StringUtils.hasLength((String)row.getInboundGateway()) || StringUtils.hasLength((String)row.getOutboundGateway()))).forEach(channel -> returnValue.add(new CallData(StringUtils.hasLength((String)channel.getLocalName()) ? channel.getLocalName() : channel.getLocalUser(), StringUtils.hasLength((String)channel.getRemoteName()) ? channel.getRemoteName() : channel.getRemoteUser(), Long.valueOf(channel.getRingEpoch() == null ? 0L : channel.getRingEpoch() / 1000L), Long.valueOf(channel.getAnswerEpoch() == null ? 0L : channel.getAnswerEpoch() / 1000L), LocalTime.ofSecondOfDay((long)Math.floor((channel.getAnswerEpoch() == null || channel.getAnswerEpoch() == 0L ? currentTimestamp : channel.getAnswerEpoch() / 1000L) - channel.getRingEpoch() / 1000L)).toString(), LocalTime.ofSecondOfDay((long)Math.floor(currentTimestamp - channel.getRingEpoch() / 1000L)).toString(), StringUtils.hasLength((String)channel.getInboundGateway()) ? "In" : "Out", StringUtils.hasLength((String)channel.getInboundGateway()) ? channel.getInboundGateway() : channel.getOutboundGateway())));
        }
        catch (Exception e) {
            logger.error("Unable to fetch data from : {}", (Object)callServerURL, (Object)e);
        }
        return returnValue;
    }
}

