/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.condition.EnableSwitchCdrCollection;
import com.coraltele.telemetry.db.coralapps.repository.CallDataRecordRepository;
import com.coraltele.telemetry.db.telephony.pbx.repository.SwitchCallDataRecordRepository;
import com.coraltele.telemetry.thread.SwitchCdrCollectionThread;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableSwitchCdrCollection.class})
public class SwitchCdrCollectionProcess {
    private static final Logger logger = LogManager.getLogger(SwitchCdrCollectionProcess.class);
    private static final Integer MAX_THREADS = 1;
    ExecutorService threadPool = Executors.newFixedThreadPool(1);
    @Autowired
    private SwitchCallDataRecordRepository switchCallDataRecordRepository;
    @Autowired
    private CallDataRecordRepository callDataRecordRepository;

    @Scheduled(fixedRate=5000L)
    public void startHealthCheck() throws InterruptedException {
        logger.info("Maximum Threads : {}, Active Thread {} ", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        Integer threadsStarted = 0;
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            Integer n = threadsStarted;
            Integer n2 = threadsStarted = Integer.valueOf(threadsStarted + 1);
            logger.info("Starting Switch CDR Data Collection Process");
            this.threadPool.execute((Runnable)new SwitchCdrCollectionThread(this.switchCallDataRecordRepository, this.callDataRecordRepository));
        }
        logger.info("{} Threads started", (Object)threadsStarted);
    }
}

