/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.app;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.Location;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.LocationRepository;
import com.coraltele.telemetry.helper.HTTPHelper;
import com.coraltele.telemetry.helper.RequestResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.xml.sax.SAXException;

@RequestMapping(value={"/app/v2/status"})
@RestController
public class StatusController {
    public static final String OID = ".1.3.6.1.4.1.15939.4.3";
    @Value(value="${application.name}")
    private String applicationName;
    @Value(value="${build.version}")
    private String buildVersion;
    @Autowired
    LocationRepository locationRepository;

    @GetMapping(value={"/live"})
    public ResponseEntity<RequestResponse> currentStatus(HttpServletRequest request) throws ParserConfigurationException, SAXException, JsonProcessingException {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            returnValue.setMessage(MessageFormat.format("Application : {0}, Version {1}, Client IP {2}", this.applicationName, this.buildVersion, HTTPHelper.getRequestIp((HttpServletRequest)request)));
            Optional toEdit = this.locationRepository.findByCode("CORAL");
            if (toEdit.isPresent()) {
                Location dataToSave = (Location)toEdit.get();
                dataToSave.setName("Coral - 1 - " + UUID.randomUUID().toString());
                dataToSave.setBackgroundImageURL(UUID.randomUUID().toString());
                dataToSave.setXcoordinate("77.4538");
                this.locationRepository.save((Object)dataToSave);
            }
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

