/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.categoryService.service;

import com.coraltele.telemetry.db.telemetry.main.entity.CategoryService;
import com.coraltele.telemetry.db.telemetry.main.repository.CategoryServiceRepository;
import com.coraltele.telemetry.db.telemetry.main.specification.CategoryServiceSpecification;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.model.SearchResponse;
import com.coraltele.telemetry.service.main.categoryService.model.CategoryServiceModel;
import com.coraltele.telemetry.service.main.categoryService.model.SingleCategoryCodeModel;
import com.coraltele.telemetry.service.main.categoryService.model.SingleServiceCodeModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class CategoryServiceService {
    private static final Logger logger = LogManager.getLogger(CategoryServiceService.class);
    @Autowired
    CategoryServiceRepository categoryServiceRepository;

    public RequestResponse createCategoryService(CategoryServiceModel data) {
        logger.debug("create new categoryService : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            CategoryService categoryService = new CategoryService();
            categoryService.setCategoryCode(data.getCategoryCode());
            categoryService.setServiceCode(data.getServiceCode());
            this.categoryServiceRepository.save((Object)categoryService);
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("categoryService created successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to create categoryService");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(CategoryServiceModel data) {
        logger.debug("Update monitorService {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional categoryService = this.categoryServiceRepository.findById(data.getId());
        if (!categoryService.isPresent()) {
            returnValue.setStatus(-1);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("categoryService not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getCategoryCode() != null) {
            ((CategoryService)categoryService.get()).setCategoryCode(data.getCategoryCode());
        }
        if (data.getServiceCode() != null) {
            ((CategoryService)categoryService.get()).setServiceCode(data.getServiceCode());
        }
        this.categoryServiceRepository.save(categoryService.get());
        returnValue.setStatus(0);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("categoryService Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteCategoryServiceById(Long id) {
        logger.debug("Delete categoryService id {}", (Object)id);
        RequestResponse returnValue = new RequestResponse();
        Optional categoryService = this.categoryServiceRepository.findById(id);
        if (categoryService.isPresent()) {
            try {
                this.categoryServiceRepository.deleteById((Object)id);
                returnValue.setStatus(0);
                returnValue.setMessage("categoryService deleted");
                logger.info(returnValue.getMessage());
            }
            catch (Exception ex) {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to delete categoryService");
                returnValue.setMessageDetail("Contact with your administrator");
                logger.error(returnValue.getMessageDetail(), (Throwable)ex);
            }
        } else {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to delete record");
            returnValue.setMessageDetail("Record Not found");
            logger.error(returnValue.getMessageDetail());
        }
        return returnValue;
    }

    public RequestResponse getCategoryServiceByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = CategoryServiceSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.categoryServiceRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.categoryServiceRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllServiceCode() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<SingleServiceCodeModel> addValue = new ArrayList<SingleServiceCodeModel>();
        List categoryService = this.categoryServiceRepository.findAll();
        if (categoryService.isEmpty()) {
            returnValue.setMessage("List is empty");
            logger.error("unable to fetch data: ", (Object)returnValue.getMessage());
        } else {
            for (CategoryService row : categoryService) {
                SingleServiceCodeModel data = new SingleServiceCodeModel();
                data.setServiceCode(row.getServiceCode());
                addValue.add(data);
            }
        }
        returnValue.setData(addValue);
        returnValue.setMessage("List of Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllCategoryCode() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<SingleCategoryCodeModel> addValue = new ArrayList<SingleCategoryCodeModel>();
        List categoryService = this.categoryServiceRepository.findAll();
        if (categoryService.isEmpty()) {
            returnValue.setMessage("List is empty");
            logger.error("unable to fetch data: ", (Object)returnValue.getMessage());
        } else {
            for (CategoryService row : categoryService) {
                SingleCategoryCodeModel data = new SingleCategoryCodeModel();
                data.setCategoryCode(row.getCategoryCode());
                addValue.add(data);
            }
        }
        returnValue.setData(addValue);
        returnValue.setMessage("List of Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

