/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.imsi.service;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.IMSI;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.IMSIRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.helper.SpringHelper;
import com.coraltele.telemetry.model.ImsiWithAssetDataModel;
import java.util.Arrays;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IMSIService {
    private static final Logger logger = LogManager.getLogger(IMSIService.class);
    @Autowired
    private IMSIRepository imsiRepository;
    @Autowired
    private SCADAAssetRepository scadaAssetRepository;

    public RequestResponse createReceivedImsiData(ImsiWithAssetDataModel imsiData) {
        logger.info("Processing received IMSI data...");
        RequestResponse response = new RequestResponse();
        try {
            SCADAAsset asset = imsiData.getScadaAsset();
            IMSI imsiDetails = imsiData.getImsiData();
            if (asset == null || imsiDetails == null) {
                response.setStatus(-1);
                response.setMessage("Invalid data: SCADAAsset or IMSI missing");
                return response;
            }
            Optional existingAsset = this.scadaAssetRepository.findByUuid(asset.getUuid());
            SCADAAsset scadaAsset = null;
            if (existingAsset.isPresent()) {
                scadaAsset = (SCADAAsset)existingAsset.get();
                SpringHelper.copyAllPropertiesExcept((Object)asset, (Object)scadaAsset, Arrays.asList("id"));
                this.scadaAssetRepository.save((Object)scadaAsset);
                logger.info("Existing asset updated with ID: {}", (Object)((SCADAAsset)existingAsset.get()).getId());
            } else {
                asset.setId(null);
                scadaAsset = (SCADAAsset)this.scadaAssetRepository.save((Object)asset);
                logger.info("New asset saved with ID: {}", (Object)scadaAsset.getId());
            }
            Optional existingIMSI = this.imsiRepository.findByUuid(imsiDetails.getUuid());
            if (existingIMSI.isPresent()) {
                IMSI imsiToSave = (IMSI)existingIMSI.get();
                SpringHelper.copyAllPropertiesExcept((Object)imsiDetails, (Object)imsiToSave, Arrays.asList("id"));
                imsiToSave.setAsset(scadaAsset);
                this.imsiRepository.save((Object)imsiToSave);
            } else {
                imsiDetails.setAsset(scadaAsset);
                this.imsiRepository.save((Object)imsiDetails);
                logger.info("New alert saved, marked for sync: {}", (Object)imsiDetails.getUuid());
            }
            response.setStatus(0);
            response.setMessage("IMSI Data saved successfully");
            response.setMessageDetail("IMSI linked to SCADAAsset and marked as synced");
            logger.info(response.getMessage());
        }
        catch (Exception e) {
            response.setStatus(-1);
            response.setMessage("Failed to save IMSI data");
            response.setMessageDetail("Error occurred while saving IMSI. Contact administrator.");
            logger.error("Error saving IMSI Data: {}", (Object)response.getMessageDetail(), (Object)e);
        }
        return response;
    }
}

