/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.alert_detail.controller;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.service.coralnms.alert_detail.model.MultipleAlertDetail;
import com.coraltele.telemetry.service.coralnms.alert_detail.service.AlertDetailService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/alertDetail"})
@RestController
@CrossOrigin(origins={"*"})
public class AlertDetailController {
    @Autowired
    private AlertDetailService alertDetailService;

    @PostMapping(value={"/register"})
    public ResponseEntity<RequestResponse> addAlertDetail(@RequestBody MultipleAlertDetail alertDetailModel) {
        RequestResponse returnValue = this.alertDetailService.createAlertDetail(alertDetailModel);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/getFilterDataV2"})
    public ResponseEntity<RequestResponse> getFilterDataV2(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.alertDetailService.getAlertDetailByFilter(searchRequest);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/{alertDetailId}"})
    public ResponseEntity<RequestResponse> getAlertDetailById(@PathVariable(value="alertDetailId") Long id) {
        RequestResponse returnValue = this.alertDetailService.getById(id);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllAlertDetail() {
        RequestResponse returnValue = this.alertDetailService.getAll();
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PutMapping(value={"/{alertDetailId}"})
    public ResponseEntity<RequestResponse> updateAlertDetail(@PathVariable(value="alertDetailId") Long id) {
        RequestResponse returnValue = this.alertDetailService.updateById(id);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listFalse"})
    public ResponseEntity<RequestResponse> getAllReadFalse(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.alertDetailService.getAllFalse(searchRequest);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/sizeRead"})
    public int getAll() {
        return this.alertDetailService.getSize();
    }

    @DeleteMapping(value={"/{alertDetailId}"})
    public ResponseEntity<RequestResponse> deleteById(@PathVariable(value="alertDetailId") Long id) {
        RequestResponse returnValue = this.alertDetailService.deleteById(id);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PutMapping(value={"/multipleUpdates"})
    public ResponseEntity<RequestResponse> updateAll(@RequestBody List<Long> ids) {
        RequestResponse returnValue = this.alertDetailService.updateAll(ids);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @DeleteMapping(value={"/multipleDelete"})
    public ResponseEntity<RequestResponse> deleteAll(@RequestBody List<Long> ids) {
        RequestResponse returnValue = this.alertDetailService.deleteMultipleRecords(ids);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

