/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cglib.core.internal.Function;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    private String secret;
    private int jwtExpirationInMs;

    @Value(value="${jwt.secret}")
    public void setSecret(String secret) {
        this.secret = secret + "-3be8dd5f-c66b-4b3c-88f5-b2d36c9238dd";
        this.secret = Base64.getEncoder().encodeToString(this.secret.getBytes());
    }

    @Value(value="${jwt.expiration}")
    public void setJwtExpirationInMs(int jwtExpiration) {
        this.jwtExpirationInMs = jwtExpiration * 1000;
    }

    private Claims getAllClaimsFromToken(String token) {
        return (Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody();
    }

    public <T> T getClaimFromToken(String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.getAllClaimsFromToken(token);
        return (T)claimsResolver.apply((Object)claims);
    }

    public String getUsernameFromToken(String token) {
        return (String)this.getClaimFromToken(token, Claims::getSubject);
    }

    private String doGenerateToken(Map<String, Object> claims, String subject) {
        return Jwts.builder().setClaims(claims).setSubject(subject).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + (long)this.jwtExpirationInMs)).signWith(SignatureAlgorithm.HS512, this.secret).compact();
    }

    public String generateToken(UserDetails userDetails) {
        HashMap claims = new HashMap();
        return this.doGenerateToken(claims, userDetails.getUsername());
    }

    public boolean validateToken(String authToken) {
        try {
            Jws claims = Jwts.parser().setSigningKey(this.secret).parseClaimsJws(authToken);
            return true;
        }
        catch (MalformedJwtException | SignatureException | UnsupportedJwtException | IllegalArgumentException ex) {
            throw new BadCredentialsException("INVALID_CREDENTIALS", ex);
        }
        catch (ExpiredJwtException ex) {
            throw ex;
        }
    }

    public Date getExpirationDateFromToken(String token) {
        return (Date)this.getClaimFromToken(token, Claims::getExpiration);
    }
}

