/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.user.service;

import com.coraltele.telemetry.db.telephony.pbx.entity.Extension;
import com.coraltele.telemetry.db.telephony.repository.ExtensionRepository;
import com.coraltele.telemetry.db.users.main.entity.Role;
import com.coraltele.telemetry.db.users.main.entity.User;
import com.coraltele.telemetry.db.users.main.entity.UserDepartment;
import com.coraltele.telemetry.db.users.main.repository.RoleRepository;
import com.coraltele.telemetry.db.users.main.repository.UserDepartmentRepository;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.db.users.main.specification.UserSpecification;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.helper.ReturnField;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.model.SearchResponse;
import com.coraltele.telemetry.service.user.model.UserModel;
import com.coraltele.telemetry.service.user.model.ViewUserModel;
import com.coraltele.telemetry.service.user.service.UserRoleService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UserService {
    private static final Logger logger = LogManager.getLogger(UserService.class);
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private PasswordEncoder bcryptEncoder;
    @Autowired
    UserRoleService userRoleService;
    @Autowired
    RoleRepository roleRepository;
    @Autowired
    ExtensionRepository extensionRepository;
    @Autowired
    UserDepartmentRepository userDepartmentRepository;

    public RequestResponse createUser(UserModel data) {
        logger.debug("create new user : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            User user = new User();
            user.setUsername(data.getUsername());
            user.setPassword(this.bcryptEncoder.encode((CharSequence)data.getPassword()));
            user.setAccountExpired(data.isAccountExpired());
            user.setAccountLocked(data.isAccountLocked());
            user.setCredentialsExpired(data.isCredentialsExpired());
            user.setLastPasswordChange(LocalDate.now());
            user.setLastLogon(LocalDate.now());
            user.setEnabled(data.getEnabled());
            this.userRepository.save((Object)user);
            ReturnField field = new ReturnField();
            field.setId(user.getId());
            field.setDescription(user.getUsername());
            returnValue.setStatus(0);
            returnValue.setMessage("User Registered");
            returnValue.setData((Object)field);
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to create user");
            returnValue.setMessageDetail("Contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getUserById(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional user = this.userRepository.findById(id);
            if (user.isPresent()) {
                ViewUserModel data = new ViewUserModel();
                data.setId(((User)user.get()).getId());
                data.setUsername(((User)user.get()).getUsername());
                data.setAccountExpired(((User)user.get()).isAccountExpired());
                data.setCredentialsExpired(((User)user.get()).isCredentialsExpired());
                data.setAccountLocked(((User)user.get()).isAccountLocked());
                data.setEnabled(((User)user.get()).getEnabled());
                returnValue.setStatus(0);
                returnValue.setMessage("user Found");
                returnValue.setData((Object)data);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateUser(int id, UserModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional user = this.userRepository.findById(id);
            if (user.isPresent()) {
                ((User)user.get()).setUsername(data.getUsername());
                ((User)user.get()).setAccountExpired(data.isAccountExpired());
                ((User)user.get()).setCredentialsExpired(data.isCredentialsExpired());
                ((User)user.get()).setAccountLocked(data.isAccountLocked());
                ((User)user.get()).setEnabled(data.getEnabled());
                this.userRepository.save(user.get());
                returnValue.setStatus(0);
                returnValue.setMessage("Updated");
                returnValue.setMessageDetail("User Updated successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("User not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to update user");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse deleteUser(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional user = this.userRepository.findById(id);
            if (user.isPresent()) {
                this.userRepository.deleteById(id);
                returnValue.setStatus(0);
                returnValue.setMessage("deleted");
                returnValue.setMessageDetail("Record deleted successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to delete user");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public Optional<User> getUserByName(String userName) {
        return this.userRepository.findByUsername(userName);
    }

    public String retrieveUser(String ipAddress, String apiKey) {
        Optional userOptional = this.userRepository.findByKeyValue(apiKey);
        if (userOptional.isPresent() && ((User)userOptional.get()).getIpAddress() != null) {
            User user = (User)userOptional.get();
            return ipAddress.equals(((User)userOptional.get()).getIpAddress()) || ((User)userOptional.get()).getIpAddress().equals("all-ip") ? user.getUsername() : null;
        }
        return null;
    }

    public void createUserAgent(Integer i) {
        String username = "agent";
        User user = new User();
        user.setUsername(String.valueOf(i));
        user.setPassword(this.bcryptEncoder.encode((CharSequence)"1234"));
        user.setDescription(username + i);
        user.setCreatedOn(LocalDateTime.now());
        user.setContactNo(String.valueOf(i));
        user.setLastLogon(LocalDate.now());
        user.setLastPasswordChange(LocalDate.now());
        this.userRepository.save((Object)user);
    }

    public RequestResponse getUserByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = UserSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.userRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.userRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public String getContactNumber(String username) {
        Optional userOptional = this.userRepository.findByUsername(username);
        if (userOptional.isPresent() && StringUtils.hasText((String)((User)userOptional.get()).getContactNo())) {
            return ((User)userOptional.get()).getContactNo();
        }
        return "";
    }

    public boolean checkAdminUser(String userName) {
        List rolesOfUser = this.userRoleService.roleIdOfParticularUser(userName);
        Optional adminRole = this.roleRepository.findByShortCode("ROLE_ADMIN");
        return adminRole.isPresent() && rolesOfUser.contains(((Role)adminRole.get()).getId());
    }

    public List<String> getDepartmentOfUsers(String department) {
        List userDepartmentList;
        HashSet<String> userSet = new HashSet<String>();
        List extensionList = this.extensionRepository.findByDepartment(department);
        if (!extensionList.isEmpty()) {
            for (Extension extension : extensionList) {
                String username;
                if (extension.getDepartment().equals("ec") || !StringUtils.hasLength((String)(username = this.getUserByExtension(extension.getExtension())))) continue;
                userSet.add(username);
            }
        }
        if (!(userDepartmentList = this.userDepartmentRepository.findByDepartment(department)).isEmpty()) {
            for (UserDepartment userDepartment : userDepartmentList) {
                userSet.add(userDepartment.getUsername());
            }
        }
        return new ArrayList<String>(userSet);
    }

    public String getUserByExtension(String extension) {
        List userList = this.userRepository.findByContactNo(extension);
        if (!userList.isEmpty()) {
            return ((User)userList.get(0)).getUsername();
        }
        return "";
    }
}

