/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.monitorService.service;

import com.coraltele.telemetry.db.telemetry.main.entity.MonitorService;
import com.coraltele.telemetry.db.telemetry.main.repository.MonitorServiceRepository;
import com.coraltele.telemetry.db.telemetry.main.specification.MonitorServiceSpecification;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.model.SearchResponse;
import com.coraltele.telemetry.service.main.monitorService.model.MonitorServiceModel;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class MonitorServiceService {
    private static final Logger logger = LogManager.getLogger(MonitorServiceService.class);
    @Autowired
    MonitorServiceRepository monitorServiceRepository;

    public RequestResponse createMonitorService(MonitorServiceModel data) {
        logger.debug("create new monitorService : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            MonitorService monitorService = new MonitorService();
            monitorService.setCode(data.getCode());
            monitorService.setDuration(data.getDuration());
            monitorService.setPortNumber(data.getPortNumber());
            monitorService.setServiceName(data.getServiceName());
            this.monitorServiceRepository.save((Object)monitorService);
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("monitorService created successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to create monitorService");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(MonitorServiceModel data) {
        logger.debug("Update monitorService {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional monitorService = this.monitorServiceRepository.findById(data.getId());
        if (!monitorService.isPresent()) {
            returnValue.setStatus(-1);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("monitorService not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getCode() != null) {
            ((MonitorService)monitorService.get()).setCode(data.getCode());
        }
        if (data.getDuration() != null) {
            ((MonitorService)monitorService.get()).setDuration(data.getDuration());
        }
        if (data.getPortNumber() != null) {
            ((MonitorService)monitorService.get()).setPortNumber(data.getPortNumber());
        }
        if (data.getServiceName() != null) {
            ((MonitorService)monitorService.get()).setServiceName(data.getServiceName());
        }
        this.monitorServiceRepository.save(monitorService.get());
        returnValue.setStatus(0);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("monitorService Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteMonitorServiceById(Long id) {
        logger.debug("Delete monitorService id {}", (Object)id);
        RequestResponse returnValue = new RequestResponse();
        Optional monitorService = this.monitorServiceRepository.findById(id);
        if (monitorService.isPresent()) {
            try {
                this.monitorServiceRepository.deleteById((Object)id);
                returnValue.setStatus(0);
                returnValue.setMessage("monitorService deleted");
                logger.info(returnValue.getMessage());
            }
            catch (Exception ex) {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to delete monitorService");
                returnValue.setMessageDetail("Contact with your administrator");
                logger.error(returnValue.getMessageDetail(), (Throwable)ex);
            }
        } else {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to delete record");
            returnValue.setMessageDetail("Record Not found");
            logger.error(returnValue.getMessageDetail());
        }
        return returnValue;
    }

    public RequestResponse getMonitorServiceByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = MonitorServiceSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.monitorServiceRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.monitorServiceRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

