/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.alert_detail.service;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.AlertDetail;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.AlertDetailRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.specification.AlertDetailSpecification;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.model.SearchResponse;
import com.coraltele.telemetry.service.coralnms.alert_detail.model.AlertDetailModel;
import com.coraltele.telemetry.service.coralnms.alert_detail.model.MultipleAlertDetail;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.support.PagedListHolder;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class AlertDetailService {
    private static final Logger logger = LogManager.getLogger(AlertDetailService.class);
    @Autowired
    private AlertDetailRepository alertDetailRepository;

    public RequestResponse createAlertDetail(MultipleAlertDetail records) {
        logger.debug("create new alertDetail : {} ", (Object)records);
        RequestResponse returnValue = new RequestResponse();
        try {
            for (AlertDetailModel row : records.getAlertDetailModel()) {
                AlertDetail alertDetail = new AlertDetail();
                alertDetail.setAlertType(row.getAlertType());
                alertDetail.setIp(row.getIp());
                alertDetail.setMessage(row.getMessage());
                alertDetail.setRead(row.isRead());
                alertDetail.setMessageDetail(row.getMessageDetail());
                alertDetail.setAlertDate(LocalDateTime.now());
                alertDetail.setEventId(row.getEventId());
                this.alertDetailRepository.save((Object)alertDetail);
            }
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("alertDetail created successfully");
            logger.info(returnValue.getMessage());
        }
        catch (DataIntegrityViolationException ex) {
            returnValue.setStatus(-1);
            returnValue.setIssue(Constants.NodeStatus.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create");
            returnValue.setMessageDetail("Read constraint can not be null");
            logger.error(returnValue.getMessageDetail(), (Throwable)ex);
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setIssue(Constants.NodeStatus.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to create user");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getById(Long id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional alertDetail = this.alertDetailRepository.findById(id);
            if (alertDetail.isPresent()) {
                AlertDetailModel data = new AlertDetailModel();
                data.setId(((AlertDetail)alertDetail.get()).getId());
                data.setAlertType(((AlertDetail)alertDetail.get()).getAlertType());
                data.setIp(((AlertDetail)alertDetail.get()).getIp());
                data.setMessage(((AlertDetail)alertDetail.get()).getMessage());
                data.setRead(((AlertDetail)alertDetail.get()).isRead());
                data.setMessageDetail(((AlertDetail)alertDetail.get()).getMessageDetail());
                data.setAlertDate(LocalDateTime.now());
                data.setEventId(((AlertDetail)alertDetail.get()).getEventId());
                returnValue.setStatus(0);
                returnValue.setMessage("alertDetail Found");
                returnValue.setData((Object)data);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(0);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
            }
        }
        catch (Exception e) {
            returnValue.setIssue(Constants.NodeStatus.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = this.alertDetailRepository.findAllByOrderByIdDesc();
        ArrayList<AlertDetailModel> addValue = new ArrayList<AlertDetailModel>();
        RequestResponse returnValue = new RequestResponse();
        for (AlertDetail alertDetail : list) {
            AlertDetailModel data = new AlertDetailModel();
            data.setId(alertDetail.getId());
            data.setAlertType(alertDetail.getAlertType());
            data.setIp(alertDetail.getIp());
            data.setMessage(alertDetail.getMessage());
            data.setRead(alertDetail.isRead());
            data.setMessageDetail(alertDetail.getMessageDetail());
            data.setAlertDate(alertDetail.getAlertDate());
            data.setEventId(alertDetail.getEventId());
            addValue.add(data);
        }
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateById(Long id) {
        logger.debug("Update AlertDetail {}", (Object)id);
        RequestResponse returnValue = new RequestResponse();
        Optional alertDetail = this.alertDetailRepository.findById(id);
        if (!alertDetail.isPresent()) {
            returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("AlertDetail not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        ((AlertDetail)alertDetail.get()).setRead(true);
        this.alertDetailRepository.save(alertDetail.get());
        returnValue.setStatus(0);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("AlertDetail Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllFalse(SearchRequest searchRequest) {
        List list = searchRequest.getSortDirection().equalsIgnoreCase("descending") ? this.alertDetailRepository.findAllByRead(false, Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{searchRequest.getSortBy()})) : this.alertDetailRepository.findAllByRead(false, Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{searchRequest.getSortBy()}));
        ArrayList<AlertDetailModel> addValue = new ArrayList<AlertDetailModel>();
        RequestResponse returnValue = new RequestResponse();
        for (AlertDetail alertDetail : list) {
            AlertDetailModel data = new AlertDetailModel();
            data.setId(alertDetail.getId());
            data.setAlertType(alertDetail.getAlertType());
            data.setIp(alertDetail.getIp());
            data.setMessage(alertDetail.getMessage());
            data.setRead(alertDetail.isRead());
            data.setMessageDetail(alertDetail.getMessageDetail());
            data.setAlertDate(alertDetail.getAlertDate());
            data.setEventId(alertDetail.getEventId());
            addValue.add(data);
        }
        PagedListHolder pages = new PagedListHolder(addValue);
        pages.setPage(searchRequest.getCurrentPage().intValue());
        pages.setPageSize(searchRequest.getPageSize().intValue());
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setData((Object)pages.getPageList());
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAlertDetailByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = AlertDetailSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.alertDetailRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.alertDetailRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public int getSize() {
        List list = this.alertDetailRepository.findByRead(Boolean.valueOf(false));
        int count = list.size();
        return count;
    }

    public RequestResponse deleteById(Long id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional alertDetail = this.alertDetailRepository.findById(id);
            if (alertDetail.isPresent()) {
                this.alertDetailRepository.deleteById((Object)id);
                returnValue.setStatus(0);
                returnValue.setMessage("deleted");
                returnValue.setMessageDetail("Record deleted successfully");
            } else {
                returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Records not found");
            }
        }
        catch (Exception e) {
            returnValue.setIssue(Constants.NodeStatus.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to delete alertDetail");
            returnValue.setMessageDetail("please Contact to administrator");
        }
        return returnValue;
    }

    public RequestResponse updateAll(List<Long> ids) {
        RequestResponse returnValue = new RequestResponse();
        for (Long id : ids) {
            Optional alertDetail = this.alertDetailRepository.findById(id);
            if (!alertDetail.isPresent()) {
                returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("alertDetail not found");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            ((AlertDetail)alertDetail.get()).setRead(true);
            this.alertDetailRepository.save(alertDetail.get());
        }
        returnValue.setStatus(0);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("alertDetail Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteMultipleRecords(List<Long> ids) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Long id : ids) {
            Optional alertDetail = this.alertDetailRepository.findById(id);
            if (!alertDetail.isPresent()) continue;
            addValue.add(alertDetail.get());
        }
        this.alertDetailRepository.deleteAll(addValue);
        returnValue.setIssue(Constants.NodeStatus.OK);
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("records has been deleted");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

