/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.db.telemetry.coralnms.repository;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.IMSI;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface IMSIRepository
extends CrudRepository<IMSI, String> {
    public List<IMSI> findAll();

    public List<IMSI> findByCellIdOrderByExtensionName(String var1);

    public Optional<IMSI> findByUuid(UUID var1);

    public boolean existsByImsiNumberAndConnectedTrue(String var1);

    public List<IMSI> findAllByZone(String var1);

    public List<IMSI> findAllByOrderByDataRateEpoch();

    public List<IMSI> findByOrderByExtensionNameAscExtensionNumberAsc();

    public List<IMSI> findByIpAddress(String var1);

    public List<IMSI> findByDeviceType(String var1);

    public List<IMSI> findByPendingForSyncIsNullOrPendingForSync(Integer var1);

    public List<IMSI> findByCellId(String var1);

    @Query(value="select * from coralnms.imsi where cast(geox as decimal(12,7)) >= cast(:coordinateLeft as decimal(12,7)) and cast(geox as decimal(12,7)) <= cast(:coordinateRight as decimal(12,7)) and cast(geoy as decimal(12,7)) <= cast(:coordinateTop as decimal(12,7)) and cast(geoy as decimal(12,7)) >= cast(:coordinateBottom as decimal(12,7))", nativeQuery=true)
    public List<IMSI> getNumbersInAreaSelected(String var1, String var2, String var3, String var4);

    @Query(value="select * from coralnms.imsi where emergency_status is not NULL and emergency_status <> ''", nativeQuery=true)
    public List<IMSI> getALLEmergency();

    public Optional<IMSI> findByExtensionNumber(String var1);

    public Optional<IMSI> findByDeviceId(String var1);

    @Modifying
    @Transactional
    @Query(value="UPDATE IMSI e SET e.pendingForSync = :status WHERE e.imsiNumber = :imsiNumber")
    public void updatePendingForSyncById(String var1, Integer var2);

    @Modifying
    @Transactional
    @Query(value="UPDATE Alert a SET a.uuid = gen_random_uuid() WHERE a.uuid is null OR a.uuid = ''")
    public void updateUUID();
}

