/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.db.coralapps.entity;

import com.coraltele.telemetry.db.coralapps.key.AgentRealTimeKey;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.Subselect;

@Entity
@Subselect(value="select\n    row_number() over (order by a.name) as id, a.name as agent, split_part(t.queue, '_', 2) as queue,\n    case when a.status like '%manual%' then 'Manual' else 'Auto' end as mode,\n    a.agent_full_name as full_name, a.defaultqueue, reverse(split_part(reverse(split_part(a.contact,'@',1)),'/',1)) as contact_number,\n    a.last_offered_call, (case when a.state='In a queue call'  and m.state is null then a.dial_out else m.cid_number end) as talking_to, a.last_bridge_end, a.last_status_change , a.last_datetime , m.bridge_epoch,\n    split_part(mq.description, '_', 2) as queue_name, '' as  tier_state, m.state as member_state,\n    a.status as agent_status, a.state as agent_state,m.uuid,m.session_uuid,\n    case when lower(a.status) like 'available%' or lower(a.status) like '%break%' or lower(a.status) like '%logged in%' then 1 else 0 end as logged_in,\n    case when lower(a.status) like '%break%' then 1 else 0 end as on_break,\n    case \n        when coalesce(a.status, '') = '' then 'Activating'\n        when lower(a.status) like 'available%' then\n            case when m.state = 'Answered' \n                then 'Talk'\n            else  \n                case \n                    when coalesce(a.state, '') = '' then 'Updating'\n                    when a.state = 'Waiting' then 'Idle'\n                    when a.state = 'Idle' then 'ACW'\n                    when a.state = 'In a queue call' then 'Talk'\n                    when a.state = 'Receiving' THEN 'Ring'\n                    else a.state\n                end \n        end\n        when lower(a.status) like '%break%' then 'Break'\n        when lower(a.status) like '%logged out%' then 'Log Out'\n        when lower(a.status) like '%logged in%' then 'NTC'\n    else a.status \n    end as live_state\nfrom agents a\n    inner join (select agent, max (queue) as queue\n    from tiers\n    group by agent) t on a.\"name\" = t.agent\n    inner join callcenter.m_queue mq on t.queue = mq.systemname\n    left join (select state, serving_agent, cid_number, bridge_epoch,uuid, session_uuid\n    from members\n    where state <> 'Abandoned') m\n    on a.\"name\" = m.serving_agent\nwhere t.queue like 'ACD_%' and a.status not like '%Logged Out%'")
@Table(name="operator_real_time")
public class OperatorRealTime {
    @Id
    private Long id;
    private AgentRealTimeKey agentRealTimeKey;
    @Column(name="full_name")
    private String fullName;
    private String mode;
    @Column(name="contact_number")
    private String contactNumber;
    @Column(name="last_offered_call")
    private String lastOfferedCall;
    @Column(name="last_bridge_end")
    private String lastBridgeEnd;
    @Column(name="last_datetime")
    private LocalDateTime lastDateTime;
    @Column(name="tier_state")
    private String tierState;
    @Column(name="member_state")
    private String memberState;
    @Column(name="agent_status")
    private String agentStatus;
    @Column(name="agent_state")
    private String agentState;
    @Column(name="live_state")
    private String liveState;
    @Column(name="logged_in")
    private Integer loggedIn;
    @Column(name="on_break")
    private Integer onBreak;
    @Column(name="queue_name")
    private String queueName;
    @Column(name="talking_to")
    private String talkingTo;
    @Column(name="defaultqueue")
    private String defaultQueue;
    @Column(name="bridge_epoch")
    private Integer bridgeEpoch;
    private String uuid;
    @Column(name="session_uuid")
    private String sessionUuid;

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public AgentRealTimeKey getAgentRealTimeKey() {
        return this.agentRealTimeKey;
    }

    @Generated
    public String getFullName() {
        return this.fullName;
    }

    @Generated
    public String getMode() {
        return this.mode;
    }

    @Generated
    public String getContactNumber() {
        return this.contactNumber;
    }

    @Generated
    public String getLastOfferedCall() {
        return this.lastOfferedCall;
    }

    @Generated
    public String getLastBridgeEnd() {
        return this.lastBridgeEnd;
    }

    @Generated
    public LocalDateTime getLastDateTime() {
        return this.lastDateTime;
    }

    @Generated
    public String getTierState() {
        return this.tierState;
    }

    @Generated
    public String getMemberState() {
        return this.memberState;
    }

    @Generated
    public String getAgentStatus() {
        return this.agentStatus;
    }

    @Generated
    public String getAgentState() {
        return this.agentState;
    }

    @Generated
    public String getLiveState() {
        return this.liveState;
    }

    @Generated
    public Integer getLoggedIn() {
        return this.loggedIn;
    }

    @Generated
    public Integer getOnBreak() {
        return this.onBreak;
    }

    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    @Generated
    public String getTalkingTo() {
        return this.talkingTo;
    }

    @Generated
    public String getDefaultQueue() {
        return this.defaultQueue;
    }

    @Generated
    public Integer getBridgeEpoch() {
        return this.bridgeEpoch;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getSessionUuid() {
        return this.sessionUuid;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setAgentRealTimeKey(AgentRealTimeKey agentRealTimeKey) {
        this.agentRealTimeKey = agentRealTimeKey;
    }

    @Generated
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Generated
    public void setMode(String mode) {
        this.mode = mode;
    }

    @Generated
    public void setContactNumber(String contactNumber) {
        this.contactNumber = contactNumber;
    }

    @Generated
    public void setLastOfferedCall(String lastOfferedCall) {
        this.lastOfferedCall = lastOfferedCall;
    }

    @Generated
    public void setLastBridgeEnd(String lastBridgeEnd) {
        this.lastBridgeEnd = lastBridgeEnd;
    }

    @Generated
    public void setLastDateTime(LocalDateTime lastDateTime) {
        this.lastDateTime = lastDateTime;
    }

    @Generated
    public void setTierState(String tierState) {
        this.tierState = tierState;
    }

    @Generated
    public void setMemberState(String memberState) {
        this.memberState = memberState;
    }

    @Generated
    public void setAgentStatus(String agentStatus) {
        this.agentStatus = agentStatus;
    }

    @Generated
    public void setAgentState(String agentState) {
        this.agentState = agentState;
    }

    @Generated
    public void setLiveState(String liveState) {
        this.liveState = liveState;
    }

    @Generated
    public void setLoggedIn(Integer loggedIn) {
        this.loggedIn = loggedIn;
    }

    @Generated
    public void setOnBreak(Integer onBreak) {
        this.onBreak = onBreak;
    }

    @Generated
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Generated
    public void setTalkingTo(String talkingTo) {
        this.talkingTo = talkingTo;
    }

    @Generated
    public void setDefaultQueue(String defaultQueue) {
        this.defaultQueue = defaultQueue;
    }

    @Generated
    public void setBridgeEpoch(Integer bridgeEpoch) {
        this.bridgeEpoch = bridgeEpoch;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setSessionUuid(String sessionUuid) {
        this.sessionUuid = sessionUuid;
    }

    @Generated
    public OperatorRealTime() {
    }

    @Generated
    public OperatorRealTime(Long id, AgentRealTimeKey agentRealTimeKey, String fullName, String mode, String contactNumber, String lastOfferedCall, String lastBridgeEnd, LocalDateTime lastDateTime, String tierState, String memberState, String agentStatus, String agentState, String liveState, Integer loggedIn, Integer onBreak, String queueName, String talkingTo, String defaultQueue, Integer bridgeEpoch, String uuid, String sessionUuid) {
        this.id = id;
        this.agentRealTimeKey = agentRealTimeKey;
        this.fullName = fullName;
        this.mode = mode;
        this.contactNumber = contactNumber;
        this.lastOfferedCall = lastOfferedCall;
        this.lastBridgeEnd = lastBridgeEnd;
        this.lastDateTime = lastDateTime;
        this.tierState = tierState;
        this.memberState = memberState;
        this.agentStatus = agentStatus;
        this.agentState = agentState;
        this.liveState = liveState;
        this.loggedIn = loggedIn;
        this.onBreak = onBreak;
        this.queueName = queueName;
        this.talkingTo = talkingTo;
        this.defaultQueue = defaultQueue;
        this.bridgeEpoch = bridgeEpoch;
        this.uuid = uuid;
        this.sessionUuid = sessionUuid;
    }
}

