/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.condition.EnableRegistrationAlertProcess;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.IMSIRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.RegistrationAlertRepository;
import com.coraltele.telemetry.db.telephony.repository.ExtensionRepository;
import com.coraltele.telemetry.db.telephony.repository.LocationInSwitchRepository;
import com.coraltele.telemetry.db.telephony.repository.SipRegistrationRepository;
import com.coraltele.telemetry.thread.RegistrationAlertThread;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableRegistrationAlertProcess.class})
public class RegistrationAlertProcess {
    private static final Logger logger = LogManager.getLogger(RegistrationAlertProcess.class);
    private static final Integer MAX_THREADS = 1;
    @Autowired
    private RegistrationAlertRepository registrationAlertRepository;
    @Autowired
    private ExtensionRepository extensionRepository;
    @Autowired
    private LocationInSwitchRepository locationInSwitchRepository;
    @Autowired
    private SipRegistrationRepository sipRegistrationRepository;
    @Autowired
    private SCADAAssetRepository scadaAssetRepository;
    @Autowired
    private AlertRepository alertRepository;
    @Autowired
    private IMSIRepository imsiRepository;
    ExecutorService threadPool = Executors.newFixedThreadPool(1);

    @Scheduled(fixedRate=5000L)
    public void startCounterCollection() {
        logger.info("Maximum Threads : {}, Active Thread {} ", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        Integer threadsStarted = 0;
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            Integer n = threadsStarted;
            Integer n2 = threadsStarted = Integer.valueOf(threadsStarted + 1);
            logger.info("Starting Registration Alert Thread");
            this.threadPool.execute((Runnable)new RegistrationAlertThread(this.registrationAlertRepository, this.extensionRepository, this.sipRegistrationRepository, this.locationInSwitchRepository, this.imsiRepository, this.scadaAssetRepository, this.alertRepository));
        }
        logger.info("{} RegistrationAlert Thread started", (Object)threadsStarted);
    }
}

