/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.DeviceModel.service;

import com.coraltele.telemetry.db.telemetry.main.entity.DeviceModel;
import com.coraltele.telemetry.db.telemetry.main.repository.DeviceModelRepository;
import com.coraltele.telemetry.model.DeviceDetailModel;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceModelService {
    private static final Logger logger = LoggerFactory.getLogger(DeviceModelService.class);
    @Autowired
    private DeviceModelRepository repository;

    public DeviceModel updateDeviceFromDto(DeviceDetailModel deviceDetail) {
        Optional optionalDevice = this.repository.findByProductClass(deviceDetail.getProductClass());
        if (optionalDevice.isPresent()) {
            DeviceModel deviceEntity = (DeviceModel)optionalDevice.get();
            deviceEntity.setOui(deviceDetail.getOui());
            deviceEntity.setManufacturer(deviceDetail.getManufacturer());
            deviceEntity.setFirmwareVersion(deviceDetail.getFirmware_version());
            deviceEntity.setConfigurationVersion(deviceDetail.getConfiguration_version());
            DeviceModel updatedDevice = (DeviceModel)this.repository.save((Object)deviceEntity);
            logger.info("Device model updated: {}", (Object)updatedDevice);
            return updatedDevice;
        }
        logger.warn("Device with productClass {} not found.", (Object)deviceDetail.getProductClass());
        return null;
    }
}

