/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.service;

import com.coraltele.telemetry.db.telemetry.main.entity.RegistrationAlert;
import com.coraltele.telemetry.db.telemetry.main.repository.RegistrationAlertRepository;
import com.coraltele.telemetry.model.ExtensionRegistrationDetailsModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ExtensionRegistrationDetailsService {
    private static final Logger logger = LogManager.getLogger(ExtensionRegistrationDetailsService.class);
    @Autowired
    private RegistrationAlertRepository registrationAlertRepository;

    public List<ExtensionRegistrationDetailsModel> getExtensionDetails() {
        ArrayList<ExtensionRegistrationDetailsModel> returnValue = new ArrayList<ExtensionRegistrationDetailsModel>();
        try {
            List registeredExtension = (List)this.registrationAlertRepository.findAll();
            if (registeredExtension.isEmpty()) {
                logger.info("Extension List is Empty.");
            } else {
                for (RegistrationAlert extension : registeredExtension) {
                    ExtensionRegistrationDetailsModel extensionValue = new ExtensionRegistrationDetailsModel();
                    extensionValue.setExtension(extension.getExtension());
                    extensionValue.setExtensionType(extension.getExtensionType());
                    extensionValue.setExtensionStatus(Boolean.TRUE.equals(extension.getExtensionStatus()) ? "Registered" : "Not Registered");
                    extensionValue.setAlertStatusUpdated(extension.getAlertStatusUpdatedEpoch());
                    extensionValue.setLastModified(extension.getAlertStatusUpdatedEpoch());
                    extensionValue.setAlertStatusUpdated(extension.getAlertStatusUpdatedEpoch());
                    extensionValue.setRegistrationExpires(extension.getRegistrationExpiresEpoch());
                    extensionValue.setConnectionAlertEpoch(extension.getConnectionAlertEpoch());
                    extensionValue.setPort(Integer.valueOf(extension.getPort() == null ? 0 : extension.getPort()));
                    extensionValue.setIpAddress(StringUtils.hasText((String)extension.getIpAddress()) ? extension.getIpAddress() : "");
                    returnValue.add(extensionValue);
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to compute registered extension {} {}", (Object)e.getMessage(), (Object)e);
        }
        return returnValue;
    }
}

