/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.condition.EnableICC4HealthCheck;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.CardRepository;
import com.coraltele.telemetry.service.coralnms.scada_assets.model.SCADAAssetModel;
import com.coraltele.telemetry.service.coralnms.scada_assets.service.SCADAAssetService;
import com.coraltele.telemetry.thread.ICC4Thread;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableICC4HealthCheck.class})
public class MediaGatewayHealthProcess {
    private static final Logger logger = LogManager.getLogger(MediaGatewayHealthProcess.class);
    @Autowired
    SCADAAssetService scadaAssetService;
    @Autowired
    CardRepository cardRepository;
    private List<ICC4Thread> icc4Gateways = new ArrayList();

    @PostConstruct
    public void startService() {
        logger.info("Starting Media gateway health monitoring service");
        for (SCADAAssetModel mediaGateway : this.scadaAssetService.findAll()) {
            if (mediaGateway.getCategory() == null || !mediaGateway.getCategory().equalsIgnoreCase("icc4") && !mediaGateway.getCategory().equalsIgnoreCase("icc3")) continue;
            logger.info("Started health monitoring for {} {}", (Object)mediaGateway.getIpAddress(), (Object)mediaGateway.getId());
            this.icc4Gateways.add(new ICC4Thread(mediaGateway.getIpAddress(), mediaGateway.getNodeId(), mediaGateway, mediaGateway.getOid(), mediaGateway.getNodeName(), this.cardRepository, this.scadaAssetService));
        }
    }
}

