/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.Category;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.CategoryRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.AlertHistory;
import com.coraltele.telemetry.db.telemetry.main.entity.Severity;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertHistoryRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.SeverityRepository;
import com.coraltele.telemetry.helper.SendSms;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SendSmsThread
implements Runnable {
    private static final Logger logger = LogManager.getLogger(SendSmsThread.class);
    private SendSms sendSms;
    private CategoryRepository categoryRepository;
    private AlertHistoryRepository alertHistoryRepository;
    private String smsText;
    private String smsUrl;
    String smsUrlDataReplace;
    String smsTextDataReplace;
    private SeverityRepository severityRepository;

    public SendSmsThread(SeverityRepository severityRepository, AlertHistoryRepository alertHistoryRepository, SendSms sendSms, CategoryRepository categoryRepository) {
        this.smsText = this.sendSms.smsText;
        this.smsUrl = this.sendSms.smsUrl;
        this.severityRepository = severityRepository;
        this.alertHistoryRepository = alertHistoryRepository;
        this.sendSms = sendSms;
        this.categoryRepository = categoryRepository;
    }

    @Override
    public void run() {
        logger.info("Starting thread for send sms of NMS alerts");
        try {
            while (true) {
                List alertHistories = (List)this.alertHistoryRepository.findAll();
                for (AlertHistory alert : alertHistories) {
                    logger.info("Processing alert for Sending Sms { }", (Object)alert);
                    Optional categoryValue = this.categoryRepository.findByCode(alert.getCategoryCode());
                    Optional severityList = this.severityRepository.findBySeverityLevel(alert.getSeverity());
                    if (categoryValue.isPresent()) {
                        if (Boolean.TRUE.equals(((Category)categoryValue.get()).getSendSms())) {
                            String mobileNo = ((Category)categoryValue.get()).getMobileNo();
                            String[] mobileNoList = mobileNo.split(",");
                            if (this.smsText != null && this.smsUrl != null) {
                                this.smsTextDataReplace = this.smsText.replace("##IPAddress", alert.getIpAddress()).replace("##ServiceCode", alert.getServiceCode()).replace("##Severity", severityList.isPresent() ? ((Severity)severityList.get()).getSeverityName() : Integer.toString(alert.getSeverity())).replace("##CategoryCode", ((Category)categoryValue.get()).getCode()).replace("##nodeName", alert.getName());
                                for (String clientMobileNo : mobileNoList) {
                                    this.smsUrlDataReplace = this.smsUrl.replace("##MobileNo", clientMobileNo).replace("##smsText", this.smsTextDataReplace);
                                    if (this.sendSms.sendSmsUrl(this.smsUrlDataReplace)) {
                                        logger.info("Sms Alert sent successfully:{}", (Object)clientMobileNo);
                                        alert.setSmsAlertSend(Integer.valueOf(1));
                                        this.alertHistoryRepository.save((Object)alert);
                                        continue;
                                    }
                                    logger.info("Send sms failed, Status reverted. System will retry sending sms:{}", (Object)clientMobileNo);
                                }
                                continue;
                            }
                            alert.setSmsAlertSend(Integer.valueOf(-3));
                            logger.info("where smsText and smsUrl is not Present.");
                            continue;
                        }
                        alert.setSmsAlertSend(Integer.valueOf(-1));
                        logger.info("sms is not send Successfully {}", (Object)alert.getCategoryCode());
                        continue;
                    }
                    alert.setSmsAlertSend(Integer.valueOf(-2));
                    logger.info("Category not found {}", (Object)alert.getCategoryCode());
                }
                Thread.sleep(2000L);
            }
        }
        catch (Exception e) {
            logger.info("Error in send sms thread for NMS Alerts. Closing thread, thread will be restarted in few seconds", (Throwable)e);
            Thread.currentThread().interrupt();
            return;
        }
    }
}

