/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.polygon.route.service;

import com.coraltele.telemetry.db.telemetry.main.entity.Route;
import com.coraltele.telemetry.db.telemetry.main.entity.UserCoordinate;
import com.coraltele.telemetry.db.telemetry.main.repository.RouteRepository;
import com.coraltele.telemetry.db.telemetry.main.specification.RouteSpecification;
import com.coraltele.telemetry.db.users.main.entity.ShiftTime;
import com.coraltele.telemetry.db.users.main.entity.UserShift;
import com.coraltele.telemetry.db.users.main.repository.ShiftTimeRepository;
import com.coraltele.telemetry.db.users.main.repository.UserShiftRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.DateFormatUtility;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.helper.ReturnField;
import com.coraltele.telemetry.model.InputIdModel;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.model.SearchResponse;
import com.coraltele.telemetry.service.coralnms.geo_pin.service.GeoTaggingService;
import com.coraltele.telemetry.service.main.eventNotification.model.EventNotifyModel;
import com.coraltele.telemetry.service.main.eventNotification.service.EventNotifyService;
import com.coraltele.telemetry.service.main.polygon.area.model.CoordinateModel;
import com.coraltele.telemetry.service.main.polygon.route.model.RouteModel;
import com.coraltele.telemetry.service.main.polygon.route.model.ShiftTimeModel;
import com.coraltele.telemetry.service.main.polygon.route.model.UserCoordinateModel;
import com.coraltele.telemetry.service.main.service.UserCoordinateService;
import com.coraltele.telemetry.service.user.service.UserService;
import java.security.Principal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;

@Service
public class RouteService {
    private static final Logger logger = LogManager.getLogger(RouteService.class);
    @Autowired
    RouteRepository routeRepository;
    @Autowired
    UserShiftRepository userShiftRepository;
    @Autowired
    GeoTaggingService geoTaggingService;
    @Autowired
    UserService userService;
    @Autowired
    ShiftTimeRepository shiftTimeRepository;
    @Autowired
    EventNotifyService eventNotifyService;
    @Autowired
    UserCoordinateService userCoordinateService;

    public RequestResponse createData(RouteModel data, Principal principal) {
        logger.debug("Creating new route: {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional routeOptional = this.routeRepository.findByName(data.getName());
            if (routeOptional.isPresent()) {
                returnValue.setIssue(Constants.NodeStatus.ERROR);
                returnValue.setMessage("Route Creation Failed");
                returnValue.setMessageDetail("Route with name '" + data.getName() + "' already exists, Please Enter a new Name");
                logger.warn(returnValue.getMessageDetail());
                return returnValue;
            }
            Route route = new Route();
            route.setCreatedBy(principal.getName());
            route.setCreatedOn(Long.valueOf(Instant.now().getEpochSecond()));
            route.setName(data.getName());
            route.setType(data.getShapeId());
            route.setProject("kumbh");
            GeometryFactory geometryFactory = new GeometryFactory();
            Coordinate[] coordinates = (Coordinate[])data.getCoordinates().stream().map(coord -> new Coordinate(Double.parseDouble(coord.getLongitude().trim()), Double.parseDouble(coord.getLatitude().trim()))).toArray(Coordinate[]::new);
            LineString serviceRoute = geometryFactory.createLineString(coordinates);
            logger.info("Generated LineString WKT: " + serviceRoute.toText());
            route.setCoordinate(serviceRoute);
            this.routeRepository.save((Object)route);
            ReturnField field = new ReturnField();
            field.setId(route.getId().intValue());
            field.setDescription(route.getName());
            returnValue.setIssue(Constants.NodeStatus.OK);
            returnValue.setMessage("OK");
            returnValue.setData((Object)field);
            returnValue.setMessageDetail("Route saved successfully");
            logger.info(returnValue.getMessage());
        }
        catch (IllegalArgumentException e) {
            logger.error("Invalid argument: {}", (Object)e.getMessage());
        }
        catch (JpaSystemException e) {
            logger.error("JPA system error: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error("Unexpected error: {}", (Object)e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateById(RouteModel data, Principal principal) {
        logger.debug("Update Route {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional route = this.routeRepository.findById((Object)data.getId());
        if (!route.isPresent()) {
            returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Route Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        try {
            if (!data.getName().equals(((Route)route.get()).getName()) && this.routeRepository.existsByName(data.getName())) {
                returnValue.setIssue(Constants.NodeStatus.ERROR);
                returnValue.setMessage("Route Update Failed");
                returnValue.setMessageDetail("Route with name '" + data.getName() + "' already exists");
                return returnValue;
            }
            if (data.getName() != null) {
                ((Route)route.get()).setName(data.getName());
            }
            if (data.getShapeId() != null) {
                ((Route)route.get()).setType(data.getShapeId());
            }
            if (data.getCoordinates() != null) {
                GeometryFactory geometryFactory = new GeometryFactory();
                Coordinate[] coordinates = (Coordinate[])data.getCoordinates().stream().map(coord -> new Coordinate(Double.parseDouble(coord.getLongitude().trim()), Double.parseDouble(coord.getLatitude().trim()))).toArray(Coordinate[]::new);
                LineString serviceRoute = geometryFactory.createLineString(coordinates);
                logger.info("Generated LineString WKT: " + serviceRoute.toText());
                ((Route)route.get()).setCoordinate(serviceRoute);
            }
            ((Route)route.get()).setUpdatedBy(principal.getName());
            ((Route)route.get()).setUpdatedOn(Long.valueOf(Instant.now().getEpochSecond()));
            this.routeRepository.save(route.get());
            try {
                List userList = this.userShiftRepository.findByRouteId(data.getId());
                if (!userList.isEmpty()) {
                    long epoch = System.currentTimeMillis() / 1000L;
                    for (UserShift user : userList) {
                        EventNotifyModel eventData = new EventNotifyModel();
                        eventData.setReadByUser(Boolean.valueOf(false));
                        eventData.setEventData((Object)("Route Updated, Confirm coordinates of area:" + ((Route)route.get()).getName()));
                        eventData.setEventId(Constants.EventStatus.USER_ROUTE_UPDATE_EVENT);
                        eventData.setEventSeverity(Integer.valueOf(1));
                        eventData.setEventUUID(UUID.randomUUID().toString());
                        eventData.setEventMessage("Route updated with new data");
                        eventData.setEventEpoch(Long.valueOf(epoch));
                        eventData.setEventDestination(user.getUserId());
                        eventData.setEventSource(principal.getName());
                        this.eventNotifyService.sendNotification(eventData);
                        logger.info("Route updated notification send to user:{}", (Object)user.getUserId());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info("Unable to send event on area update:{}", (Object)e.getMessage());
            }
            returnValue.setIssue(Constants.NodeStatus.OK);
            returnValue.setMessage("Updated");
            returnValue.setMessageDetail("Route Updated Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (IllegalArgumentException e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            logger.error("Invalid argument: {}", (Object)e.getMessage());
        }
        catch (JpaSystemException e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            logger.error("JPA system error: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            logger.error("Unexpected error: {}", (Object)e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getId()) {
            Optional routeData = this.routeRepository.findById((Object)ids);
            if (routeData.isPresent()) {
                addValue.add(routeData.get());
                List userShiftRoute = this.userShiftRepository.findByRouteId(((Route)routeData.get()).getId());
                for (UserShift row : userShiftRoute) {
                    row.setRouteId(null);
                    this.userShiftRepository.save((Object)row);
                }
                continue;
            }
            returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.routeRepository.deleteAll(addValue);
        try {
            List list = this.userShiftRepository.findByRouteIdIn(data.getId());
            if (!list.isEmpty()) {
                for (UserShift user : list) {
                    LocalDateTime currentDateTime = LocalDateTime.now();
                    LocalDateTime startOfDay = currentDateTime.toLocalDate().atStartOfDay();
                    long epoch = startOfDay.toEpochSecond(ZoneOffset.UTC);
                    this.userShiftRepository.findById((Object)user.getId()).ifPresent(assignedUser -> {
                        EventNotifyModel eventData = new EventNotifyModel();
                        eventData.setReadByUser(Boolean.valueOf(false));
                        eventData.setEventData((Object)("Route Deleted, please verify the coordinates:" + assignedUser.getRouteId()));
                        eventData.setEventId(Constants.EventStatus.USER_ROUTE_DELETE_EVENT);
                        eventData.setEventSeverity(Integer.valueOf(1));
                        eventData.setEventUUID(UUID.randomUUID().toString());
                        eventData.setEventMessage("Route deleted");
                        eventData.setEventEpoch(Long.valueOf(epoch));
                        eventData.setEventDestination(user.getUserId());
                        eventData.setEventSource(principal.getName());
                        this.eventNotifyService.sendNotification(eventData);
                    });
                    logger.info("Route deleted notification send to user:{}", (Object)user.getUserId());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("Unable to send event on Route delete:{}", (Object)e.getMessage());
        }
        returnValue.setIssue(Constants.NodeStatus.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteByType(InputIdModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Object ids : data.getStringId()) {
            Optional areaData = this.routeRepository.findByType((String)ids);
            if (areaData.isPresent()) {
                addValue.add(areaData.get());
                continue;
            }
            returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.routeRepository.deleteAll(addValue);
        try {
            ArrayList<Integer> list1 = new ArrayList<Integer>();
            for (String id : data.getStringId()) {
                Optional listOfArea = this.routeRepository.findByType(id);
                list1.add(((Route)listOfArea.get()).getId());
            }
            List list = this.userShiftRepository.findByRouteIdIn(list1);
            if (!list.isEmpty()) {
                for (UserShift user : list) {
                    LocalDateTime currentDateTime = LocalDateTime.now();
                    LocalDateTime startOfDay = currentDateTime.toLocalDate().atStartOfDay();
                    long epoch = startOfDay.toEpochSecond(ZoneOffset.UTC);
                    this.userShiftRepository.findById((Object)user.getId()).ifPresent(assignedUser -> {
                        EventNotifyModel eventData = new EventNotifyModel();
                        Optional routeTypeOptional = this.routeRepository.findById((Object)assignedUser.getId());
                        eventData.setReadByUser(Boolean.valueOf(false));
                        eventData.setEventData((Object)("Route Deleted, please verify the ROUTE:" + ((Route)routeTypeOptional.get()).getName()));
                        eventData.setEventId(Constants.EventStatus.USER_ROUTE_DELETE_EVENT);
                        eventData.setEventSeverity(Integer.valueOf(1));
                        eventData.setEventUUID(UUID.randomUUID().toString());
                        eventData.setEventMessage("Route deleted");
                        eventData.setEventEpoch(Long.valueOf(epoch));
                        eventData.setEventDestination(user.getUserId());
                        eventData.setEventSource(principal.getName());
                        this.eventNotifyService.sendNotification(eventData);
                    });
                    logger.info("Route deleted notification send to user:{}", (Object)user.getUserId());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("Unable to send event on Route delete:{}", (Object)e.getMessage());
            returnValue.setIssue(Constants.NodeStatus.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Records Deleted Successfully");
        }
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        List areas = this.routeRepository.findAll();
        ArrayList<RouteModel> areaModels = new ArrayList<RouteModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Route area : areas) {
            RouteModel model = new RouteModel();
            model.setId(area.getId());
            model.setName(area.getName());
            model.setShapeId(area.getType());
            if (area.getCoordinate() != null) {
                ArrayList<CoordinateModel> coordinateModels = new ArrayList<CoordinateModel>();
                for (Coordinate coordinate : area.getCoordinate().getCoordinates()) {
                    CoordinateModel coordModel = new CoordinateModel();
                    coordModel.setLongitude(String.valueOf(coordinate.x));
                    coordModel.setLatitude(String.valueOf(coordinate.y));
                    coordinateModels.add(coordModel);
                }
                model.setCoordinates(coordinateModels);
            }
            areaModels.add(model);
        }
        returnValue.setIssue(Constants.NodeStatus.OK);
        returnValue.setMessage("OK");
        returnValue.setData(areaModels);
        logger.info("Fetched {} route successfully", (Object)areaModels.size());
        return returnValue;
    }

    public Route getRouteData(Integer id) {
        Optional data = this.routeRepository.findById((Object)id);
        if (data.isPresent()) {
            return (Route)data.get();
        }
        return null;
    }

    public RequestResponse getAllRoutes(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = RouteSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "name" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "name" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.routeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.routeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<RouteModel> entityToModelConversion(List<Route> Routes2) {
        ArrayList<RouteModel> addValue = new ArrayList<RouteModel>();
        for (Route row : Routes2) {
            RouteModel data = new RouteModel();
            data.setId(row.getId());
            data.setName(row.getName());
            data.setShapeId(row.getType());
            if (row.getCoordinate() != null) {
                ArrayList<CoordinateModel> coordinateModels = new ArrayList<CoordinateModel>();
                for (Coordinate coordinate : row.getCoordinate().getCoordinates()) {
                    CoordinateModel coordModel = new CoordinateModel();
                    coordModel.setLongitude(String.valueOf(coordinate.x));
                    coordModel.setLatitude(String.valueOf(coordinate.y));
                    coordinateModels.add(coordModel);
                }
                data.setCoordinates(coordinateModels);
            }
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getRouteUser(Integer routeId, String shapeId) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional routeData;
            ArrayList<UserCoordinateModel> data = new ArrayList<UserCoordinateModel>();
            List routeShiftData = new ArrayList();
            if (routeId != null) {
                routeShiftData = this.userShiftRepository.findByRouteId(routeId);
            } else if (shapeId != null && (routeData = this.routeRepository.findByType(shapeId)).isPresent()) {
                routeShiftData = this.userShiftRepository.findByRouteId(((Route)routeData.get()).getId());
            }
            if (!routeShiftData.isEmpty()) {
                for (UserShift route : routeShiftData) {
                    UserCoordinateModel row = new UserCoordinateModel();
                    row.setUserId(route.getUserId());
                    if (this.userCoordinateService.checkUserExist(route.getUserId())) {
                        UserCoordinate userCoordinate = this.userCoordinateService.getUserCoordinate(route.getUserId());
                        row.setUserLat(userCoordinate.getGeoX());
                        row.setUserLong(userCoordinate.getGeoY());
                    } else {
                        this.userCoordinateService.createUser(route.getUserId());
                        row.setUserLat("0");
                        row.setUserLong("0");
                    }
                    Optional shiftData = this.shiftTimeRepository.findById((Object)route.getShiftId());
                    if (shiftData.isPresent()) {
                        ShiftTimeModel model = new ShiftTimeModel();
                        model.setId(((ShiftTime)shiftData.get()).getId());
                        model.setName(((ShiftTime)shiftData.get()).getName());
                        model.setFromDateTime(DateFormatUtility.fromEpochSeconds((Long)((ShiftTime)shiftData.get()).getFromDateTime()));
                        model.setToDateTime(DateFormatUtility.fromEpochSeconds((Long)((ShiftTime)shiftData.get()).getToDateTime()));
                        row.setShiftData(model);
                    }
                    data.add(row);
                }
                returnValue.setIssue(Constants.NodeStatus.OK);
                returnValue.setStatus(0);
                returnValue.setMessage("list of users");
                returnValue.setData(data);
            } else {
                returnValue.setIssue(Constants.NodeStatus.ERROR);
                returnValue.setStatus(2);
                returnValue.setMessage("No users found for the selected route or shape");
            }
        }
        catch (Exception e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setStatus(2);
            returnValue.setMessage("Unable to find route of user");
            returnValue.setMessageDetail("Contact to Administrator");
        }
        return returnValue;
    }
}

