/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.sensor.service;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.Sensor;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SensorRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.Alert;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertRepository;
import com.coraltele.telemetry.service.coralnms.sensor.model.SensorModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SensorService {
    @Autowired
    private SensorRepository sensorRepository;
    @Autowired
    private SCADAAssetRepository scadaAssetRepository;
    @Autowired
    private AlertRepository alertRepository;

    public String create(SensorModel data) {
        Sensor sensor = new Sensor();
        sensor.setAsset(data.getAsset());
        sensor.setProvisioningId(data.getProvisioningId());
        sensor.setSensorType(data.getSensorType());
        sensor.setSensorURL(data.getSensorURL());
        sensor.setParams(data.getParams());
        sensor.setUpdateEpoch(data.getUpdateEpoch());
        sensor.setUpdateInterval(data.getUpdateInterval());
        this.sensorRepository.save((Object)sensor);
        return "data added successfully";
    }

    public List<SensorModel> getById(Long id) {
        ArrayList<SensorModel> addValue = new ArrayList<SensorModel>();
        Optional sensor = this.sensorRepository.findById(id);
        if (sensor.isPresent()) {
            SensorModel data = new SensorModel();
            data.setId(((Sensor)sensor.get()).getId());
            data.setProvisioningId(((Sensor)sensor.get()).getProvisioningId());
            data.setSensorType(((Sensor)sensor.get()).getSensorType());
            data.setSensorURL(((Sensor)sensor.get()).getSensorURL());
            data.setParams(((Sensor)sensor.get()).getParams());
            data.setUpdateEpoch(((Sensor)sensor.get()).getUpdateEpoch());
            data.setUpdateInterval(((Sensor)sensor.get()).getUpdateInterval());
            addValue.add(data);
            return addValue;
        }
        return null;
    }

    public List<SensorModel> getAssetSensor(String assetId) {
        List<Object> returnValue = null;
        Optional asset = this.scadaAssetRepository.findByUuid(UUID.fromString(assetId));
        returnValue = asset.isPresent() ? this.getAssetSensor(((SCADAAsset)asset.get()).getId()) : new ArrayList<SensorModel>();
        return returnValue;
    }

    public List<SensorModel> getAssetSensor(Long assetId) {
        ArrayList<SensorModel> addValue = new ArrayList<SensorModel>();
        Boolean isICMPAdded = false;
        Optional asset = this.scadaAssetRepository.findById(assetId);
        if (asset.isPresent()) {
            List list = this.alertRepository.findByAssetId(assetId);
            for (Alert alert : list) {
                if (alert.getServiceCode().equalsIgnoreCase("ICMP") && Boolean.TRUE.equals(isICMPAdded)) continue;
                SensorModel data = new SensorModel();
                data.setId(alert.getId());
                data.setProvisioningId(alert.getId().toString());
                data.setSensorType(alert.getAlias());
                data.setSensorURL("");
                data.setParams("");
                data.setUpdateEpoch(alert.getAlertClosedOn() == null ? alert.getAlertGeneratedOn() : alert.getAlertClosedOn());
                data.setUpdateInterval(Integer.valueOf(0));
                data.setXCoordinate(Integer.valueOf(-1));
                data.setYCoordinate(Integer.valueOf(7));
                data.setSensorCode(alert.getServiceCode());
                data.setSensorStatus(Integer.valueOf(alert.isStatus() ? 0 : 2));
                if (StringUtils.hasLength((String)alert.getStatusDetail())) {
                    data.setSensorStatusName(alert.getStatusDetail());
                } else {
                    data.setSensorStatusName(alert.isStatus() ? "ok" : "error");
                }
                addValue.add(data);
                if (!alert.getServiceCode().equalsIgnoreCase("ICMP")) continue;
                isICMPAdded = true;
            }
            if (addValue.isEmpty()) {
                SensorModel data = new SensorModel();
                data.setId(((SCADAAsset)asset.get()).getId());
                data.setProvisioningId(((SCADAAsset)asset.get()).getId().toString());
                data.setSensorType("ICMP");
                data.setSensorURL("");
                data.setParams("");
                data.setUpdateEpoch(Long.valueOf(0L));
                data.setUpdateInterval(Integer.valueOf(0));
                data.setXCoordinate(Integer.valueOf(-1));
                data.setYCoordinate(Integer.valueOf(-1));
                data.setSensorCode("ICMP");
                data.setSensorStatus(Integer.valueOf(0));
                data.setSensorStatusName("No Alerts");
                addValue.add(data);
            }
        }
        return addValue;
    }

    public List<SensorModel> getAll() {
        List list = (List)this.sensorRepository.findAll();
        ArrayList<SensorModel> addValue = new ArrayList<SensorModel>();
        for (Sensor sensor : list) {
            SensorModel data = new SensorModel();
            data.setId(sensor.getId());
            data.setProvisioningId(sensor.getProvisioningId());
            data.setSensorType(sensor.getSensorType());
            data.setSensorURL(sensor.getSensorURL());
            data.setParams(sensor.getParams());
            data.setUpdateEpoch(sensor.getUpdateEpoch());
            data.setUpdateInterval(sensor.getUpdateInterval());
            data.setXCoordinate(sensor.getXCoordinate());
            data.setYCoordinate(sensor.getYCoordinate());
            data.setSensorCode(sensor.getSensorCode());
            addValue.add(data);
        }
        return addValue;
    }

    public String update(SensorModel data, Long id) {
        Optional sensor = this.sensorRepository.findById(id);
        if (sensor.isPresent()) {
            ((Sensor)sensor.get()).setAsset(((Sensor)sensor.get()).getAsset());
            ((Sensor)sensor.get()).setProvisioningId(data.getProvisioningId());
            ((Sensor)sensor.get()).setSensorType(data.getSensorType());
            ((Sensor)sensor.get()).setSensorURL(data.getSensorURL());
            ((Sensor)sensor.get()).setParams(data.getParams());
            ((Sensor)sensor.get()).setUpdateEpoch(data.getUpdateEpoch());
            ((Sensor)sensor.get()).setUpdateInterval(data.getUpdateInterval());
            this.sensorRepository.save(sensor.get());
            return "data added successfully";
        }
        return null;
    }
}

