/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.dashboard.service;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.Dashboard;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.DashboardWidget;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.Location;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.WidgetList;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.DashboardRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.DashboardWidgetRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.LocationRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.WidgetListRepository;
import com.coraltele.telemetry.db.users.main.entity.UserLocation;
import com.coraltele.telemetry.db.users.main.repository.UserLocationRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.service.coralnms.dashboard.model.Asset;
import com.coraltele.telemetry.service.coralnms.dashboard.model.LocationModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DashboardService {
    @Autowired
    private LocationRepository locationRepository;
    @Autowired
    private DashboardRepository dashboardRepository;
    @Autowired
    private WidgetListRepository widgetRepository;
    @Autowired
    private DashboardWidgetRepository dashboardWidgetRepository;
    @Autowired
    private SCADAAssetRepository scadaAssetRepository;
    @Autowired
    private UserLocationRepository userLocationRepository;

    public List<LocationModel> getLocations(String userName) {
        List locations = null;
        if (Constants.ENABLE_LOCATION_FILTER.booleanValue()) {
            locations = new ArrayList();
            for (UserLocation userLocation : this.userLocationRepository.findByUsername(userName)) {
                Optional row = this.locationRepository.findByCode(userLocation.getLocationCode());
                if (!row.isPresent()) continue;
                locations.add(row.get());
            }
        } else {
            locations = this.locationRepository.findAll();
        }
        ArrayList<LocationModel> returnValue = new ArrayList<LocationModel>();
        for (Location location : locations) {
            returnValue.add(new LocationModel(location.getId(), location.getName(), location.getUuid(), location.getParentLocation() == null ? "" : location.getParentLocation().getName(), location.getCode(), location.getBackgroundImageURL(), location.getXcoordinate(), location.getYcoordinate(), location.getConfiguration()));
        }
        return returnValue;
    }

    public List<Dashboard> getDashboards() {
        return this.dashboardRepository.findAll();
    }

    public List<WidgetList> getWidgets() {
        return this.widgetRepository.findAll();
    }

    public List<DashboardWidget> getDashBoardWidget(Integer dashboardId) {
        List<Object> returnValue = new ArrayList<DashboardWidget>();
        Optional dashboard = this.dashboardRepository.findById((Object)dashboardId);
        if (dashboard.isPresent()) {
            returnValue = this.dashboardWidgetRepository.findByDashboard((Dashboard)dashboard.get());
        }
        return returnValue;
    }

    public List<Asset> getAssets() {
        ArrayList<Asset> returnValue = new ArrayList<Asset>();
        this.scadaAssetRepository.findByOrderBySeverityDescSeverityUpdatedOnAsc().forEach(asset -> returnValue.add(new Asset(asset.getId(), asset.getNodeName(), asset.getIpAddress(), asset.getCategory(), asset.getLocation(), asset.getSeverity(), asset.getSeverityUpdatedOn())));
        return returnValue;
    }
}

