/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.service.coralnms.geo_pin.model.ChannelMessage;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class HTTPHelper {
    private static final Logger logger = LogManager.getLogger(HTTPHelper.class);

    private HTTPHelper() {
    }

    public static String sendDeviceAction(String action, String imsi) {
        String result = "";
        try {
            HttpPost post = new HttpPost("http://127.0.0.1:8996/app/v2/device/action/" + action + "/" + imsi);
            post.addHeader("content-type", "application/json");
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
        }
        catch (Exception E) {
            return null;
        }
        return result;
    }

    public static String sendToWebSocket(ChannelMessage message) {
        String result = "";
        try {
            String url = Constants.WEB_SOCKET_URL + "/sendEvent";
            logger.info("Send event to websocket {}", (Object)url);
            HttpPost post = new HttpPost(url);
            ObjectMapper objectMapper = new ObjectMapper();
            String data = objectMapper.writeValueAsString((Object)message);
            post.addHeader("content-type", "application/json");
            StringEntity requestEntity = new StringEntity(data, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)requestEntity);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
        }
        catch (Exception E) {
            return null;
        }
        return result;
    }

    public static String getRequestIp(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-ORIG-IP");
        if (xForwardedFor != null) {
            logger.info("Request IP Address is:{},{}", (Object)xForwardedFor, (Object)xForwardedFor.split(",")[0]);
            return xForwardedFor.split(",")[0];
        }
        return "Invalid IP";
    }
}

