/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.db.telemetry.coralnms.repository;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.Outage;
import com.coraltele.telemetry.model.interface_model.IAssetSummaryModel;
import com.coraltele.telemetry.model.interface_model.IDailyOutageModel;
import java.util.List;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;

@Repository
public interface OutageRepository
extends CrudRepository<Outage, Long> {
    public List<Outage> findAll();

    public List<Outage> findByNodeIdAndServiceNameAndStatus(Integer var1, String var2, boolean var3);

    @Query(value="SELECT category, COUNT(*) as value FROM coralnms.outage GROUP BY category ORDER BY category", nativeQuery=true)
    public List<IAssetSummaryModel> categoryCountAll();

    @Query(value="SELECT category, COUNT(*) as value FROM coralnms.outage where outage_closed_on is null GROUP BY category ORDER BY category", nativeQuery=true)
    public List<IAssetSummaryModel> categoryCountPending();

    @Query(value="SELECT to_char(to_timestamp(outage_reported_on),'yyyy-MM-dd') as day, COUNT(*) as value FROM coralnms.outage where to_char(to_timestamp(outage_reported_on),'yyyy-MM-dd') between ?1 and ?2 GROUP BY day ORDER BY day", nativeQuery=true)
    public List<IDailyOutageModel> calendarOutput(String var1, String var2);
}

