/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.IMSI;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.IMSIRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.Alert;
import com.coraltele.telemetry.db.telemetry.main.entity.RegistrationAlert;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.RegistrationAlertRepository;
import com.coraltele.telemetry.db.telephony.main.entity.SipRegistrations;
import com.coraltele.telemetry.db.telephony.pbx.entity.Extension;
import com.coraltele.telemetry.db.telephony.repository.ExtensionRepository;
import com.coraltele.telemetry.db.telephony.repository.LocationInSwitchRepository;
import com.coraltele.telemetry.db.telephony.repository.SipRegistrationRepository;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class RegistrationAlertThread
implements Runnable {
    private static final Logger logger = LogManager.getLogger(RegistrationAlertThread.class);
    private RegistrationAlertRepository registrationAlertRepository;
    private ExtensionRepository extensionRepository;
    private LocationInSwitchRepository locationInSwitchRepository;
    private SipRegistrationRepository sipRegistrationRepository;
    private IMSIRepository imsiRepository;
    private SCADAAssetRepository scadaAssetRepository;
    private AlertRepository alertRepository;
    private static boolean isRunning = true;

    public RegistrationAlertThread(RegistrationAlertRepository registrationAlertRepository, ExtensionRepository extensionRepository, SipRegistrationRepository sipRegistrationRepository, LocationInSwitchRepository locationInSwitchRepository, IMSIRepository imsiRepository, SCADAAssetRepository scadaAssetRepository, AlertRepository alertRepository) {
        this.registrationAlertRepository = registrationAlertRepository;
        this.extensionRepository = extensionRepository;
        this.sipRegistrationRepository = sipRegistrationRepository;
        this.locationInSwitchRepository = locationInSwitchRepository;
        this.imsiRepository = imsiRepository;
        this.scadaAssetRepository = scadaAssetRepository;
        this.alertRepository = alertRepository;
    }

    @Override
    public void run() {
        try {
            while (isRunning) {
                List extensionsList = (List)this.extensionRepository.findAll();
                if (!extensionsList.isEmpty()) {
                    for (Extension extensionDetails : extensionsList) {
                        if (!StringUtils.hasText((String)extensionDetails.getExtensionType()) || !extensionDetails.getExtensionType().equalsIgnoreCase("phone") && !extensionDetails.getExtensionType().equalsIgnoreCase("agent") && !extensionDetails.getExtensionType().equalsIgnoreCase("fax")) continue;
                        this.processExtension(extensionDetails);
                    }
                } else {
                    logger.info("Extension List is Empty For Process.");
                }
                this.handleScadaaAssetsStatus();
                Thread.sleep(10000L);
            }
        }
        catch (Exception e) {
            logger.error("Error processing registration alerts. Thread will restart in a few seconds: {}", (Object)e.getMessage(), (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    private void processExtension(Extension extensionDetails) {
        try {
            Optional alertDetails = this.registrationAlertRepository.findByExtension(extensionDetails.getExtension());
            Optional sipRegistrationDetails = this.sipRegistrationRepository.findBySipUser(extensionDetails.getExtension());
            Long extensionExpiresTime = null;
            boolean isRegistered = false;
            Long extensionUpdateTime = null;
            if (sipRegistrationDetails.isPresent()) {
                isRegistered = true;
                if (((SipRegistrations)sipRegistrationDetails.get()).getExpires() != null) {
                    extensionExpiresTime = ((SipRegistrations)sipRegistrationDetails.get()).getExpires();
                    extensionUpdateTime = ((SipRegistrations)sipRegistrationDetails.get()).getExpires();
                } else {
                    extensionExpiresTime = Instant.now().getEpochSecond() + 3600L;
                }
            }
            if (alertDetails.isPresent()) {
                this.updateAlert((RegistrationAlert)alertDetails.get(), isRegistered, extensionExpiresTime, extensionUpdateTime);
            } else {
                this.createNewAlert(extensionDetails, isRegistered, extensionExpiresTime, extensionUpdateTime);
            }
            Optional imsiDetails = this.imsiRepository.findByExtensionNumber(extensionDetails.getExtension());
            if (imsiDetails.isPresent() && ((IMSI)imsiDetails.get()).getRegistrationType() != null && ((IMSI)imsiDetails.get()).getRegistrationType() == 2) {
                ((IMSI)imsiDetails.get()).setConnected(Boolean.valueOf(isRegistered));
                this.imsiRepository.save(imsiDetails.get());
            }
        }
        catch (Exception e) {
            logger.error("Error while processing Extension : {} {} {}", (Object)extensionDetails.getExtension(), (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleScadaaAssetsStatus() {
        List assetsList = this.scadaAssetRepository.findAll();
        try {
            if (!assetsList.isEmpty()) {
                for (SCADAAsset asset : assetsList) {
                    String[] extensionList;
                    Alert lastAlert;
                    List isAlertPresent = this.alertRepository.findByAssetId(asset.getId());
                    if (isAlertPresent.isEmpty() || !(lastAlert = (Alert)isAlertPresent.get(isAlertPresent.size() - 1)).getServiceCode().equalsIgnoreCase("ICMP") || lastAlert.getAlertClosedOn() != null || !StringUtils.hasText((String)asset.getExtensionNumber())) continue;
                    for (String extension : extensionList = asset.getExtensionNumber().split(",")) {
                        logger.info("Checking alert for extension: {}", (Object)extension);
                        Optional alertOpt = this.registrationAlertRepository.findByExtension(extension);
                        if (alertOpt.isPresent()) {
                            RegistrationAlert regAlert = (RegistrationAlert)alertOpt.get();
                            regAlert.setConnectionAlertEpoch(lastAlert.getAlertGeneratedOn());
                            regAlert.setExtensionStatus(Boolean.valueOf(false));
                            this.registrationAlertRepository.save((Object)regAlert);
                            logger.info("Updated alert for asset id : {} with extension: {}", (Object)lastAlert.getAssetId(), (Object)extension);
                            continue;
                        }
                        RegistrationAlert newAlert = new RegistrationAlert();
                        newAlert.setExtension(extension);
                        newAlert.setExtensionType(asset.getCategory());
                        newAlert.setAlertCreatedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                        newAlert.setExtensionStatus(Boolean.valueOf(false));
                        newAlert.setConnectionAlertEpoch(lastAlert.getAlertGeneratedOn());
                        newAlert.setAlertStatusUpdatedEpoch(lastAlert.getAlertGeneratedOn());
                        newAlert.setRegistrationExpiresEpoch(Long.valueOf(Instant.now().getEpochSecond() + 3600L));
                        this.registrationAlertRepository.save((Object)newAlert);
                        logger.info("Created New alert for asset id : {} with extension : {}", (Object)lastAlert.getAssetId(), (Object)extension);
                    }
                }
            } else {
                logger.info("No SCADA assets found.");
            }
        }
        catch (Exception e) {
            logger.error("Error while updating status for SCADAAsset. Details: {} {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void updateAlert(RegistrationAlert alert, boolean isRegistered, Long extensionExpiresTime, Long extensionUpdateTime) {
        try {
            if (isRegistered) {
                if (Boolean.FALSE.equals(alert.getExtensionStatus())) {
                    alert.setExtensionStatus(Boolean.valueOf(true));
                    alert.setRegistrationExpiresEpoch(extensionExpiresTime);
                    alert.setAlertStatusUpdatedEpoch(extensionUpdateTime);
                    this.registrationAlertRepository.save((Object)alert);
                    logger.info("Alert updated: {} registered", (Object)alert.getExtension());
                } else if (alert.getRegistrationExpiresEpoch() != null && !alert.getRegistrationExpiresEpoch().equals(extensionExpiresTime)) {
                    alert.setRegistrationExpiresEpoch(extensionExpiresTime);
                    alert.setAlertStatusUpdatedEpoch(extensionUpdateTime);
                    alert.setConnectionAlertEpoch(null);
                    this.registrationAlertRepository.save((Object)alert);
                    logger.info("Alert expiration updated: {}", (Object)alert.getExtension());
                }
            } else {
                alert.setExtensionStatus(Boolean.valueOf(false));
                alert.setAlertStatusUpdatedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                this.registrationAlertRepository.save((Object)alert);
                logger.info("Alert updated: {} unregistered", (Object)alert.getExtension());
            }
        }
        catch (Exception e) {
            logger.error("Error While creating new Alert for : {} {} {}", (Object)alert.getExtension(), (Object)e.getMessage(), (Object)e);
        }
    }

    private void createNewAlert(Extension extensionDetails, boolean isRegistered, Long extensionExpiresTime, Long extensionUpdateTime) {
        RegistrationAlert newAlert = new RegistrationAlert();
        try {
            newAlert.setExtension(extensionDetails.getExtension());
            newAlert.setExtensionType(extensionDetails.getExtensionType());
            newAlert.setAlertCreatedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            newAlert.setExtensionStatus(Boolean.valueOf(isRegistered));
            newAlert.setRegistrationExpiresEpoch(extensionExpiresTime);
            newAlert.setAlertStatusUpdatedEpoch(extensionUpdateTime);
            this.registrationAlertRepository.save((Object)newAlert);
            logger.info("New alert created: {}", (Object)extensionDetails.getExtension());
        }
        catch (Exception e) {
            logger.error("Error While creating new Alert for : {} {} {}", (Object)extensionDetails.getExtension(), (Object)e.getMessage(), (Object)e);
        }
    }
}

