/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.polygon.route.controller;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.InputIdModel;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.service.main.polygon.route.model.RouteModel;
import com.coraltele.telemetry.service.main.polygon.route.service.RouteService;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/route"})
@RestController
public class RouteController {
    @Autowired
    RouteService routeService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody RouteModel data, Principal principal) {
        RequestResponse returnValue = this.routeService.createData(data, principal);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody RouteModel data, Principal principal) {
        RequestResponse returnValue = this.routeService.updateById(data, principal);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id, Principal principal) {
        RequestResponse returnValue = this.routeService.deleteById(id, principal);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAll() {
        RequestResponse returnValue = this.routeService.getAll();
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllArea(@RequestBody SearchRequest searchRequestData) {
        RequestResponse returnValue = this.routeService.getAllRoutes(searchRequestData);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listOfUser/{routeId}"})
    public ResponseEntity<RequestResponse> getAllUsersByRoute(@PathVariable(value="routeId") Integer routeId) {
        return this.getAllUsers(routeId, null);
    }

    @PostMapping(value={"/listOfUserByShapeId/{shapeId}"})
    public ResponseEntity<RequestResponse> getAllUsersByShape(@PathVariable(value="shapeId") String shapeId) {
        return this.getAllUsers(null, shapeId);
    }

    private ResponseEntity<RequestResponse> getAllUsers(Integer routeId, String shapeId) {
        RequestResponse returnValue = this.routeService.getRouteUser(routeId, shapeId);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete/shapeId"})
    public ResponseEntity<RequestResponse> deleteByType(@RequestBody InputIdModel id, Principal principal) {
        RequestResponse returnValue = this.routeService.deleteByType(id, principal);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

