/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.nf_container.service;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.coralnms.nf_container.model.NFContainerModel;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class NFContainerService {
    private static final Logger logger = LogManager.getLogger(NFContainerService.class);
    private static final List<String> EXPECTED_CONTAINERS = Arrays.asList("udr", "udm", "smf", "scp", "pcf", "nssf", "nrf", "bsf", "ausf", "amf");

    public RequestResponse getNFContainersStatus() {
        RequestResponse response = new RequestResponse();
        try {
            logger.info("Fetching NF containers status from Docker");
            List allContainers = this.executeDockerPs(true);
            ArrayList<NFContainerModel> nfContainers = new ArrayList<NFContainerModel>();
            for (String expectedName : EXPECTED_CONTAINERS) {
                NFContainerModel container = this.findContainerByName(allContainers, expectedName);
                if (container != null) {
                    if (container.getStatus().toLowerCase().startsWith("up")) {
                        container.setHealthStatus("ACTIVE");
                    } else {
                        container.setHealthStatus("INACTIVE");
                    }
                    nfContainers.add(container);
                    continue;
                }
                NFContainerModel inactiveContainer = new NFContainerModel();
                inactiveContainer.setContainerName(expectedName);
                inactiveContainer.setHealthStatus("INACTIVE");
                inactiveContainer.setStatus("Not Found");
                inactiveContainer.setContainerId("N/A");
                inactiveContainer.setImage("N/A");
                inactiveContainer.setCommand("N/A");
                inactiveContainer.setCreated("N/A");
                inactiveContainer.setPorts("N/A");
                inactiveContainer.setUptime("N/A");
                nfContainers.add(inactiveContainer);
            }
            response.setData(nfContainers);
            response.setIssue(Constants.NodeStatus.OK);
            response.setStatus(0);
            logger.info("Retrieved {} NF containers status", (Object)nfContainers.size());
        }
        catch (Exception e) {
            logger.error("Error getting NF containers status: {}", (Object)e.getMessage(), (Object)e);
            response.setMessage("Failed to retrieve NF containers status: " + e.getMessage());
            response.setIssue(Constants.NodeStatus.ERROR);
            response.setStatus(1);
        }
        return response;
    }

    private List<NFContainerModel> executeDockerPs(boolean showAll) throws Exception {
        String line;
        ArrayList<NFContainerModel> containers = new ArrayList<NFContainerModel>();
        String command = showAll ? "docker ps -a --no-trunc" : "docker ps --no-trunc";
        logger.debug("Executing command: {}", (Object)command);
        Process process = Runtime.getRuntime().exec(command);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        boolean isFirstLine = true;
        while ((line = reader.readLine()) != null) {
            if (isFirstLine) {
                isFirstLine = false;
                continue;
            }
            NFContainerModel container = this.parseDockerPsLine(line);
            if (container == null) continue;
            containers.add(container);
        }
        StringBuilder errorOutput = new StringBuilder();
        while ((line = errorReader.readLine()) != null) {
            errorOutput.append(line).append("\n");
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            logger.error("Docker command failed with exit code {}: {}", (Object)exitCode, (Object)errorOutput.toString());
            throw new Exception("Docker command failed: " + errorOutput.toString());
        }
        reader.close();
        errorReader.close();
        return containers;
    }

    private NFContainerModel parseDockerPsLine(String line) {
        try {
            String[] parts = line.trim().split("\\s{2,}");
            if (parts.length < 6) {
                logger.warn("Unexpected docker ps output format: {}", (Object)line);
                return null;
            }
            NFContainerModel container = new NFContainerModel();
            container.setContainerId(parts[0].trim());
            container.setImage(parts[1].trim());
            container.setCommand(parts[2].trim());
            container.setCreated(parts[3].trim());
            container.setStatus(parts[4].trim());
            if (parts.length == 6) {
                container.setPorts("");
                container.setContainerName(parts[5].trim());
            } else if (parts.length >= 7) {
                container.setPorts(parts[5].trim());
                container.setContainerName(parts[6].trim());
            }
            container.setUptime(parts[4].trim());
            if (parts[4].toLowerCase().startsWith("up")) {
                container.setHealthStatus("ACTIVE");
            } else {
                container.setHealthStatus("INACTIVE");
            }
            return container;
        }
        catch (Exception e) {
            logger.error("Error parsing docker ps line: {}", (Object)line, (Object)e);
            return null;
        }
    }

    private NFContainerModel findContainerByName(List<NFContainerModel> containers, String name) {
        return containers.stream().filter(c -> c.getContainerName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }
}

