/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.geo_pin.controller;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.geospatial.IMSIGeoTagModel;
import com.coraltele.telemetry.service.coralnms.geo_pin.model.GeoPinModel;
import com.coraltele.telemetry.service.coralnms.geo_pin.model.RadioLinkModel;
import com.coraltele.telemetry.service.coralnms.geo_pin.model.ZoneMessageModel;
import com.coraltele.telemetry.service.coralnms.geo_pin.service.GeoTaggingService;
import com.coraltele.telemetry.service.main.service.UserCoordinateService;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/geoTagging"})
@RestController
public class GeoTaggingController {
    @Autowired
    GeoTaggingService geoTaggingService;
    @Autowired
    UserCoordinateService userCoordinateService;

    @GetMapping(value={"/list/{value}"})
    public ResponseEntity<RequestResponse> list(@PathVariable(value="value") String value) {
        RequestResponse returnValue = this.userCoordinateService.getGeoTagList(value);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/imsi"})
    public ResponseEntity<RequestResponse> imsi(@RequestBody IMSIGeoTagModel data) {
        RequestResponse returnValue = this.geoTaggingService.updateIMSICoordinates(data);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/extensionNumber"})
    public ResponseEntity<RequestResponse> extensionNumber(@RequestBody IMSIGeoTagModel data) {
        RequestResponse returnValue = this.geoTaggingService.updateExtensionCoordinates(data);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> addGeoPin(@RequestBody GeoPinModel data) {
        RequestResponse returnValue = this.geoTaggingService.createGeoPIN(data);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody GeoPinModel data) {
        RequestResponse returnValue = this.geoTaggingService.updateById(data);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/setEmergency/{imsi}"})
    public ResponseEntity<RequestResponse> setEmergency(@PathVariable(value="imsi") String imsi) {
        RequestResponse returnValue = this.geoTaggingService.enableEmergency(imsi);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/clearEmergency/{extensionNumber}"})
    public ResponseEntity<RequestResponse> clearEmergency(@PathVariable(value="extensionNumber") String extensionNumber) {
        RequestResponse returnValue = this.geoTaggingService.clearEmergency(extensionNumber);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete/{id}"})
    public ResponseEntity<RequestResponse> delete(@PathVariable(value="id") Long id) {
        RequestResponse returnValue = this.geoTaggingService.deleteGeoPin(id);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/textMessage"})
    public ResponseEntity<RequestResponse> sendTextMessageToZone(@RequestBody ZoneMessageModel data) {
        RequestResponse returnValue = this.geoTaggingService.sendZoneMessage(data);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/list/cabRadio"})
    public ResponseEntity<RequestResponse> getGeoTagListCabRadio() {
        RequestResponse returnValue = this.geoTaggingService.getGeoTagListCabRadio();
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/list/location"})
    public ResponseEntity<RequestResponse> getGeoTagListCabRadioCoordinates(Principal principal) {
        RequestResponse returnValue = this.geoTaggingService.getGeoTagListCabRadioCoordinates(principal);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/emergencyList"})
    public ResponseEntity<RequestResponse> emergencyListData() {
        RequestResponse returnValue = this.geoTaggingService.getEmergentStatusList();
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/list/locationByZone"})
    public ResponseEntity<RequestResponse> getGeoTaggingListByZone(Principal principal) {
        RequestResponse returnValue = this.geoTaggingService.getGeoTagByZone(principal);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateRadioLink"})
    public ResponseEntity<RequestResponse> updateImsi(@RequestBody RadioLinkModel data) {
        RequestResponse returnValue = this.geoTaggingService.updateIMSI(data);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

